/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tag;

import com.aliasi.corpus.ObjectHandler;
import com.aliasi.tag.NBestTagger;
import com.aliasi.tag.ScoredTagging;
import com.aliasi.tag.TaggerEvaluator;
import com.aliasi.tag.Tagging;
import com.aliasi.util.ObjectToCounterMap;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NBestTaggerEvaluator<E>
implements ObjectHandler<Tagging<E>> {
    private final int mMaxNBest;
    private final int mMaxNBestToString;
    private NBestTagger<E> mTagger;
    private final ObjectToCounterMap<Integer> mNBestHistogram = new ObjectToCounterMap();
    private int mNumCases = 0;
    private long mNumTokens = 0L;
    private int mLastCaseRank;
    private Tagging<E> mLastCase;

    public NBestTaggerEvaluator(NBestTagger<E> tagger, int maxNBest, int maxNBestToString) {
        this.mTagger = tagger;
        this.mMaxNBest = maxNBest;
        this.mMaxNBestToString = maxNBestToString;
    }

    public int maxNBest() {
        return this.mMaxNBest;
    }

    public void setTagger(NBestTagger<E> tagger) {
        this.mTagger = tagger;
    }

    public NBestTagger<E> tagger() {
        return this.mTagger;
    }

    @Override
    public void handle(Tagging<E> referenceTagging) {
        this.mLastCase = referenceTagging;
        Iterator<ScoredTagging<E>> it = this.mTagger.tagNBest(referenceTagging.tokens(), this.mMaxNBest);
        this.addCase(referenceTagging, it);
    }

    public void addCase(Tagging<E> referenceTagging, Iterator<ScoredTagging<E>> responseTaggingIterator) {
        ++this.mNumCases;
        this.mNumTokens += (long)referenceTagging.size();
        this.mLastCase = referenceTagging;
        List<String> expectedTags = referenceTagging.tags();
        for (int i = 0; i < this.mMaxNBest && responseTaggingIterator.hasNext(); ++i) {
            Tagging tagging = responseTaggingIterator.next();
            if (!((Object)expectedTags).equals(tagging.tags())) continue;
            this.mNBestHistogram.increment(i);
            this.mLastCaseRank = i;
            return;
        }
        this.mLastCaseRank = -1;
        this.mNBestHistogram.increment(-1);
    }

    public ObjectToCounterMap<Integer> nBestHistogram() {
        return this.mNBestHistogram;
    }

    public double[] recallAtN() {
        double[] result = new double[this.mMaxNBest];
        double maxNBest = this.mMaxNBest;
        int sum = 0;
        for (int i = 0; i < this.mMaxNBest; ++i) {
            result[i] = (double)(sum += this.mNBestHistogram.getCount(i)) / maxNBest;
        }
        return result;
    }

    public int numCases() {
        return this.mNumCases;
    }

    public long numTokens() {
        return this.mNumTokens;
    }

    public String lastCaseToString(int maxNBestReport) {
        int max = Math.min(maxNBestReport, this.mMaxNBest);
        if (this.numCases() == 0) {
            return "No cases seen yet.";
        }
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        sb.append("Last case n-best reference rank=" + this.mLastCaseRank + "\n");
        sb.append("Last case " + max + "-best:\n");
        sb.append("Correct,Rank,LogJointProb,Tags\n");
        List<E> tokenList = this.mLastCase.tokens();
        Iterator<ScoredTagging<E>> nBestIt = this.mTagger.tagNBest(tokenList, max);
        for (int n = 0; n < max && nBestIt.hasNext(); ++n) {
            sb.append(n == this.mLastCaseRank ? " *** " : "     ");
            ScoredTagging<E> scoredTagging = nBestIt.next();
            double score = scoredTagging.score();
            sb.append(n + "   " + NBestTaggerEvaluator.format(score) + "  ");
            for (int i = 0; i < tokenList.size(); ++i) {
                sb.append(scoredTagging.token(i) + "_" + TaggerEvaluator.pad(scoredTagging.tag(i), 5));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    static String format(double x) {
        return String.format("%9.3f", x);
    }
}

