/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.hmm;

import com.aliasi.hmm.AbstractHmm;
import com.aliasi.lm.LanguageModel;
import com.aliasi.symbol.SymbolTable;
import com.aliasi.util.Math;
import java.io.IOException;
import java.io.ObjectInput;

class CompiledHmmCharLm
extends AbstractHmm {
    private final double[][] mTransitionProbs;
    private final double[][] mTransitionLog2Probs;
    private final double[] mStartProbs;
    private final double[] mStartLog2Probs;
    private final double[] mEndProbs;
    private final double[] mEndLog2Probs;
    private final LanguageModel[] mEmissionLms;

    public CompiledHmmCharLm(ObjectInput in) throws ClassNotFoundException, IOException {
        super((SymbolTable)in.readObject());
        int i;
        int numStates = this.stateSymbolTable().numSymbols();
        this.mTransitionProbs = new double[numStates][numStates];
        this.mTransitionLog2Probs = new double[numStates][numStates];
        for (i = 0; i < numStates; ++i) {
            for (int j = 0; j < numStates; ++j) {
                double d = in.readDouble();
                this.mTransitionProbs[i][j] = d;
                this.mTransitionLog2Probs[i][j] = Math.log2(d);
            }
        }
        this.mEmissionLms = new LanguageModel[numStates];
        for (i = 0; i < numStates; ++i) {
            this.mEmissionLms[i] = (LanguageModel)in.readObject();
        }
        this.mStartProbs = new double[numStates];
        this.mStartLog2Probs = new double[numStates];
        this.mEndProbs = new double[numStates];
        this.mEndLog2Probs = new double[numStates];
        for (i = 0; i < numStates; ++i) {
            this.mStartProbs[i] = in.readDouble();
            this.mStartLog2Probs[i] = Math.log2(this.mStartProbs[i]);
        }
        for (i = 0; i < numStates; ++i) {
            this.mEndProbs[i] = in.readDouble();
            this.mEndLog2Probs[i] = Math.log2(this.mEndProbs[i]);
        }
    }

    public double startProb(String state) {
        int id = this.stateSymbolTable().symbolToID(state);
        return id < 0 ? 0.0 : this.startProb(id);
    }

    public double startProb(int stateId) {
        return this.mStartProbs[stateId];
    }

    public double startLog2Prob(int stateId) {
        return this.mStartLog2Probs[stateId];
    }

    public double endProb(String state) {
        int id = this.stateSymbolTable().symbolToID(state);
        return id < 0 ? 0.0 : this.endProb(id);
    }

    public double endProb(int stateId) {
        return this.mEndProbs[stateId];
    }

    public double endLog2Prob(int stateId) {
        return this.mEndLog2Probs[stateId];
    }

    public double transitProb(String source, String target) {
        int idSrc = this.stateSymbolTable().symbolToID(source);
        if (idSrc < 0) {
            return 0.0;
        }
        int idTarget = this.stateSymbolTable().symbolToID(target);
        return idTarget < 0 ? 0.0 : this.transitProb(idSrc, idTarget);
    }

    public double transitProb(int sourceId, int targetId) {
        return this.mTransitionProbs[sourceId][targetId];
    }

    public double transitLog2Prob(int sourceId, int targetId) {
        return this.mTransitionLog2Probs[sourceId][targetId];
    }

    public double emitProb(String state, CharSequence emission) {
        int id = this.stateSymbolTable().symbolToID(state);
        return id < 0 ? 0.0 : this.emitProb(id, emission);
    }

    public double emitProb(int stateId, CharSequence emission) {
        return java.lang.Math.pow(2.0, this.emitLog2Prob(stateId, emission));
    }

    public double emitLog2Prob(int stateId, CharSequence emission) {
        return this.mEmissionLms[stateId].log2Estimate(emission);
    }
}

