/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import com.aliasi.chunk.CompiledEstimator;
import com.aliasi.tokenizer.TokenCategorizer;
import com.aliasi.util.Strings;
import java.util.Arrays;

final class TokenShapeDecoder {
    private double mLog2Beam;
    private final CompiledEstimator mEstimator;
    private final TokenCategorizer mTokenCategorizer;

    public TokenShapeDecoder(CompiledEstimator estimator, TokenCategorizer categorizer, double pruningThreshold) {
        this.mEstimator = estimator;
        this.mTokenCategorizer = categorizer;
        this.mLog2Beam = pruningThreshold;
    }

    void setLog2Beam(double beam) {
        this.mLog2Beam = beam;
    }

    public String[] decodeTags(String[] tokens) {
        if (tokens == null) {
            return null;
        }
        if (tokens.length == 0) {
            return Strings.EMPTY_STRING_ARRAY;
        }
        TagHistory th = this.decode(tokens);
        Object[] result = new String[tokens.length];
        if (th == null) {
            Arrays.fill(result, "O");
            return result;
        }
        th.toTagArray(this.mEstimator, (String[])result);
        return result;
    }

    private TagHistory decode(String[] tokens) {
        int startTokenID;
        int numTags = this.mEstimator.numTags();
        Object[] history = new TagHistory[numTags];
        double[] historyScore = new double[numTags];
        Object[] nextHistory = new TagHistory[numTags];
        double[] nextHistoryScore = new double[numTags];
        int startTagID = this.mEstimator.tagToID("O");
        int tokenMinus1ID = startTokenID = this.mEstimator.tokenToID(".");
        int tokenMinus2ID = startTokenID;
        int outTagID = this.mEstimator.tagToID("O");
        String token = tokens[0];
        int tokenID = this.mEstimator.tokenToID(token);
        if (tokenID < 0) {
            String tokenCategory = this.mTokenCategorizer.categorize(token);
            tokenID = this.mEstimator.tokenToID(tokenCategory);
        }
        for (int resultTagID = 0; resultTagID < numTags; ++resultTagID) {
            if (this.mEstimator.cannotFollow(resultTagID, startTagID)) {
                historyScore[resultTagID] = Double.NaN;
                continue;
            }
            historyScore[resultTagID] = this.mEstimator.estimate(resultTagID, tokenID, startTagID, tokenMinus1ID, tokenMinus2ID);
            history[resultTagID] = Double.isNaN(historyScore[resultTagID]) ? (TagHistory)null : new TagHistory(resultTagID, null);
        }
        for (int i = 1; i < tokens.length; ++i) {
            double bestScore;
            token = tokens[i];
            tokenID = this.mEstimator.tokenToID(token);
            if (tokenID < 0) {
                String tokenCategory = this.mTokenCategorizer.categorize(token);
                tokenID = this.mEstimator.tokenToID(tokenCategory);
            }
            for (int resultTagID = 0; resultTagID < numTags; ++resultTagID) {
                int bestPreviousTagID = -1;
                bestScore = Double.NaN;
                for (int previousTagID = 0; previousTagID < numTags; ++previousTagID) {
                    double estimate;
                    if (history[previousTagID] == null || this.mEstimator.cannotFollow(resultTagID, previousTagID) || Double.isNaN(estimate = this.mEstimator.estimate(resultTagID, tokenID, previousTagID, tokenMinus1ID, tokenMinus2ID)) || bestPreviousTagID != -1 && !(estimate + historyScore[previousTagID] > bestScore)) continue;
                    bestPreviousTagID = previousTagID;
                    bestScore = estimate + historyScore[previousTagID];
                }
                if (bestPreviousTagID == -1) {
                    nextHistory[resultTagID] = null;
                    continue;
                }
                nextHistory[resultTagID] = new TagHistory(resultTagID, history[bestPreviousTagID]);
                nextHistoryScore[resultTagID] = bestScore;
            }
            int[] startIds = this.mEstimator.startTagIDs();
            int[] interiorIds = this.mEstimator.interiorTagIDs();
            for (int m = 0; m < startIds.length; ++m) {
                if (nextHistory[startIds[m]] == null || nextHistory[interiorIds[m]] == null) continue;
                if (nextHistoryScore[startIds[m]] > nextHistoryScore[interiorIds[m]]) {
                    nextHistoryScore[interiorIds[m]] = Double.NaN;
                    nextHistory[interiorIds[m]] = null;
                    continue;
                }
                nextHistoryScore[startIds[m]] = Double.NaN;
                nextHistory[startIds[m]] = null;
            }
            bestScore = Double.NaN;
            Object bestPreviousHistory = null;
            for (int resultTagID = 0; resultTagID < numTags; ++resultTagID) {
                if (nextHistory[resultTagID] == null || !Double.isNaN(bestScore) && !(nextHistoryScore[resultTagID] > bestScore)) continue;
                bestScore = nextHistoryScore[resultTagID];
                bestPreviousHistory = nextHistory[resultTagID];
            }
            double worstScoreToKeep = bestScore - this.mLog2Beam;
            for (int resultTagID = 0; resultTagID < numTags; ++resultTagID) {
                if (resultTagID == outTagID) {
                    if (nextHistory[outTagID] != null) continue;
                    nextHistory[outTagID] = new TagHistory(outTagID, (TagHistory)bestPreviousHistory);
                    if (!Double.isNaN(nextHistoryScore[outTagID]) && !Double.isInfinite(nextHistoryScore[outTagID])) continue;
                    nextHistoryScore[outTagID] = bestScore;
                    continue;
                }
                if (nextHistory[resultTagID] == null || !(nextHistoryScore[resultTagID] < worstScoreToKeep)) continue;
                nextHistory[resultTagID] = null;
            }
            if (TokenShapeDecoder.allNull(nextHistory)) {
                return null;
            }
            tokenMinus2ID = tokenMinus1ID;
            tokenMinus1ID = tokenID;
            TagHistory[] tempHistory = history;
            double[] tempHistoryScore = historyScore;
            history = nextHistory;
            historyScore = nextHistoryScore;
            nextHistory = tempHistory;
            nextHistoryScore = tempHistoryScore;
        }
        return this.extractBest((TagHistory[])history, historyScore);
    }

    private TagHistory extractBest(TagHistory[] history, double[] historyScore) {
        int bestIndex = -1;
        for (int i = 0; i < history.length; ++i) {
            if (history[i] == null) continue;
            if (bestIndex == -1) {
                bestIndex = i;
                continue;
            }
            if (!(historyScore[i] > historyScore[bestIndex])) continue;
            bestIndex = i;
        }
        return bestIndex == -1 ? null : history[bestIndex];
    }

    private static boolean allNull(Object[] xs) {
        for (int i = 0; i < xs.length; ++i) {
            if (xs[i] == null) continue;
            return false;
        }
        return true;
    }

    private static final class TagHistory {
        private final int mTag;
        private final TagHistory mPreviousHistory;

        public TagHistory(int tag, TagHistory previousHistory) {
            this.mTag = tag;
            this.mPreviousHistory = previousHistory;
        }

        public void toTagArray(CompiledEstimator estimator, String[] result) {
            TagHistory history = this;
            int i = result.length;
            while (--i >= 0) {
                result[i] = estimator.idToTag(history.mTag);
                history = history.mPreviousHistory;
            }
        }
    }
}

