/*
 * Decompiled with CFR 0.152.
 */
package tsg.parsingExp;

import java.io.File;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeSet;
import java.util.Vector;
import tsg.TSNodeLabel;
import tsg.TSNodeLabelFreqInt;
import util.FileUtil;

public class ConvertFragmentsToCFGRulesInt {
    public Hashtable<String, TreeSet<TSNodeLabelFreqInt>> ruleFragmentsTable;
    Vector<TSNodeLabel> ambiguousCFGmappingIndex;
    Hashtable<String, TSNodeLabel> unambiguousCFGmapping;
    File grammarFile;
    File ambiguousFragmentsFile;
    File outputFile;
    String internalFakeNodeLabel;
    String fakePrelexPrefix;

    public ConvertFragmentsToCFGRulesInt(File grammarFile, File ambiguousFragmentsFile, File outputFile, String internalFakeNodeLabel, String fakePrelexPrefix) {
        this.grammarFile = grammarFile;
        this.ambiguousFragmentsFile = ambiguousFragmentsFile;
        this.outputFile = outputFile;
        this.internalFakeNodeLabel = internalFakeNodeLabel;
        this.fakePrelexPrefix = fakePrelexPrefix;
        this.buildRuleFragmentsTable();
        this.dismabiguateMappingAndPrintPCFG();
    }

    public Hashtable<String, TreeSet<TSNodeLabelFreqInt>> getRuleFragmentsTable() {
        return this.ruleFragmentsTable;
    }

    public int getCFGtypes() {
        return this.ruleFragmentsTable.size();
    }

    public Vector<TSNodeLabel> getAmbiguousCFGmapping() {
        return this.ambiguousCFGmappingIndex;
    }

    public Hashtable<String, TSNodeLabel> getunambiguousCFGmapping() {
        return this.unambiguousCFGmapping;
    }

    private void buildRuleFragmentsTable() {
        this.ruleFragmentsTable = new Hashtable();
        Scanner scan = FileUtil.getScanner(this.grammarFile);
        while (scan.hasNextLine()) {
            String fragmentLine = scan.nextLine();
            String[] lineSplit = fragmentLine.split("\t");
            String fragmentString = lineSplit[0];
            int freq = Integer.parseInt(lineSplit[1]);
            TSNodeLabel fragment = null;
            try {
                fragment = new TSNodeLabel(fragmentString, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String treeCFGrule = this.compressToCFGRulePosLex(fragment);
            this.add(treeCFGrule, new TSNodeLabelFreqInt(fragment, freq));
        }
    }

    private String compressToCFGRulePosLex(TSNodeLabel thisNode) {
        StringBuilder sb = new StringBuilder(thisNode.label());
        this.fillStringBuilderWithTerminalsPosLex(thisNode, sb);
        return sb.toString();
    }

    private void fillStringBuilderWithTerminalsPosLex(TSNodeLabel thisNode, StringBuilder sb) {
        if (thisNode.isLexical) {
            sb.append(" " + this.fakePrelexPrefix + thisNode.label());
            return;
        }
        if (thisNode.isTerminal()) {
            sb.append(" " + thisNode.label());
            return;
        }
        TSNodeLabel[] tSNodeLabelArray = thisNode.daughters;
        int n = thisNode.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            this.fillStringBuilderWithTerminalsPosLex(d, sb);
            ++n2;
        }
    }

    public void add(String treeCFGrule, TSNodeLabelFreqInt treeFreq) {
        TreeSet<TSNodeLabelFreqInt> value = this.ruleFragmentsTable.get(treeCFGrule);
        if (value == null) {
            value = new TreeSet();
            this.ruleFragmentsTable.put(treeCFGrule, value);
        }
        value.add(treeFreq);
    }

    private void dismabiguateMappingAndPrintPCFG() {
        this.ambiguousCFGmappingIndex = new Vector();
        this.unambiguousCFGmapping = new Hashtable();
        PrintWriter pwAmbiguous = FileUtil.getPrintWriter(this.ambiguousFragmentsFile);
        PrintWriter pwPCFG = FileUtil.getPrintWriter(this.outputFile);
        pwAmbiguous.println("List of rules mapping to multiple fragments:\n");
        int uniqueAmbiguousFragmentIndex = 0;
        for (Map.Entry<String, TreeSet<TSNodeLabelFreqInt>> e : this.ruleFragmentsTable.entrySet()) {
            String cfgRule = e.getKey();
            TreeSet<TSNodeLabelFreqInt> sortedFragmentsSet = e.getValue();
            if (sortedFragmentsSet.size() == 1) {
                TSNodeLabelFreqInt uniqueFragmentFreq = sortedFragmentsSet.first();
                TSNodeLabel uniqueFragment = uniqueFragmentFreq.tree();
                int freq = uniqueFragmentFreq.freq();
                this.unambiguousCFGmapping.put(cfgRule, uniqueFragment);
                pwPCFG.println(String.valueOf(freq) + "\t" + cfgRule);
                continue;
            }
            pwAmbiguous.println(cfgRule);
            Iterator<TSNodeLabelFreqInt> discIter = sortedFragmentsSet.descendingIterator();
            int firstSpace = cfgRule.indexOf(32);
            String lhs = cfgRule.substring(0, firstSpace);
            String rhs = cfgRule.substring(firstSpace + 1);
            while (discIter.hasNext()) {
                TSNodeLabelFreqInt fragmentFreq = discIter.next();
                TSNodeLabel fragment = fragmentFreq.tree();
                int freq = fragmentFreq.freq();
                String uniqueLabel = String.valueOf(this.internalFakeNodeLabel) + uniqueAmbiguousFragmentIndex++;
                pwAmbiguous.println(String.valueOf(uniqueLabel) + "\t" + fragmentFreq.toString(false, true));
                this.ambiguousCFGmappingIndex.add(fragment);
                String firstRuleUnique = String.valueOf(lhs) + " " + uniqueLabel;
                String secondRuleUnique = String.valueOf(uniqueLabel) + " " + rhs;
                pwPCFG.println(String.valueOf(freq) + "\t" + firstRuleUnique);
                pwPCFG.println("1\t" + secondRuleUnique);
            }
            pwAmbiguous.println();
        }
        pwAmbiguous.close();
        pwPCFG.close();
    }

    public static void main(String[] args) throws Exception {
    }
}

