/*
 * Decompiled with CFR 0.152.
 */
package symbols;

import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import symbols.Symbol;

public class SymbolArray
extends Symbol {
    protected static HashMap<Collection<Symbol>, Integer> IDtableSymbol = new HashMap();
    protected static Vector<Collection<Symbol>> IDtableReverseSymbol = new Vector();
    protected static Vector<SymbolArray> SymbolVector = new Vector();
    protected static int SymbolCounter;

    public static int getSymbolCounter() {
        return SymbolCounter;
    }

    public SymbolArray(Collection<Symbol> symbol) {
        Integer storedId = IDtableSymbol.get(symbol);
        if (storedId == null) {
            storedId = SymbolCounter++;
            IDtableSymbol.put(symbol, storedId);
            IDtableReverseSymbol.add(symbol);
            SymbolVector.add(this);
        }
        this.id = storedId;
    }

    public Collection<Symbol> getOriginalCollection() {
        return IDtableReverseSymbol.get(this.id);
    }

    @Override
    public Object getOriginalObject() {
        return this.getOriginalCollection();
    }

    public void relabel(Collection<Symbol> newSymbol) {
        IDtableSymbol.remove(this.getOriginalCollection());
        Integer storedId = IDtableSymbol.get(newSymbol);
        if (storedId == null) {
            IDtableSymbol.put(newSymbol, this.id);
            IDtableReverseSymbol.set(this.id, newSymbol);
            SymbolVector.set(this.id, this);
        } else {
            this.id = storedId;
        }
    }

    @Override
    public String toString() {
        return this.getOriginalCollection().toString();
    }

    public boolean equals(Object anOtherSymbolArray) {
        if (this == anOtherSymbolArray) {
            return true;
        }
        if (anOtherSymbolArray instanceof SymbolArray) {
            SymbolArray anotherSymbol = (SymbolArray)anOtherSymbolArray;
            return this.id == anotherSymbol.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(SymbolArray anotherSymbol) {
        return this.id == anotherSymbol.id;
    }
}

