#!/bin/bash
#SBATCH --job-name=p3 # create a short name for your job
#SBATCH -p llm
#SBATCH -N 1 # node count
#SBATCH --ntasks-per-node 1 # number of tasks to run per node
#SBATCH --cpus-per-task 8 # cpu-cores per task (>1 if multi-threaded tasks),--cpus-per-task
#SBATCH --gpus-per-node 8 # total gpus for job

OUTPUT_PREFIX=pretrain_hyperlora

torchrun --nproc_per_node=8 pretraining.py \
    --seed 42 \
    --do_train \
    --predict_with_generate \
    --bf16 \
    --n_demonstrations 5 \
    --dataset_name data/p3 \
    --hypelora_name_or_path hf_models/hyperlora-t5-large \
    --hyper_model_name_or_path hf_models/t5-large-lm-adapt \
    --model_name_or_path hf_models/t5-large-lm-adapt \
    --lora_path P3_LORA_PATH \
    --per_device_train_batch_size 16 \
    --gradient_accumulation_steps 1 \
    --learning_rate 5e-5 \
    --preprocessing_num_workers 16 \
    --generation_max_length 128 \
    --num_train_epochs 1 \
    --logging_strategy steps \
    --logging_steps 5 \
    --save_strategy 'steps' \
    --save_steps 0.3 \
    --lr_scheduler_type 'cosine' \
    --warmup_ratio 0.05 \
    --max_seq_length 384 \
    --max_demo_length 1024 \
    --max_answer_length 128 \
    --save_total_limit 4 \
    --greater_is_better True \
    --input_column src_texts \
    --output_column tgt_texts \
    --temperature 8 \
    --loss_beta 0.2 \
    --lora_rank 16 \
    --lora_alpha 8 \
    --lora_target_modules "['q', 'v']" \
    --lora_dropout 0.05 \
    --report_to wandb \
    --run_name ${OUTPUT_PREFIX} \
    --output_dir output/$OUTPUT_PREFIX