
# Env variables and libraries

Two environment variables are required to be stored in a .env file with this format:

```
OPENAI_API_KEY= "your_secret_key"
OPENAI_ORGANIZATION_KEY="your_organization_key"
```

Then `pip install -r requirements.txt`

# Hosting the Feedback apis

```
python api.py --serving_port the port you want to use for your feedback apis
```

# Hosting the chatbot api

```
python seller_bot/api_seller.py --serving_port the port you want to use for your seller api
```


# Testing the feedback apis.

The `test_api.py` is designed to simulate an API call to your feedback apis once they are hosted. It uses the `input.json` file as a request file and returns the responses given by your apis. Can be useful to make sure everything is well set up and all the formats are good.

# Testing the seller api
The `seller_bot/test.py` file is designed to simulate one conversation with the seller bot (from the command line).

# Hyperparameters

All the hard-coded parameters can be set up in the `config.json` file. Some of these parameters are used when generating the feedback (for example the prices determined by the market), and some of them are used only when testing the apis (for example to set up a fictive targetPrice for the buyer when testing the prenegotiation feedback). The seller bot hyperparameters are also determined there.

# Repo organization

This repo has 3 different folders.
```
.
├── feedback_module (in negotiation + post negotiation feedback implementations)
│   
├── prenegotiation_feedback (prenegotiation feedback implementations)
│   
└── seller_bot (seller bot implementation)
```

Each folder has a *modules* file defining the main class functions (for the APIs)

## Feedback module

The main algorithm followed by the feedback module (once the conversation done) can be found in the `turnwise_feedback.py`file. All the other files are category-specific rules, and feedback generation functions.

