
import json
import os
from datasets import load_dataset
import re

task = "task1_test"
print("Loading data...")
test_data = {}
# test.jsonl
with open(os.path.join("/Users/keweicheng/Downloads/open-instruct-main/entailment-bank-v3", "{}.jsonl".format(task))) as fin:
    for line in fin:
        example = json.loads(line)
        if example["depth_of_proof"] not in test_data:
            test_data[example["depth_of_proof"]] = []
            
        test_data[example["depth_of_proof"]].append({
            "story": example['context'],
            "question": example["question"],
            "answer": example["answer"].strip()
        })
        
for task_name, data in test_data.items():
    print (task_name)
    fout = open(os.path.join("data/eval/entailment_bank", "{}.jsonl".format(task_name)), "w")
    for item in data:
        fout.write(json.dumps(item) + "\n") 

    


        