export CUDA_VISIBLE_DEVICES=0

dataset_dir=/path/to/Hansen
model_dir=facebook/wav2vec2-base-960h
#model_dir=facebook/wav2vec2-large-960h-lv60-self
task=Hansen


python main_tent.py --asr $model_dir \
                --steps 10 \
                --dataset_name $task \
                --dataset_dir $dataset_dir \
                --temp 2.5 \
                --episodic \
                --non_blank \
                --em_coef 1.0 \
                --reweight \
                --log_dir exps_tent_$task \
                --lr 2e-4 \
                --extra_noise 0 


python main_sar.py --asr $model_dir \
                --steps 10 \
                --dataset_name $task \
                --dataset_dir $dataset_dir \
                --temp 2.5 \
                --episodic \
                --non_blank \
                --em_coef 1.0 \
                --reweight \
                --log_dir exps_sar_$task \
                --lr 2e-4 \
                --extra_noise 0 


python main_teco.py --asr $model_dir \
                --steps 10 \
                --dataset_name $task \
                --dataset_dir $dataset_dir \
                --temp 2.5 \
                --episodic \
                --non_blank \
                --em_coef 1.0 \
                --reweight \
                --log_dir exps_teco_$task \
                --lr 2e-4 \
                --extra_noise 0 


python main_suta.py --asr $model_dir \
                --steps 10 \
                --dataset_name $task \
                --dataset_dir $dataset_dir \
                --temp 2.5 \
                --episodic \
                --non_blank \
                --em_coef 0.3 \
                --reweight \
                --log_dir exps_suta_$task \
                --lr 2e-4 \
                --extra_noise 0 


python main_cea.py --asr $model_dir \
            --steps 20 \
            --dataset_name $task \
            --dataset_dir $dataset_dir \
            --temp 2.5 \
            --episodic \
            --em_coef 0.3 \
            --reweight \
            --log_dir exps_cea_$task \
            --lr 2e-5 \
            --lr2 2e-4 \
            --non_blank \
            --train_feature \
            --extra_noise 0
            

python main_cea_lm.py --asr $model_dir \
            --steps 20 \
            --dataset_name $task \
            --dataset_dir $dataset_dir \
            --temp 2.5 \
            --episodic \
            --em_coef 0.3 \
            --reweight \
            --log_dir exps_cea_lm_$task \
            --lr 2e-5 \
            --lr2 2e-4 \
            --non_blank \
            --train_feature \
            --extra_noise 0

