theory question_61_7

imports Main

begin

typedecl entity
typedecl event

consts
  Sun :: "entity ⇒ bool"
  CentralBody :: "entity ⇒ bool"
  SolarSystem :: "entity ⇒ bool"
  Star :: "entity ⇒ bool"
  Body :: "entity ⇒ bool"

(* Explanation 1: The Sun is the central body in the solar system. *)
axiomatization where
  explanation_1: "∀x. Sun x ⟶ CentralBody x ∧ SolarSystem x"

(* Explanation 2: The Sun is a star. *)
axiomatization where
  explanation_2: "∀x. Sun x ⟶ Star x"

theorem hypothesis:
  assumes asm: "Body x ∧ SolarSystem x"
  (* Hypothesis: The largest body in our solar system is the Sun. *)
  shows "Sun x"
proof -
  from asm have "SolarSystem x" by simp
  then have "Sun x" using explanation_1 by blast
  then show ?thesis by simp
qed

end
