theory question_87_0

imports Main

begin

typedecl entity
typedecl event

consts
  Tunicates :: "entity ⇒ bool"
  Reproduce :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  SexualReproduction :: "entity ⇒ bool"
  Bulbs :: "entity ⇒ bool"
  Tunicate :: "entity ⇒ bool"
  NonTunicate :: "entity ⇒ bool"

(* Explanation 1: Tunicates reproduce sexually. *)
axiomatization where
  explanation_1: "∀x y e. Tunicates x ∧ Reproduce e ∧ Agent e x ∧ SexualReproduction y"

(* Explanation 2: Bulbs are classified as tunicate or non-tunicate. *)
axiomatization where
  explanation_2: "∀x y. Bulbs x ⟶ (Tunicate y ∨ NonTunicate y)"

theorem hypothesis:
  assumes asm: "Bulbs x"
  (* Hypothesis: Bulbs reproduce sexually. *)
  shows "∃y e. Reproduce e ∧ Agent e x ∧ SexualReproduction y"
proof -
  from asm have "Bulbs x" by simp
  then obtain e1 where e1: "Tunicate y ∨ NonTunicate y" using explanation_2 by blast
  then have "SexualReproduction y" using explanation_1 by blast
  have conclusion: "Reproduce e1 ∧ Agent e1 x ∧ SexualReproduction y" using e1 by simp
  show ?thesis using asm conclusion `SexualReproduction y` by blast
qed

end
