theory question_49_2
imports Main
begin

typedecl entity
typedecl event

consts
  Puddle :: "entity ⇒ bool"
  Water :: "entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"
  Disappears :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Probably :: "bool ⇒ bool"
  Evaporated :: "event ⇒ bool"
  BodyOfWater :: "entity ⇒ bool"
  Liquid :: "entity ⇒ bool"
  All :: "entity ⇒ bool"
  Loses :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Exist :: "entity ⇒ bool"
  Amount :: "entity ⇒ bool"
  Evaporation :: "event ⇒ bool"
  Causes :: "event ⇒ event ⇒ bool"
  Decrease :: "event ⇒ bool"

(* Explanation 1: If a puddle disappears then the water in the puddle probably evaporated. *)
axiomatization where
  explanation_1: "∀x y e1 e2. Puddle x ∧ Water y ∧ In y x ∧ Disappears e1 ∧ Patient e1 x ⟶ Probably (Evaporated e2 ∧ Patient e2 y)"

(* Explanation 2: A body of water is a kind of liquid. *)
axiomatization where
  explanation_2: "∀x. BodyOfWater x ⟶ Liquid x"

(* Explanation 3: A puddle is a kind of body of water. *)
axiomatization where
  explanation_3: "∀x. Puddle x ⟶ BodyOfWater x"

(* Explanation 4: If a body of water loses all water then that body of water does not exist any more. *)
axiomatization where
  explanation_4: "∀x y e1. BodyOfWater x ∧ Water y ∧ All y ∧ Loses e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ ¬Exist x"

(* Explanation 5: Evaporation causes the amount of water in a body of water to decrease. *)
axiomatization where
  explanation_5: "∀x y e1 e2. BodyOfWater x ∧ Water y ∧ Amount y ∧ In y x ∧ Evaporation e1 ⟶ Causes e1 e2 ∧ Decrease e2 ∧ Patient e2 y"

theorem hypothesis:
  (* Premise: at 10 a.m. the sun is shining on a puddle of water on the road. *)
  (* Premise: at 2 p.m. the sun is still shining and the puddle has disappeared. *)
  assumes asm: "Sun x ∧ Puddle y ∧ Water z ∧ On y Road ∧ At 10AM ∧ Shining e ∧ Agent e x ∧ Patient e y" 
                "∃x y e1 e2. Sun x ∧ Puddle y ∧ At 2PM ∧ Shining e1 ∧ Agent e1 x ∧ Disappeared e2 ∧ Patient e2 y"
  (* Hypothesis: The water evaporated. *)
  shows "∃x e. Water x ∧ Evaporated e ∧ Patient e x"
proof -
  from asm obtain e1 where e1: "Disappeared e1 ∧ Patient e1 y" by blast
  then have "Probably (Evaporated e2 ∧ Patient e2 z)" using explanation_1 by blast
  then have "BodyOfWater y" using explanation_3 by simp
  then have "Liquid y" using explanation_2 by simp
  then have "¬Exist y" using explanation_4 by blast
  then have "Causes e1 e2 ∧ Decrease e2 ∧ Patient e2 z" using explanation_5 by blast
  then show ?thesis by blast
qed

end
