theory question_81_9
imports Main
begin

typedecl entity
typedecl event

consts
  ExternalMigration :: "entity ⇒ bool"
  BottleneckEffect :: "entity ⇒ bool"
  Trigger :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Lead :: "event ⇒ bool"
  Occur :: "event ⇒ bool"
  Directly :: "event ⇒ bool"
  With :: "event ⇒ entity ⇒ bool"
  AsConsequence :: "event ⇒ event ⇒ bool"

(* Explanation 1: External migration can trigger the bottleneck effect. *)
axiomatization where
  explanation_1: "∀e x y. ExternalMigration x ∧ BottleneckEffect y ∧ Trigger e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: If external migration triggers the bottleneck effect, it directly leads to the occurrence of the bottleneck effect, ensuring that the bottleneck effect occurs as a direct consequence of the trigger event. *)
axiomatization where
  explanation_2: "∀e1 e2 x y. ExternalMigration x ∧ BottleneckEffect y ∧ Trigger e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ (Lead e2 ∧ Occur e2 ∧ Directly e2 ∧ With e2 y ∧ AsConsequence e2 e1)"

theorem hypothesis:
  assumes asm: "ExternalMigration x ∧ BottleneckEffect y"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃e x y. BottleneckEffect x ∧ ExternalMigration y ∧ Occur e ∧ With e y ∧ Occur e x"
proof -
  from asm have "ExternalMigration x ∧ BottleneckEffect y" by simp
  then obtain e1 where e1: "Trigger e1 ∧ Agent e1 x ∧ Patient e1 y" using explanation_1 by blast
  then have "Lead e2 ∧ Occur e2 ∧ Directly e2 ∧ With e2 y ∧ AsConsequence e2 e1" using explanation_2 e1 by blast
  have conclusion: "Occur e2 ∧ With e2 y ∧ Occur e2 x" using e1 `Lead e2 ∧ Occur e2 ∧ Directly e2 ∧ With e2 y ∧ AsConsequence e2 e1` by simp
  show ?thesis using conclusion by blast
qed

end
