theory question_36_0

imports Main

begin
typedecl entity
typedecl event

consts
  BusyCityStreet :: "entity ⇒ bool"
  Street :: "entity ⇒ bool"
  People :: "entity ⇒ bool"
  LotOf :: "entity ⇒ bool"
  Has :: "entity ⇒ entity ⇒ bool"
  Walking :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  BusyCity :: "entity ⇒ bool"
  Winter :: "entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A busy city street implies the street having a lot of people. *)
axiomatization where
  explanation_1: "∀x. BusyCityStreet x ⟶ (∃y. Street x ∧ People y ∧ LotOf y ∧ Has x y)"

theorem hypothesis:
  (* Premise: People walking down a busy city street in the winter. *)
  assumes asm: "People x ∧ Walking e ∧ Agent e x ∧ Street y ∧ BusyCity y ∧ Winter z ∧ In x y ∧ In x z"
  (* Hypothesis: The street has a lot of people. *)
  shows "∃x y. Street x ∧ People y ∧ LotOf y ∧ Has x y"
proof -
  from asm have "People x ∧ Walking e ∧ Agent e x ∧ Street y ∧ BusyCity y ∧ Winter z" by blast
  then have "Street y ∧ People x ∧ LotOf x ∧ Has y x" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
