import json
import json
import torch

from typing import Optional
import math

def judge_answer(output: Optional[str], answer: str) -> bool:
    if output is None:
        return False
    return output.strip().lower() == answer.strip().lower()


eval_rst_path = ""
with open(eval_rst_path, "r") as f:
    eval_rst = json.load(f)

correct = 0
total = 0
for entry in eval_rst:
    total += 1
    ans_dict = {}
    correct_ans = str(entry['answer'])
    correct_ans = correct_ans.replace(',', '')
    for candidate in entry['candidates']:
        ans = candidate['answer']
        cur_score = candidate['step_scores'][-1]
        if ans not in ans_dict:
            ans_dict[ans] = cur_score
        else:
            ans_dict[ans] = max(cur_score, ans_dict[ans])
    sorted_answer_dict = sorted(ans_dict.items(), key=lambda p:p[1], reverse=True)
    output = sorted_answer_dict[0][0]
    correct += judge_answer(output, correct_ans)

print(correct / total)