import random
from collections import deque
from typing import Deque, List, Optional

from const import CONTENT_SKIP
from Villager import Villager
from Util import Util

from aiwolf import (Agent, ComingoutContentBuilder, Content,
                    DivinedResultContentBuilder, EstimateContentBuilder,
                    GameInfo, GameSetting, Judge, RequestContentBuilder, Role,
                    Species, VoteContentBuilder)
from aiwolf.constant import AGENT_ANY, AGENT_NONE
import openai
import time
import os
import copy
import json
from retry import retry
import re
# openai.api_keyにOpenAIのAPIキーを入れる
openai.api_key = os.environ['OPENAI_API_KEY']
gpt4="gpt-4-1106-preview"
gpt3="gpt-3.5-turbo-1106"
#langchain
from langchain.prompts import PromptTemplate
from langchain.chat_models import ChatOpenAI
from langchain.chains import LLMChain

# 占い
class Seer(Villager):
    """ddhb seer agent."""

    co_date: int # COする日にち
    """Scheduled comingout date."""
    has_co: bool # COしたか
    """Whether or not comingout has done."""
    my_judge_queue: Deque[Judge] # 自身の占い結果キュー
    """Queue of divination results."""
    not_divined_agents: List[Agent] # 占っていないエージェント
    """Agents that have not been divined."""
    werewolves: List[Agent] # 人狼結果のエージェント
    """Found werewolves."""
    strategies: List[bool] # 戦略フラグのリスト
    # ----- 5人村用：結果を変更して報告する -----
    new_target: Agent # 偽の占い対象
    new_result: Species # 偽の占い結果
    my_turn:int=0
    divine_list:[]


    def __init__(self) -> None:
        """Initialize a new instance of ddhbSeer."""
        super().__init__()
        self.co_date = 0
        self.has_co = False
        self.my_judge_queue = deque()
        self.not_divined_agents = []
        self.werewolves = []
        
        self.new_target = AGENT_NONE
        self.new_result = Species.UNC
        self.strategies = []
        self.my_turn=0
        self.divine_list=[]


    def initialize(self, game_info: GameInfo, game_setting: GameSetting) -> None:
        super().initialize(game_info, game_setting)
        self.co_date = 1
        self.has_co = False
        self.my_judge_queue.clear()
        self.not_divined_agents = self.get_others(self.game_info.agent_list)
        self.werewolves.clear()
        self.new_target = AGENT_NONE
        self.new_result = Species.UNC
        
        self.strategies = [True]
        self.strategyA = self.strategies[0] # 戦略A: COする日にちの変更（初日CO）
        self.my_turn=0
        self.divine_list=[]
        # 戦略A: 初日CO
        if self.strategyA:
            self.co_date = 1


    # 昼スタート
    def day_start(self) -> None:
        super().day_start()
        
        self.new_target = AGENT_NONE
        self.new_result = Species.WEREWOLF
        self.my_turn=0
        # 占い結果
        judge: Optional[Judge] = self.game_info.divine_result
        if judge is not None:
            self.my_judge_queue.append(judge) # 結果追加
            # 占い対象を、占っていないエージェントリストから除く
            if judge.target in self.not_divined_agents:
                self.not_divined_agents.remove(judge.target)
            # 黒結果
            if judge.result == Species.WEREWOLF:
                self.werewolves.append(judge.target) # 人狼リストに追加
            # スコアの更新
            self.score_matrix.my_divined(self.game_info, self.game_setting, judge.target, judge.result)


    # CO、結果報告、投票宣言
    def talk(self) -> Content:
        day: int = self.game_info.day
        turn: int = self.talk_turn
        game: int = Util.game_count
        # if self.is_alive(a)でaliveを保証している
        others_seer_co: List[Agent] = [a for a in self.comingout_map if self.is_alive(a) and self.comingout_map[a] == Role.SEER]
        others_co_num: int = len(others_seer_co)
        #self.vote_candidate = self.vote_can()
        talk_history = self.history(self.talk_list_all)
        my_talk_history = self.my_talk_history(self.talk_list_all,self.me)
        for talk in talk_history:
            print("talk:",talk)
            if talk["agent"]==self.me:
                continue
        #print("talk_history:",talk_history)
        print("turn:",self.my_turn)
        if day==1 and turn==0:
            uttr="よろしく"
            self.my_turn+=1
            return uttr
        elif turn<=6:
            #time.sleep(20)
            self.my_turn+=1
            #uttr=self.gpt_talk(talk_history,self.me,self.info,day)
            if self.my_judge_queue:
                judge: Judge = self.my_judge_queue.popleft()
                self.new_target = judge.target.agent_idx
                self.new_result = judge.result
                self.divine_list.append((self.new_target,self.new_result))
            print(self.divine_list)
            time.sleep(10)
            print(talk_history)
            uttr=self.langchain_talk(self.me,day,talk_history,my_talk_history,self.info,self.divine_list)
            return uttr
        else:
            self.my_turn+=1
            return "Skip"
        # ---------- 5人村 ----------
        if self.N == 5:
            if day == 1:
                # ----- CO -----
                if turn == 1:
                    if not self.has_co:
                        self.has_co = True
                        return Content(ComingoutContentBuilder(self.me, Role.SEER))
                # ----- 結果報告 -----
                elif turn == 2:
                    if self.has_co and self.my_judge_queue:
                        judge: Judge = self.my_judge_queue.popleft()
                        self.new_target = judge.target
                        self.new_result = judge.result
                        # 黒結果：そのまま報告
                        if judge.result == Species.WEREWOLF:
                            return Content(DivinedResultContentBuilder(judge.target, judge.result))
                        # 白結果：状況に応じて黒結果を報告
                        elif judge.result == Species.HUMAN:
                            self.new_result = Species.WEREWOLF
                            # 対抗なし：人狼確率＋勝率が高いエージェント
                            if others_co_num == 0:
                                self.new_target = self.role_predictor.chooseStrongLikely(Role.WEREWOLF, self.get_alive_others(self.not_divined_agents), coef=0.1)
                            # 対抗あり：game<50では対抗で人狼っぽいエージェント、game>=50では人狼っぽいエージェント
                            else:
                                if game < 50:
                                    self.new_target = self.role_predictor.chooseMostLikely(Role.WEREWOLF, others_seer_co)
                                else:
                                    self.new_target = self.role_predictor.chooseMostLikely(Role.WEREWOLF, self.get_alive_others(self.not_divined_agents))
                            if self.new_target == AGENT_NONE:
                                self.new_target = judge.target
                                self.new_result = judge.result
                            return Content(DivinedResultContentBuilder(self.new_target, self.new_result))
                # ----- VOTE and REQUEST -----
                elif 3 <= turn <= 9:
                    if turn % 2 == 0:
                        return Content(RequestContentBuilder(AGENT_ANY, Content(VoteContentBuilder(self.new_target))))
                    else:
                        return Content(VoteContentBuilder(self.new_target))
                else:
                    return CONTENT_SKIP
            elif day >= 2:
                # ----- 結果報告 -----
                if turn == 1:
                    if self.has_co and self.my_judge_queue:
                        judge: Judge = self.my_judge_queue.popleft()
                        self.new_target = judge.target
                        self.new_result = judge.result
                        # 黒結果：そのまま報告
                        if judge.result == Species.WEREWOLF:
                            return Content(DivinedResultContentBuilder(judge.target, judge.result))
                        # 白結果：生存者3人だから、残りの1人に黒結果（結果としては等価）
                        # 注意：占い先が噛まれた場合は等価ではない→人狼っぽい方に黒結果
                        elif judge.result == Species.HUMAN:
                            self.new_target = self.role_predictor.chooseMostLikely(Role.WEREWOLF, self.get_alive_others(self.not_divined_agents))
                            self.new_result = Species.WEREWOLF
                            return Content(DivinedResultContentBuilder(self.new_target, self.new_result))
                # 狂人が生きている場合→人狼COでPPを防ぐ
                elif turn == 2 and self.role_predictor.estimate_alive_possessed(threshold=0.5):
                    return Content(ComingoutContentBuilder(self.me, Role.WEREWOLF))
                # ----- VOTE and REQUEST -----
                elif 2 <= turn <= 9:
                    if turn % 2 == 0:
                        return Content(VoteContentBuilder(self.new_target))
                    else:
                        return Content(RequestContentBuilder(AGENT_ANY, Content(VoteContentBuilder(self.new_target))))
                else:
                    return CONTENT_SKIP
            return CONTENT_SKIP
        # ---------- 15人村 ----------
        elif self.N == 15:
            # ---------- CO ----------
            # 絶対にCOする→1,2,3
            # 1: 予定の日にち
            if not self.has_co and day == self.co_date:
                Util.debug_print("占いCO：予定日")
                self.has_co = True
                return Content(ComingoutContentBuilder(self.me, Role.SEER))
            # 2: 人狼発見
            if not self.has_co and self.werewolves:
                Util.debug_print("占いCO：人狼発見")
                self.has_co = True
                return Content(ComingoutContentBuilder(self.me, Role.SEER))
            # 3: 他の占い師がCOしたら(CCO)
            if not self.has_co and others_seer_co:
                Util.debug_print("占いCO：CCO")
                self.has_co = True
                return Content(ComingoutContentBuilder(self.me, Role.SEER)) 
            # ---------- 結果報告 ----------
            if self.has_co and self.my_judge_queue:
                judge: Judge = self.my_judge_queue.popleft()
                # 正しい結果を報告する
                return Content(DivinedResultContentBuilder(judge.target, judge.result))
            # ----- ESTIMATE, VOTE, REQUEST -----
            if 2 <= turn <= 7:
                rnd = random.randint(0, 2)
                if rnd == 0:
                    return Content(EstimateContentBuilder(self.vote_candidate, Role.WEREWOLF))
                elif rnd == 1:
                    return Content(VoteContentBuilder(self.vote_candidate))
                else:
                    return Content(RequestContentBuilder(AGENT_ANY, Content(VoteContentBuilder(self.vote_candidate))))
            else:
                return CONTENT_SKIP
        return CONTENT_SKIP


    # 投票対象
    def vote(self) -> Agent:
        # ----------  同数投票の処理 ----------
        latest_vote_list = self.game_info.latest_vote_list
        if latest_vote_list:
            self.vote_candidate = self.changeVote(latest_vote_list, Role.WEREWOLF)
            return self.vote_candidate if self.vote_candidate != AGENT_NONE else self.me
        # 投票候補
        vote_candidates: List[Agent] = self.get_alive_others(self.game_info.agent_list)
        # if a in vote_candidates としているから、aliveは保証されている
        others_seer_co: List[Agent] = [a for a in self.comingout_map if a in vote_candidates and self.comingout_map[a] == Role.SEER]
        alive_werewolves: List[Agent] = self.get_alive_others(self.werewolves)
        talk_history = self.history(self.talk_list_all)
        day: int = self.game_info.day
        
        # ---------- 5人村 ----------
        if self.N == 5:
            time.sleep(10)
            vote_candidate=self.langchain_vote_json(self.me,day,talk_history,self.info,self.agent_to_index(vote_candidates),self.divine_list)
            print(vote_candidate)
            if type(vote_candidate["target"])==str:
                candidate = re.sub(r"\D","",vote_candidate["target"])
                num=[int(x) for x in list(str(candidate))]
                if len(num)==2:
                    candidate=int(num[1])
                else:
                    candidate=int(num[0])
                self.vote_candidate = candidate
            else:
                candidate = vote_candidate["target"]
                num=[int(x) for x in list(str(candidate))]
                if len(num)==2:
                    candidate=int(num[1])
                else:
                    candidate=int(num[0])
                self.vote_candidate = candidate
            print("vote_candidate:",self.vote_candidate)
            print(self.agent_to_index(vote_candidates))
            if self.vote_candidate in self.agent_to_index(vote_candidates):
                for i in vote_candidates:
                    if i.agent_idx==self.vote_candidate:
                        target=i
            else:
                if len(vote_candidates)!=0:
                    return random.choice(vote_candidates)
                else:
                    choice_agent: List[Agent]=self.get_alive(self.game_info.agent_list)
                    return random.choice(choice_agent)
            print("vote_target:",target)
            return target
            # 投票対象の優先順位：黒結果→偽の黒先→人狼っぽいエージェント
            """if alive_werewolves:
                Util.debug_print("alive_werewolves:\t", self.agent_to_index(alive_werewolves))
                self.vote_candidate = self.role_predictor.chooseMostLikely(Role.WEREWOLF, alive_werewolves)
                #vote_candidate = self.langchain_vote(self.me,day,talk_history,self.info,self.divine_list,vote_candidates)
                #self.vote_candidate = vote_candidate["target"]
                #print("vote_candidate:",self.vote_candidate)
            # 2ターン目の推論だとミスしている可能性があるので、行動学習で推定した結果を使う
            #elif self.new_target != AGENT_NONE:
            #    self.vote_candidate = self.new_target
            else:
                Util.debug_print("vote_candidates:\t", self.agent_to_index(vote_candidates))
                self.vote_candidate = self.role_predictor.chooseMostLikely(Role.WEREWOLF, vote_candidates)
                #vote_candidate = self.langchain_vote(self.me,day,talk_history,self.info,self.divine_list,vote_candidates)
                #self.vote_candidate = vote_candidate["target"]
                #print("vote_candidate:",self.vote_candidate)"""
        # ---------- 15人村 ----------
        elif self.N == 15:
            # 投票対象の優先順位：黒結果→偽占い→人狼っぽいエージェント
            if alive_werewolves:
                Util.debug_print("alive_werewolves:\t", self.agent_to_index(alive_werewolves))
                self.vote_candidate = self.chooseMostlikelyExecuted2(include_list=alive_werewolves)
                # self.vote_candidate = self.role_predictor.chooseMostLikely(Role.WEREWOLF, alive_werewolves)
            elif others_seer_co:
                Util.debug_print("others_seer_co:\t", self.agent_to_index(others_seer_co))
                self.vote_candidate = self.chooseMostlikelyExecuted2(include_list=others_seer_co)
                # self.vote_candidate = self.role_predictor.chooseMostLikely(Role.WEREWOLF, others_seer_co)
            else:
                Util.debug_print("vote_candidates:\t", self.agent_to_index(vote_candidates))
                self.vote_candidate = self.role_predictor.chooseMostLikely(Role.WEREWOLF, vote_candidates)
        # ----- 投票ミスを防ぐ -----
        if self.vote_candidate == AGENT_NONE or self.vote_candidate == self.me:
            Util.debug_print("vote_candidates: AGENT_NONE or self.me")
            self.vote_candidate = self.role_predictor.chooseMostLikely(Role.WEREWOLF, vote_candidates)
        return self.vote_candidate if self.vote_candidate != AGENT_NONE else self.me


    # 占い対象
    def divine(self) -> Agent:
        day: int = self.game_info.day
        game: int = Util.game_count
        divine_candidate: Agent = AGENT_NONE
        talk_history = self.history(self.talk_list_all)
        # 占い候補：占っていないエージェント
        divine_candidates: List[Agent] = self.get_alive_others(self.not_divined_agents)
        print("divine_candisates:",divine_candidates)
        others_co: List[Agent] = [a for a in self.comingout_map if a in divine_candidates and (self.comingout_map[a] == Role.SEER or self.comingout_map[a] == Role.MEDIUM)]
        # 占い候補：占っていないエージェント＋(占いor霊媒)COしていないエージェント
        divine_no_co_candidates: List[Agent] = [a for a in divine_candidates if a not in others_co]
        if day>=1:
            time.sleep(10)
            divine_candidate=self.langchain_divine_json(self.me,day,talk_history,self.info,self.agent_to_index(divine_candidates),self.divine_list)
            print(divine_candidate)
            if type(divine_candidate["target"])==str:
                candidate = re.sub(r"\D","",divine_candidate["target"])
                num=[int(x) for x in list(str(candidate))]
                if len(num)==2:
                    candidate=int(num[1])
                else:
                    candidate=int(num[0])
                self.vote_candidate = candidate
            else:
                candidate = divine_candidate["target"]
                num=[int(x) for x in list(str(candidate))]
                if len(num)==2:
                    candidate=int(num[1])
                else:
                    candidate=int(num[0])
                self.vote_candidate = candidate
            print("divine_candidate:",self.vote_candidate)
            print(self.agent_to_index(divine_candidates))
            if self.vote_candidate in self.agent_to_index(divine_candidates):
                for i in divine_candidates:
                    if i.agent_idx==self.vote_candidate:
                        target=i
            else:
                if len(divine_candidates)!=0:
                    return random.choice(divine_candidates)
                else:
                    return self.me
            print("divine_target:",target)
            return target
        """for talk in self.talk_list_all:
            if talk.agent==self.me:
               analysis = self.gpt_json(talk.text)
               print(analysis)
               if analysis["topic"]=="DIVINATION":
                   divine_candidate=analysis["target"]
                   if divine_candidate=="ANY":
                       continue
                   num=[int(x) for x in list(str(divine_candidate))]
                   if len(num)==2:
                       divine_candidate=int(num[1])
                   print(divine_candidate)
                   print(self.agent_to_index(divine_candidates))
                   if divine_candidate in self.agent_to_index(divine_candidates):
                        for i in divine_candidates:
                            if i.agent_idx==divine_candidate:
                                target=i
                        print("divine_target:",target)
                        return target"""
        # 占い対象：game<50では人狼確率＋勝率が高いエージェント、game>=50では人狼っぽいエージェント
        # game後半は、推論精度が高いため、人狼っぽいエージェントを占う
        if game < 50:
            # divine_candidate = self.role_predictor.chooseStrongLikely(Role.WEREWOLF, divine_candidates, coef=0.5)
            divine_candidate = self.role_predictor.chooseStrongLikely(Role.WEREWOLF, divine_no_co_candidates, coef=0.5)
        else:
            # divine_candidate = self.role_predictor.chooseMostLikely(Role.WEREWOLF, divine_candidates)
            divine_candidate = self.role_predictor.chooseMostLikely(Role.WEREWOLF, divine_no_co_candidates)
        # ---------- 5人村15人村共通 ----------
        # 初日：勝率が高いエージェント（情報がほぼないため）
        # 白結果：味方になる、黒結果：早めに処理できる
        if day == 0:
            divine_candidate = Util.get_strong_agent(divine_candidates)
        Util.debug_print("alive_comingout_map:\t", self.alive_comingout_map_str)
        Util.debug_print(f"占い対象：{divine_candidate}")
        return divine_candidate if divine_candidate != AGENT_NONE else self.me


    #エージェントの状態の作成
    def gpt_info(self):
        info_day=self.game_info.day
        info_alive=""
        for i in self.game_info.alive_agent_list:
            info_alive+=str(i)+","
        print(info_alive)
        info_executed=self.game_info.executed_agent
        info_attacked=None
        if len(self.game_info.last_dead_agent_list)!=0:
            info_attacked=self.game_info.last_dead_agent_list[0]
        text="start_day:"+str(info_day)+","+"alive_agent:"+info_alive+"yesterday_executed_agent:"+str(info_executed)+","+"yesterday_attacked_agent:"+str(info_attacked)+"\n"
        

        return text
    
    #トーク履歴作成
    def history(self,talk_list_all):
        #chatgptに渡す準備
        talk=[]
        dic={"day":-1,"turn":-1,"agent":-1,"text":""}
        talk_day=-1
        talk_turn=-1
        talk_agent=-1
        talk_text=""
        for i in talk_list_all:
            if talk_day==i.day and talk_turn==i.turn and talk_agent==i.agent._agent_idx and talk_text==i.text:
                continue
            else:
                dic['day']=i.day
                dic['turn']=i.turn
                dic['agent']=i.agent._agent_idx
                dic['text']=i.text
                talk.append(copy.deepcopy(dic))
                talk_day=i.day
                talk_turn=i.turn
                talk_agent=i.agent._agent_idx
                talk_text=i.text

        return talk
    
    def my_talk_history(self,talk_list_all,my_idx):
        my_talk=[]
        dic={"day":-1,"turn":-1,"agent":-1,"text":""}
        talk_day=-1
        talk_turn=-1
        talk_agent=-1
        talk_text=""
        for i in talk_list_all:
            if i.agent._agent_idx==my_idx:
                if talk_day==i.day and talk_turn==i.turn and talk_agent==i.agent._agent_idx and talk_text==i.text:
                    continue
                else:
                    dic['day']=i.day
                    dic['turn']=i.turn
                    dic['agent']=i.agent._agent_idx
                    dic['text']=i.text
                    my_talk.append(copy.deepcopy(dic))
                    talk_day=i.day
                    talk_turn=i.turn
                    talk_agent=i.agent._agent_idx
                    talk_text=i.text
        return my_talk
    
    @retry(tries=5,delay=10)
    def gpt_json(self,content):
        prompt="""あなたは返答をすべてJSON形式で出力します。
                与えられた発言に対して、自身のエージェント番号、発言対称のエージェント番号、トピック、テキストをJSON形式でパースしてください。
                JSONのキーはme,target,topic,textとしてください。
                
                meは発言者のエージェント番号とします。わからない場合はUNKNOWNとしてください。
                targetは発言対称のエージェント番号とします。番号のみを出力してください。対象がANYの場合はANY、いない場合はNONEとしてください。
                topicはDUMMY:ダミートピック,ESTIMATE:推測,COMINGOUT:カミングアウト,DIVINATION:占う,DIVINED:占い結果の報告,IDENTIFIED:特定した役職の報告,GUARD:ガード,GUARDED:ガード結果の報告,VOTE:投票,VOTED:投票結果の報告,ATTACK:攻撃,ATTACKED:攻撃結果の報告,AGREE:賛成,DISAGREE:反対,Over:発言の終了,Skip:発言のスキップ,OPERATOR:オペレーターの中から選択してください。
                textは発言内容です。"""
        messages = [
            {"role":"system","content":prompt},
            {"role":"user","content":content}
        ]
        response = openai.ChatCompletion.create(
            model="gpt-3.5-turbo-1106",
            response_format={"type":"json_object"},
            temperature=0,
            request_timeout=30,
            messages=messages,
        )
        if response.choices[0].message.content is None:
            return {}
        else:
            return json.loads(response.choices[0].message.content)
    
    
    @retry()
    def langchain_talk(self,my_id,day,history,my_history,info,divine):
        # OpenAIのモデルのインスタンスを作成
        chat = ChatOpenAI(model_name=gpt4, temperature=0.8,request_timeout=45)

        prompt = PromptTemplate.from_template(
                "あなたはAgent[{my_id}]というプレイヤーで、人狼というゲームを5人でプレイしています。\n"
            + " ゲームルールは {rule} です。\n"
            + "あなたの役職は占い師です。あなたは夜に1人だけ占うことができます。\n"
            +"占い師の戦略は{plan}です。"
            +"今は{day}日目です。\n"
            +"1日目に誰を占うべきか発言してください。\n"
            +"現在までの各エージェントの会話は{history}です。\n"
            +"現在までの自身の発言は{my_history}です。同じような発言はしないようにしてください。\n"
            +"現在の各エージェントの状態は{info}です。\n"
            +"占い結果が与えられます。占い結果は{divine}です。\n"
            + " 与えられた情報をすべて理解したうえで、あなたの発言を１行程度で簡潔に考えてください。"
            +"発言を考える際に、ほかのエージェントと同じ発言や、自身がした発言と同じような発言はしないでください。"
            +"あなたの発言で勝利に導いてください。"
            )

        kwargs = dict(
            my_id=my_id,
            rule="""5人のプレイヤーで村を構成する。村における役職とその人数は、「村人:2人,占い師:1人,人狼:1人,狂人:1人」である。
                村人側の役職
                村人:何も能力を持たない村人側のプレイヤー
                占い師:1日の終わりに1人のプレイヤーを占い、そのプレイヤーが人間であるか人狼であるかを知ることができる。
                
                人狼側の役職
                人狼:1日の終わりに各人狼は人間を1人選択して襲撃投票し、最も多く襲撃されたプレイヤーを襲撃する。
                狂人:村人と同じく能力は何もない人間だが、人狼の勝利を目指して行動する。占い師の能力では人間と判定される。""",
            day=day,
            history=history,
            my_history=my_history,
            info=info,
            divine=divine,
        )


        plan_prediction_chain = LLMChain(llm=chat, prompt=prompt)
        plan = plan_prediction_chain.run(**kwargs)
        plan = plan.strip()

        print(plan.strip())
        return plan.strip()
    
    @retry()
    def gpt_vote_json(self,my_id,day,history,info,vote_candidate,divine):
        rule="""5人のプレイヤーで村を構成する。村における役職とその人数は、「村人:2人,占い師:1人,人狼:1人,裏切者:1人」である。
                村人側の役職
                村人:何も能力を持たない村人側のプレイヤー
                占い師:1日の終わりに1人のプレイヤーを占い、そのプレイヤーが人間であるか人狼であるかを知ることができる。
                
                人狼側の役職
                人狼:1日の終わりに各人狼は人間を1人選択して襲撃投票し、最も多く襲撃されたプレイヤーを襲撃する。
                裏切者:村人と同じく能力は何もない人間だが、人狼の勝利を目指して行動する。占い師の能力では人間と判定される。"""
        
        prompt="""あなたはAgent[{my_id}]というプレイヤーで、人狼というゲームを5人でプレイしています。\n
        あなたは返答をすべてJSON形式で出力します。\n
        与えられた発言に対して、自身のエージェント番号、投票対称のエージェント番号、テキストをJSON形式でパースしてください。\n
        JSONのキーはme,target,textとしてください。
        meは発言者のエージェント番号とします。わからない場合はUNKNOWNとしてください。\n
        targetは投票対称のエージェント番号とします。番号のみを出力してください。投票対象は{vote_candidate}から番号を必ず選んでください。\n
        textは投票対象を選んだ理由です。\n
        ゲームルールは {rule} です。\n
        あなたの役職は占い師です。\n
        占い結果が与えられます。占い結果は{divine}です。\n
        今は{day}日目です。\n
        現在はだれに投票をするかを決めるターンです。投票が一番多かった人が処刑されます。\n
        現在までの各エージェントの会話は{history}です。\n
        現在の各エージェントの状態は{info}です。\n
        与えられた情報をすべて理解したうえで、論理的に推論をして、だれに投票をすればいいかを必ず決めて上記のjson形式で返答してください。""".format(my_id=my_id,day=day,history=history,info=info,vote_candidate=vote_candidate,rule=rule,divine=divine)
        messages = [
            {"role":"system","content":prompt}
        ]
        response = openai.ChatCompletion.create(
            model=gpt3,
            response_format={"type":"json_object"},
            temperature=0,
            request_timeout=30,
            messages=messages,
        )
        if response.choices[0].message.content is None:
            return {}
        else:
            return json.loads(response.choices[0].message.content)
        
    @retry()
    def langchain_vote_json(self,my_id,day,history,info,vote_candidate,divine):

        chat = ChatOpenAI(model_name=gpt4, temperature=1.0,request_timeout=30).bind(response_format={"type": "json_object"})
        
        prompt=PromptTemplate.from_template(
        "あなたはAgent[{my_id}]というプレイヤーで、人狼というゲームを5人でプレイしています。\n"
        +"あなたは返答をすべてJSON形式で出力します。\n"
        +"与えられた発言に対して、自身のエージェント番号、追放投票対称のエージェント番号、テキストをJSON形式でパースしてください。\n"
        +"JSONのキーはme,target,textとしてください。"
        +"meは発言者のエージェント番号とします。わからない場合はUNKNOWNとしてください。\n"
        +"targetは追放投票対称のエージェント番号とします。番号のみを出力してください。追放投票対象は{vote_candidate}から番号を必ず選んでください。\n"
        +"textは追放投票対象を選んだ理由です。\n"
        +"ゲームルールは {rule} です。\n"
        +"あなたの役職は占い師です。\n"
        +"占い結果が与えられます。占い結果は{divine}です。\n"
        +"今は{day}日目です。\n"
        +"現在はだれに追放投票をするかを決めるターンです。追放投票が一番多かった人が処刑されます。\n"
        +"現在までの各エージェントの会話は{history}です。\n"
        +"現在の各エージェントの状態は{info}です。\n"
        +"与えられた情報をすべて理解したうえで、論理的に推論をして、だれに追放投票をすればいいかを必ず決めて上記のjson形式で返答してください。\n"
        +"情報が少ない場合でもだれに投票するかを必ず決めてください。"
        )

        kwargs = dict(
            my_id=my_id,
            rule="""5人のプレイヤーで村を構成する。村における役職とその人数は、「村人:2人,占い師:1人,人狼:1人,狂人:1人」である。
                村人側の役職
                村人:何も能力を持たない村人側のプレイヤー
                占い師:1日の終わりに1人のプレイヤーを占い、そのプレイヤーが人間であるか人狼であるかを知ることができる。
                
                人狼側の役職
                人狼:1日の終わりに各人狼は人間を1人選択して襲撃投票し、最も多く襲撃されたプレイヤーを襲撃する。
                狂人:村人と同じく能力は何もない人間だが、人狼の勝利を目指して行動する。占い師の能力では人間と判定される。
                追放のための投票は昼フェーズの最後に行われます。 有効な投票先（自分以外の生存プレイヤー）以外に投票することは可能ですが， その場合はランダムに投票先が選ばれます。

                追放投票と再投票
                投票によって決定した追放者の情報は， 夜フェーズの占い・護衛・襲撃投票に利用することが可能です。
                最多得票者が複数となった場合は1回に限り再投票となります。
                再投票の前に対話はできません。 再投票でも同点だった場合は再投票での最多得票者からランダムに追放者が決定されます。 
                再投票では，最多得票者も投票権を持ち，投票者は最多得票者以外にも投票可能です。""",
            day=day,
            history=history,
            info=info,
            vote_candidate=vote_candidate,
            divine=divine
        )
        plan_prediction_chain = LLMChain(llm=chat, prompt=prompt)
        plan = plan_prediction_chain.run(**kwargs)
        if plan is None:
            return {}
        else:
            return json.loads(plan)
        
    @retry()
    def gpt_divine_json(self,my_id,day,history,info,divine_candidate,divine):
        rule="""5人のプレイヤーで村を構成する。村における役職とその人数は、「村人:2人,占い師:1人,人狼:1人,裏切者:1人」である。
                村人側の役職
                村人:何も能力を持たない村人側のプレイヤー
                占い師:1日の終わりに1人のプレイヤーを占い、そのプレイヤーが人間であるか人狼であるかを知ることができる。
                
                人狼側の役職
                人狼:1日の終わりに各人狼は人間を1人選択して襲撃投票し、最も多く襲撃されたプレイヤーを襲撃する。
                裏切者:村人と同じく能力は何もない人間だが、人狼の勝利を目指して行動する。占い師の能力では人間と判定される。"""
        
        prompt="""あなたはAgent[{my_id}]というプレイヤーで、人狼というゲームを5人でプレイしています。\n
        あなたは返答をすべてJSON形式で出力します。\n
        与えられた発言に対して、自身のエージェント番号、投票対称のエージェント番号、テキストをJSON形式でパースしてください。\n
        JSONのキーはme,target,textとしてください。
        meは発言者のエージェント番号とします。わからない場合はUNKNOWNとしてください。\n
        targetは占い対称のエージェント番号とします。番号のみを出力してください。占い対象は{divine_candidate}から番号を選んでください。\n
        textは占い対象を選んだ理由です。\n
        ゲームルールは {rule} です。\n
        あなたの役職は占い師です。\n
        占い結果が与えられます。占い結果は{divine}です。\n
        今は{day}日目です。\n
        現在はだれを占うかを決めるターンです。\n
        現在までの各エージェントの会話は{history}です。\n
        現在の各エージェントの状態は{info}です。\n
        与えられた情報をすべて理解したうえで、論理的に推論をして、だれを占えばいいか決めて上記のjson形式で返答してください。""".format(my_id=my_id,day=day,history=history,info=info,divine_candidate=divine_candidate,rule=rule,divine=divine)
        messages = [
            {"role":"system","content":prompt}
        ]
        response = openai.ChatCompletion.create(
            model=gpt3,
            response_format={"type":"json_object"},
            temperature=0,
            request_timeout=30,
            messages=messages,
        )
        if response.choices[0].message.content is None:
            return {}
        else:
            return json.loads(response.choices[0].message.content)
        

    @retry()
    def langchain_divine_json(self,my_id,day,history,info,divine_candidate,divine):

        chat = ChatOpenAI(model_name=gpt4, temperature=1.0,request_timeout=30).bind(response_format={"type": "json_object"})
        
        prompt=PromptTemplate.from_template(
        "あなたはAgent[{my_id}]というプレイヤーで、人狼というゲームを5人でプレイしています。\n"
        +"あなたは返答をすべてJSON形式で出力します。\n"
        +"与えられた発言に対して、自身のエージェント番号、占い対称のエージェント番号、テキストをJSON形式でパースしてください。\n"
        +"JSONのキーはme,target,textとしてください。"
        +"meは発言者のエージェント番号とします。わからない場合はUNKNOWNとしてください。\n"
        +"targetは占い対称のエージェント番号とします。番号のみを出力してください。占い対象は{divine_candidate}から番号を選んでください。\n"
        +"textは占い対象を選んだ理由です。\n"
        +"ゲームルールは {rule} です。\n"
        +"あなたの役職は占い師です。\n"
        +"占い結果が与えられます。占い結果は{divine}です。\n"
        +"今は{day}日目です。\n"
        +"現在はだれを占うかを決めるターンです。\n"
        +"現在までの各エージェントの会話は{history}です。\n"
        +"現在の各エージェントの状態は{info}です。\n"
        +"与えられた情報をすべて理解したうえで、論理的に推論をして、だれを占えばいいか決めて上記のjson形式で返答してください。"
        )

        kwargs = dict(
            my_id=my_id,
            rule="""5人のプレイヤーで村を構成する。村における役職とその人数は、「村人:2人,占い師:1人,人狼:1人,狂人:1人」である。
                村人側の役職
                村人:何も能力を持たない村人側のプレイヤー
                占い師:1日の終わりに1人のプレイヤーを占い、そのプレイヤーが人間であるか人狼であるかを知ることができる。
                
                人狼側の役職
                人狼:1日の終わりに各人狼は人間を1人選択して襲撃投票し、最も多く襲撃されたプレイヤーを襲撃する。
                狂人:村人と同じく能力は何もない人間だが、人狼の勝利を目指して行動する。占い師の能力では人間と判定される。
                追放のための投票は昼フェーズの最後に行われます。 有効な投票先（自分以外の生存プレイヤー）以外に投票することは可能ですが， その場合はランダムに投票先が選ばれます。

                追放投票と再投票
                投票によって決定した追放者の情報は， 夜フェーズの占い・護衛・襲撃投票に利用することが可能です。
                最多得票者が複数となった場合は1回に限り再投票となります。
                再投票の前に対話はできません。 再投票でも同点だった場合は再投票での最多得票者からランダムに追放者が決定されます。 
                再投票では，最多得票者も投票権を持ち，投票者は最多得票者以外にも投票可能です。""",
            day=day,
            history=history,
            info=info,
            divine_candidate=divine_candidate,
            divine=divine
        )
        plan_prediction_chain = LLMChain(llm=chat, prompt=prompt)
        plan = plan_prediction_chain.run(**kwargs)
        if plan is None:
            return {}
        else:
            return json.loads(plan)

        # 投票対象
    def vote_can(self) -> Agent:
        # ----------  同数投票の処理 ----------
        latest_vote_list = self.game_info.latest_vote_list
        if latest_vote_list:
            self.vote_candidate = self.changeVote(latest_vote_list, Role.WEREWOLF)
            return self.vote_candidate if self.vote_candidate != AGENT_NONE else self.me
        # 投票候補
        vote_candidates: List[Agent] = self.get_alive_others(self.game_info.agent_list)
        # if a in vote_candidates としているから、aliveは保証されている
        others_seer_co: List[Agent] = [a for a in self.comingout_map if a in vote_candidates and self.comingout_map[a] == Role.SEER]
        alive_werewolves: List[Agent] = self.get_alive_others(self.werewolves)
        talk_history = self.history(self.talk_list_all)
        day: int = self.game_info.day
        
        # ---------- 5人村 ----------
        if self.N == 5:
            # 投票対象の優先順位：黒結果→偽の黒先→人狼っぽいエージェント
            if alive_werewolves:
                Util.debug_print("alive_werewolves:\t", self.agent_to_index(alive_werewolves))
                self.vote_candidate = self.role_predictor.chooseMostLikely(Role.WEREWOLF, alive_werewolves)
                
            # 2ターン目の推論だとミスしている可能性があるので、行動学習で推定した結果を使う
            # elif self.new_target != AGENT_NONE:
            #     self.vote_candidate = self.new_target
            else:
                Util.debug_print("vote_candidates:\t", self.agent_to_index(vote_candidates))
                self.vote_candidate = self.role_predictor.chooseMostLikely(Role.WEREWOLF, vote_candidates)
                
        # ---------- 15人村 ----------
        elif self.N == 15:
            # 投票対象の優先順位：黒結果→偽占い→人狼っぽいエージェント
            if alive_werewolves:
                Util.debug_print("alive_werewolves:\t", self.agent_to_index(alive_werewolves))
                self.vote_candidate = self.chooseMostlikelyExecuted2(include_list=alive_werewolves)
                # self.vote_candidate = self.role_predictor.chooseMostLikely(Role.WEREWOLF, alive_werewolves)
            elif others_seer_co:
                Util.debug_print("others_seer_co:\t", self.agent_to_index(others_seer_co))
                self.vote_candidate = self.chooseMostlikelyExecuted2(include_list=others_seer_co)
                # self.vote_candidate = self.role_predictor.chooseMostLikely(Role.WEREWOLF, others_seer_co)
            else:
                Util.debug_print("vote_candidates:\t", self.agent_to_index(vote_candidates))
                self.vote_candidate = self.role_predictor.chooseMostLikely(Role.WEREWOLF, vote_candidates)
        # ----- 投票ミスを防ぐ -----
        if self.vote_candidate == AGENT_NONE or self.vote_candidate == self.me:
            Util.debug_print("vote_candidates: AGENT_NONE or self.me")
            self.vote_candidate = self.role_predictor.chooseMostLikely(Role.WEREWOLF, vote_candidates)
        return self.vote_candidate if self.vote_candidate != AGENT_NONE else self.me