PARAMETER_PRESET = ["FVa", "FVb", "FGa", "FGb", "FTa", "FTb", "ST19", "ST14", "ST11", "ST8", "ST7", "SS7", "SD3"]


class HedalParameter:
    def __init__(self, heaan, heaan_type: str, id: str):
        self.heaan = heaan
        self.heaan_type = heaan_type
        self.id = id
        self.params = getattr(heaan.ParameterPreset, id)

    @staticmethod
    def from_preset(id: str, heaan_type: str = "real"):
        if id not in PARAMETER_PRESET:
            raise TypeError("Unsupported ParameterPreset")

        if heaan_type == "real":
            import heaan            
        elif heaan_type == "pi":
            import piheaan as heaan
        else:
            raise TypeError("Unsupported heaan_type")

        return HedalParameter(heaan, heaan_type, id)
