import json

dev_fn = './dev/dev_all_rels.txt'
test_fn = './test/test_all_rels.txt'

for fn in [dev_fn, test_fn]:
	num_pos = 0
	num_neg = 0
	with open(fn, 'r', encoding='utf8') as fp:
		for line in fp:
			line = line.split('\t')
			assert len(line) == 3
			if line[2].lower().strip() == 'true':
				num_pos += 1
			elif line[2].lower().strip() == 'false':
				num_neg += 1
			else:
				raise AssertionError
		print(f"In {fn}, there are {num_pos} positives, {num_neg} negatives!")