import numpy as np # imports a fast numerical programming library
import scipy as sp #imports stats functions, amongst other things
import matplotlib as mpl # this actually imports matplotlib
import matplotlib.cm as cm #allows us easy access to colormaps
import matplotlib.pyplot as plt #sets up plotting under plt
# plt.style.use('ggplot')
from itertools import islice
import pandas as pd #lets us handle data as dataframes
from numpy import argmax
from sklearn.metrics import precision_recall_curve
from sklearn.metrics import f1_score
from sklearn.metrics import auc
from matplotlib import pyplot
from sklearn.metrics import roc_curve
from sklearn.metrics import roc_auc_score
from scipy.interpolate import interp1d
from numpy import sqrt
from matplotlib import pyplot
from matplotlib import gridspec
# sns.set_style("whitegrid")
from sklearn import preprocessing
from sklearn.model_selection import train_test_split
from sklearn.calibration import CalibratedClassifierCV
# Classifier
from sklearn.svm import LinearSVC
from sklearn.svm import SVC

# Result Analysis
from sklearn.externals import joblib
from sklearn.metrics import recall_score, precision_score, confusion_matrix
from sklearn.metrics import accuracy_score, f1_score
from sklearn.model_selection import cross_val_score
from sklearn.model_selection import cross_val_predict
from sklearn import metrics


from tqdm import tqdm
from tqdm._tqdm_notebook import tqdm_notebook
tqdm_notebook.pandas()

# Some useful library
import os
from os.path import isfile

import json
import collections
import re, time , ntpath
import logging
import random
import glob
from pprint import pprint
from copy import deepcopy
from os import listdir
from collections import Counter
from pprint import pprint

from IPython.utils import io
from IPython.display import HTML, display
from ipywidgets import interact, Layout, HBox, VBox, Box
import ipywidgets as widgets
from IPython.display import clear_output

# from scipy.spatial.distance import jensenshannon
# from spacy.lang.en.stop_words import STOP_WORDS
# import en_core_sci_lg
import string

import pandas as pd
import re
import os
# For Ploting
import seaborn as sns

# Word Embedding
from sklearn.feature_extraction.text import CountVectorizer, TfidfVectorizer
from sklearn.model_selection import KFold

# File save
import pickle
import numpy as np
import pandas as pd
from sklearn.model_selection import train_test_split
from sklearn.preprocessing import StandardScaler
from sklearn.metrics import confusion_matrix
from sklearn.metrics import accuracy_score
from sklearn.svm import LinearSVC
import seaborn as sns
import sys
import warnings
from matplotlib import pyplot as plt 
from sklearn.metrics import accuracy_score, f1_score, precision_score, recall_score, classification_report, confusion_matrix
from sklearn.metrics import roc_curve
from sklearn.metrics import roc_auc_score

if not sys.warnoptions:
    warnings.simplefilter("ignore")
from sklearn.model_selection import GridSearchCV 
import os
from pathlib import Path
path = Path(os.getcwd())
# print(path)



def GridSearch(df, FeatureRange, weights):
    c_dict ={}
    iter_dict ={}
    tol_dict ={}
    start_idx_features = FeatureRange['start_idx_features']
    end_idx_features = FeatureRange['end_idx_features']
    idx_outcome = FeatureRange['idx_outcome']
    
    for ff in range(5):
        ## Eliminating all the extra columns from feature list
        features = df.columns
        features = features[start_idx_features : end_idx_features]

        all_genre = df.genre.unique()

        feature_weight= [] ## used to store weights for features
        for i in range(len(features)):
            feature_weight.append(0.0) ## set to zero ## for each iteration of K-fold we will add weights to it

        ## Choose Combined data from Dataset   
        dataframe = df
        dataframe = dataframe.values

        # Get X and Y
        XX = dataframe[:, start_idx_features : end_idx_features].astype(float)
        YY = dataframe[:, idx_outcome]

        ## Normalize input(X)
        from sklearn.preprocessing import normalize
        XX = normalize(XX, axis=0, norm='max')

        ## Prepare encoded(Y)
        from sklearn import preprocessing
        from keras.utils.np_utils import to_categorical
        # encode class values as integers
        encoder = preprocessing.LabelEncoder()
        encoder.fit(YY)
        encoded_YY = encoder.transform(YY)

        kfold = KFold(n_splits=5, shuffle=True, random_state= 53)
        for train_index, test_index in kfold.split(XX):

            ## Taking Test and Train Data For Each Iteration
            x_train, x_test = XX[train_index], XX[test_index]
            ny_train, ny_test = encoded_YY[train_index], encoded_YY[test_index] 

            # Feature Scaling
            scaler = StandardScaler()
            x_train = scaler.fit_transform(x_train)
            x_test = scaler.transform(x_test)

            # defining parameter range 
            param_grid = {'C': [0.0001, 0.001, 0.01, 0.1, 1, 10, 100, 1000]}
            
            grid = GridSearchCV(LinearSVC(class_weight=weights), param_grid, refit = True, scoring  ='f1_weighted', verbose = 1) 

            #fitting the model for grid search 
            grid.fit(x_train, ny_train.ravel())

#             print(grid.best_params_)
            bp = grid.best_params_
            c_val = bp['C']
            if c_val not in c_dict.keys():
                c_dict[c_val] =1
            else:
                c_dict[c_val]+=1

       
    c_dict = {k: v for k, v in sorted(c_dict.items(), key=lambda item: item[1], reverse=True)}


    cx =-1
    for key in c_dict:
        cx= key
        break

    return cx

