import json
import copy
import nltk
from collections import defaultdict


# Download MultiWOZ_2.1 to current dir first
with open('MultiWOZ_2.1/data.json') as f:
	data = json.load(f)

domains = ['taxi', 'police', 'hospital', 'hotel', 'attraction', 'train', 'restaurant']


def is_single_domain(goal):
	cover_domain = []
	for k in goal:
		if k in domains and goal[k]:
			cover_domain.append(k)
	if len(cover_domain) == 1:
		return cover_domain[0]
	else:
		return None
	
# extract only the single domain multiwoz dialog
extracted_data = {k:[] for k in domains}
for k, dial in data.items():
	d = is_single_domain(dial['goal'])
	if d:
		extracted_data[d].append(copy.deepcopy(dial['log']))


for k in extracted_data:
	print(k, len(extracted_data[k]))

import os

class Restaurant:
	def __init__(self):
		self.domain = 'restaurant'
		self.Domain = 'Restaurant'
		if 'data_%s'%self.domain in os.listdir('.'):
			os.remove('data_%s'%self.domain)
		self.file = open('data_%s'%self.domain, 'w+')
		self.semi_slots = ['food', 'pricerange', 'area']
		self.book_slots = ['people', 'day', 'time']
		self.all_slots = ['Food', 'Post', 'Ref', 'Price', 'Phone', 'Area', 'Addr']
	
	def delexiconize(self, usr, spans, entity_dic):
		words = nltk.word_tokenize(usr)
		conflict = defaultdict(set)
		
		for span in spans:
			slot = span[1].lower()
			start = span[3]
			end = span[4] + 1
			words[start:end] = ['v_%s' % slot] * (end - start)
			conflict[(start, end)].add('v_%s' % slot)
		
		new_words = []
		v = None
		for w in words:
			if 'v_' not in w:
				new_words.append(w)
			else:
				if v != w:
					v = w
					new_words.append(w)
					for pair in conflict.values():
						if len(pair) > 1:
							if w in pair:
								for p in pair:
									if p != w:
										new_words.append(p)
		new_sent = ' '.join(new_words)
		for k, v in entity_dic.items():
			if v and v in new_sent:
				new_sent = new_sent.replace(v, 'v_%s' % k)
		return new_sent
	
	
	def write(self, usr):
		usr = usr.replace('v_pricerange', 'v_price')
		self.file.write(usr)
	
	
	def contain(self, ele, lis):
		for a, b in lis:
			if a == ele: return True
		else: return False
		
	def get(self, ele, lis):
		for a, b in lis:
			if a == ele:
				return b
	
	def generate(self, data, is_delexicon=False):
		for dial in data:
			ctt = 1
			for i, turn in enumerate(dial):
				if i % 2 == 0:
					usr = turn['text'].lower()
					usr_sapn = turn['span_info']
					usr_da = turn['dialog_act']
					usr_acts = [k for k in usr_da]
				else:
					ds = turn['metadata'][self.domain]
					sys_da = turn['dialog_act']
					sys_acts = [k for k in sys_da]
					if is_delexicon:
						entity_dic = {k: v for k, v in ds['semi'].items() if k in ['type', 'name']}
						usr = self.delexiconize(usr, usr_sapn, entity_dic)
					
					if '%s-NoOffer'%self.Domain in sys_acts:
						sys = 'api_call'
						for s in self.semi_slots:
							if ds['semi'][s] != 'not mentioned':
								if is_delexicon:
									sys += ' v_%s' % s
								else:
									sys += ' %s' % ds['semi'][s]
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
						self.write('%d NoOffer || %s-NoOffer\n' % (ctt, self.Domain))
						ctt += 1
						
					elif 'Booking-NoBook' in sys_acts:
						sys = 'api_book'
						for s in self.book_slots:
							if s in ds['book']:
								if is_delexicon:
									sys += ' v_%s' % s
								else:
									sys += ' %s' % ds['book'][s]
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
						self.write('%d NoBook || Booking-NoBook\n' % ctt)
						ctt += 1
					
					elif '%s-Inform'%self.Domain in sys_acts and\
							self.contain('Name', sys_da['%s-Inform'%self.Domain]) and\
							ds['semi']['name'] == 'not mentioned':
						sys = 'api_call'
						for s in self.semi_slots:
							if ds['semi'][s] != 'not mentioned':
								if is_delexicon:
									sys += ' v_%s' % s
								else:
									sys += ' %s' % ds['semi'][s]
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
						
					elif 'Booking-Book' in sys_acts:
						sys = 'api_book'
						for s in self.book_slots:
							if s in ds['book']:
								if is_delexicon:
									sys += ' v_%s' % s
								else:
									sys += ' %s' % ds['book'][s]
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
						
					elif '%s-Request'%self.Domain in sys_acts:
						sys_requested_slots = set([s for s, v in sys_da['%s-Request'%self.Domain]])
						sys = 'Request'
						for s in self.all_slots:
							if s in sys_requested_slots:
								sys += ' %s' % s
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
					
					elif 'Booking-Request' in sys_acts:
						sys_requested_slots = set([s for s, v in sys_da['Booking-Request']])
						sys = 'Booking_Request'
						for s in sys_requested_slots:
							sys += ' %s' % s
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
						
					elif '%s-Request'%self.Domain in usr_acts:
						usr_requested_slots = set([s for s,v in usr_da['%s-Request'%self.Domain]])
						# sys_informed_slots = set([s for s,v in sys_da['Restaurant-Inform']])
						sys = 'Inform'
						for s in self.all_slots:# & sys_informed_slots:
							if s in usr_requested_slots:
								sys += ' %s'%s
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
					
					elif 'general-thank' in usr_acts or 'general-bye' in usr_acts or\
						 'general-bye' in sys_acts:
						sys = 'general_bye'
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
						break
					
					elif '%s-Inform'%self.Domain in usr_acts and\
							self.contain('Name', usr_da['%s-Inform'%self.Domain]):
						if is_delexicon:
							sys = 'Inform v_name'
						else:
							sys = 'Inform %s'% ds['semi']['name']
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
					
					elif '%s-Inform'%self.Domain in sys_da and\
							self.contain('Choice', sys_da['%s-Inform'%self.Domain]):
						sys = 'api_call'
						for s in self.semi_slots:
							if ds['semi'][s] != 'not mentioned':
								if is_delexicon:
									sys += ' v_%s' % s
								else:
									sys += ' %s' % ds['semi'][s]
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
						
					elif '%s-Recommend'%self.Domain in sys_da and\
							(self.contain('Name', sys_da['%s-Recommend'%self.Domain]) or
							 self.contain('Choice', sys_da['%s-Recommend'%self.Domain])):
						sys = 'api_call'
						for s in self.semi_slots:
							if ds['semi'][s] != 'not mentioned':
								if is_delexicon:
									sys += ' v_%s' % s
								else:
									sys += ' %s' % ds['semi'][s]
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
					
					elif sys_acts == ['%s-Inform'%self.Domain]:
						sys_informed_slots = set([s for s, v in sys_da['%s-Inform'%self.Domain]])
						# sys_informed_slots = set([s for s,v in sys_da['Restaurant-Inform']])
						sys = 'Inform'
						for s in self.all_slots:  # & sys_informed_slots:
							if s in sys_informed_slots:
								sys += ' %s' % s
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
			self.write('\n')


class Train:
	def __init__(self):
		self.domain = 'train'
		self.Domain = 'Train'
		if 'data_%s' % self.domain in os.listdir('.'):
			os.remove('data_%s' % self.domain)
		self.file = open('data_%s' % self.domain, 'w+')
		self.semi_slots = ['leaveAt', 'destination', 'day', 'arriveBy', 'departure']
		self.book_slots = ['people']
		self.all_slots = ['Day', 'Arrive', 'Leave', 'Ref', 'Time', 'Depart', 'Dest', 'Ticket', 'Id', 'People']
	
	def delexiconize(self, usr, spans, entity_dic):
		words = nltk.word_tokenize(usr)
		conflict = defaultdict(set)
		
		for span in spans:
			slot = span[1].lower()
			start = span[3]
			end = span[4] + 1
			words[start:end] = ['v_%s' % slot] * (end - start)
			conflict[(start, end)].add('v_%s' % slot)
		
		new_words = []
		v = None
		for w in words:
			if 'v_' not in w:
				new_words.append(w)
			else:
				if v != w:
					v = w
					new_words.append(w)
					for pair in conflict.values():
						if len(pair) > 1:
							if w in pair:
								for p in pair:
									if p != w:
										new_words.append(p)
		new_sent = ' '.join(new_words)
		for k, v in entity_dic.items():
			if v and v in new_sent:
				new_sent = new_sent.replace(v, 'v_%s' % k)
		return new_sent
	
	def write(self, usr):
		usr = usr.replace('london liverpool', 'v_departure')
		usr = usr.replace('v_leaveAt', 'v_leave')
		usr = usr.replace('v_arriveBy', 'v_arrive')
		usr = usr.replace('v_departure', 'v_depart')
		usr = usr.replace('v_destination', 'v_dest')
		usr = usr.replace('leaving any time', 'leaving v_leave time')
		self.file.write(usr)
	
	def contain(self, ele, lis):
		for a, b in lis:
			if a == ele: return True
		else:
			return False
	
	def get(self, ele, lis):
		for a, b in lis:
			if a == ele:
				return b
	
	def generate(self, data, is_delexicon=False):
		for dial in data:
			ctt = 1
			for i, turn in enumerate(dial):
				if i % 2 == 0:
					usr = turn['text'].lower()
					usr_sapn = turn['span_info']
					usr_da = turn['dialog_act']
					usr_acts = [k for k in usr_da]
				else:
					ds = turn['metadata'][self.domain]
					sys_da = turn['dialog_act']
					sys_acts = [k for k in sys_da]
					if is_delexicon:
						entity_dic = {k: v for k, v in ds['semi'].items() if k in ['destination', 'departure']}
						usr = self.delexiconize(usr, usr_sapn, entity_dic)
					
					if 'Train-NoOffer' in sys_acts:
						sys = 'api_call'
						for s in self.semi_slots:
							if ds['semi'][s] != 'not mentioned':
								if is_delexicon:
									sys += ' v_%s' % s
								else:
									sys += ' %s' % ds['semi'][s]
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
						self.write('%d NoOffer || Train-NoOffer\n' % ctt)
						ctt += 1
					
					if 'Train-OfferBooked' in sys_acts:
						sys = 'api_book'
						for s in self.book_slots:
							if ds['book'][s] != '':
								if is_delexicon:
									sys += ' v_%s' % s
								else:
									sys += ' %s' % ds['book'][s]
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
						
					
					
					elif 'Train-Inform' in sys_acts and \
							self.contain('Id', sys_da['Train-Inform']):
						sys = 'api_call'
						for s in self.semi_slots:
							if ds['semi'][s] != 'not mentioned':
								if is_delexicon:
									sys += ' v_%s' % s
								else:
									sys += ' %s' % ds['semi'][s]
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
					
					elif 'Train-Inform' in sys_acts and \
							self.contain('Choice', sys_da['Train-Inform']):
						sys = 'api_call'
						for s in self.semi_slots:
							if ds['semi'][s] != 'not mentioned':
								if is_delexicon:
									sys += ' v_%s' % s
								else:
									sys += ' %s' % ds['semi'][s]
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
						
					elif 'Train-Request' in usr_acts:
						usr_requested_slots = set([s for s, v in usr_da['Train-Request']])
						# sys_informed_slots = set([s for s,v in sys_da['Restaurant-Inform']])
						sys = 'Inform'
						for s in self.all_slots:  # & sys_informed_slots:
							if s in usr_requested_slots:
								sys += ' %s' % s
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
					
					elif 'Train-Request' in sys_acts:
						sys_requested_slots = set([s for s, v in sys_da['Train-Request']])
						sys = 'Request'
						for s in self.all_slots:
							if s in sys_requested_slots:
								sys += ' %s' % s
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
					
					
					elif 'general-thank' in usr_acts or 'general-bye' in usr_acts or \
							'general-bye' in sys_acts:
						sys = 'general_bye'
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
						break
					
					# elif 'Train-Inform' in usr_acts and \
					# 		self.contain('Id', usr_da['Train-Inform']):
					# 	if is_delexicon:
					# 		sys = 'Inform v_name'
					# 	else:
					# 		sys = 'Inform %s' % ds['semi']['name']
					# 	self.write('%d %s || %s\n' % (ctt, usr, sys))
					# 	ctt += 1
					
					# elif 'Train-Inform' in sys_da and \
					# 		self.contain('Choice', sys_da['Train-Inform']):
					# 	sys = 'api_call'
					# 	for s in self.semi_slots:
					# 		if ds['semi'][s] != 'not mentioned':
					# 			if is_delexicon:
					# 				sys += ' v_%s' % s
					# 			else:
					# 				sys += ' %s' % ds['semi'][s]
					# 	self.write('%d %s || %s\n' % (ctt, usr, sys))
					# 	ctt += 1
					
					elif 'Train-Recommend' in sys_da and \
							(self.contain('Id', sys_da['Train-Recommend']) or
							 self.contain('Choice', sys_da['Train-Recommend'])):
						sys = 'api_call'
						for s in self.semi_slots:
							if ds['semi'][s] != 'not mentioned':
								if is_delexicon:
									sys += ' v_%s' % s
								else:
									sys += ' %s' % ds['semi'][s]
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
					
					elif sys_acts == ['Train-Inform']:
						sys_informed_slots = set([s for s, v in sys_da['Train-Inform']])
						# sys_informed_slots = set([s for s,v in sys_da['Restaurant-Inform']])
						sys = 'Inform'
						for s in self.all_slots:  # & sys_informed_slots:
							if s in sys_informed_slots:
								sys += ' %s' % s
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
			
			# else:
			# 	print('usr:', usr)
			# 	print(usr_da)
			# 	print('sys:', turn['text'])
			# 	print(ds)
			# 	print(sys_da)
			self.write('\n')


class Attraction:
	def __init__(self):
		self.domain = 'attraction'
		self.Domain = 'Attraction'
		if 'data_%s' % self.domain in os.listdir('.'):
			os.remove('data_%s' % self.domain)
		self.file = open('data_%s' % self.domain, 'w+')
		self.semi_slots = ['type', 'area']
		self.book_slots = []
		self.all_slots = ['Addr', 'Type', 'Phone', 'Price', 'Open', 'Post', 'Area', 'Fee']
	
	
	def delexiconize(self, usr, spans, entity_dic):
		words = nltk.word_tokenize(usr)
		conflict = defaultdict(set)
		
		for span in spans:
			slot = span[1].lower()
			start = span[3]
			end = span[4] + 1
			words[start:end] = ['v_%s' % slot] * (end - start)
			conflict[(start, end)].add('v_%s' % slot)
		
		new_words = []
		v = None
		for w in words:
			if 'v_' not in w:
				new_words.append(w)
			else:
				if v != w:
					v = w
					new_words.append(w)
					for pair in conflict.values():
						if len(pair) > 1:
							if w in pair:
								for p in pair:
									if p != w:
										new_words.append(p)
		new_sent = ' '.join(new_words)
		for k, v in entity_dic.items():
			if v and v in new_sent:
				new_sent = new_sent.replace(v, 'v_%s'%k)
		return new_sent
		
	def write(self, usr):
		usr = usr.replace(' sports ', ' v_type ')
		self.file.write(usr)
	
	def contain(self, ele, lis):
		for a, b in lis:
			if a == ele: return True
		else:
			return False
	
	def get(self, ele, lis):
		for a, b in lis:
			if a == ele:
				return b
	
	def generate(self, data, is_delexicon=False):
		for dial in data:
			ctt = 1
			for i, turn in enumerate(dial):
				if i % 2 == 0:
					usr = turn['text'].lower()
					usr_sapn = turn['span_info']
					usr_da = turn['dialog_act']
					usr_acts = [k for k in usr_da]
				else:
					ds = turn['metadata'][self.domain]
					sys_da = turn['dialog_act']
					sys_acts = [k for k in sys_da]
					if is_delexicon:
						entity_dic = {k:v for k, v in ds['semi'].items() if k in ['type', 'name']}
						usr = self.delexiconize(usr, usr_sapn, entity_dic)
					
					
					if '%s-NoOffer' % self.Domain in sys_acts:
						sys = 'api_call'
						for s in self.semi_slots:
							if ds['semi'][s] != 'not mentioned':
								if is_delexicon:
									sys += ' v_%s' % s
								else:
									sys += ' %s' % ds['semi'][s]
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
						self.write('%d NoOffer || %s-NoOffer\n' % (ctt, self.Domain))
						ctt += 1
					
					elif 'Booking-NoBook' in sys_acts:
						sys = 'api_book'
						for s in self.book_slots:
							if s in ds['book']:
								if is_delexicon:
									sys += ' v_%s' % s
								else:
									sys += ' %s' % ds['book'][s]
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
						self.write('%d NoBook || Booking-NoBook\n' % ctt)
						ctt += 1
						
					elif '%s-Request' % self.Domain in usr_acts and\
							'%s-Inform' % self.Domain in sys_acts:
						usr_requested_slots = set([s for s, v in usr_da['%s-Request' % self.Domain]])
						# sys_informed_slots = set([s for s,v in sys_da['Restaurant-Inform']])
						sys = 'Inform'
						for s in self.all_slots:  # & sys_informed_slots:
							if s in usr_requested_slots:
								sys += ' %s' % s
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
					
					elif '%s-Inform' % self.Domain in sys_acts and \
							self.contain('Name', sys_da['%s-Inform' % self.Domain]) and \
							ds['semi']['name'] == 'not mentioned':
						sys = 'api_call'
						for s in self.semi_slots:
							if ds['semi'][s] != 'not mentioned':
								if is_delexicon:
									sys += ' v_%s' % s
								else:
									sys += ' %s' % ds['semi'][s]
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
						
					elif '%s-Inform' % self.Domain in sys_acts and \
							self.contain('Choice', sys_da['%s-Inform' % self.Domain]) and \
							ds['semi']['name'] == 'not mentioned':
						sys = 'api_call'
						for s in self.semi_slots:
							if ds['semi'][s] != 'not mentioned':
								if is_delexicon:
									sys += ' v_%s' % s
								else:
									sys += ' %s' % ds['semi'][s]
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
					
					
					elif 'Booking-Book' in sys_acts:
						sys = 'api_book'
						for s in self.book_slots:
							if s in ds['book']:
								if is_delexicon:
									sys += ' v_%s' % s
								else:
									sys += ' %s' % ds['book'][s]
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
						
					elif 'general-thank' in usr_acts or 'general-bye' in usr_acts or \
							'general-bye' in sys_acts:
						sys = 'general_bye'
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
						break
					
					elif '%s-Request' % self.Domain in sys_acts:
						sys_requested_slots = set([s for s, v in sys_da['%s-Request' % self.Domain]])
						sys = 'Request'
						for s in self.all_slots:
							if s in sys_requested_slots:
								sys += ' %s' % s
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
					
					elif 'Booking-Request' in sys_acts:
						sys_requested_slots = set([s for s, v in sys_da['Booking-Request']])
						sys = 'Booking_Request'
						for s in sys_requested_slots:
							sys += ' %s' % s
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
					
					elif '%s-Inform' % self.Domain in usr_acts and \
							self.contain('Name', usr_da['%s-Inform' % self.Domain]):
						if is_delexicon:
							sys = 'Inform v_name'
						else:
							sys = 'Inform %s' % ds['semi']['name']
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
					
					elif '%s-Inform' % self.Domain in sys_da and \
							self.contain('Choice', sys_da['%s-Inform' % self.Domain]):
						sys = 'api_call'
						for s in self.semi_slots:
							if ds['semi'][s] != 'not mentioned':
								if is_delexicon:
									sys += ' v_%s' % s
								else:
									sys += ' %s' % ds['semi'][s]
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
					
					elif '%s-Recommend' % self.Domain in sys_da and \
							(self.contain('Name', sys_da['%s-Recommend' % self.Domain]) or
							 self.contain('Choice', sys_da['%s-Recommend' % self.Domain])):
						sys = 'api_call'
						for s in self.semi_slots:
							if ds['semi'][s] != 'not mentioned':
								if is_delexicon:
									sys += ' v_%s' % s
								else:
									sys += ' %s' % ds['semi'][s]
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
					
					elif '%s-Select' % self.Domain in sys_da and \
							self.contain('Name', sys_da['%s-Select' % self.Domain]):
						sys = 'api_call'
						for s in self.semi_slots:
							if ds['semi'][s] != 'not mentioned':
								if is_delexicon:
									sys += ' v_%s' % s
								else:
									sys += ' %s' % ds['semi'][s]
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
					
					elif sys_acts == ['%s-Inform' % self.Domain]:
						sys_informed_slots = set([s for s, v in sys_da['%s-Inform' % self.Domain]])
						# sys_informed_slots = set([s for s,v in sys_da['Restaurant-Inform']])
						sys = 'Inform'
						for s in self.all_slots:  # & sys_informed_slots:
							if s in sys_informed_slots:
								sys += ' %s' % s
						self.write('%d %s || %s\n' % (ctt, usr, sys))
						ctt += 1
					
					
			self.write('\n')


class Hotel:
	def __init__(self):
		self.domain = 'hotel'
		self.Domain = 'Hotel'
		if 'data_%s' % self.domain in os.listdir('.'):
			os.remove('data_%s' % self.domain)
		self.file = open('data_%s' % self.domain, 'w+')
		self.semi_slots = ['area', 'parking', 'pricerange', 'stars', 'internet', 'type']
		self.book_slots = ['stay', 'day', 'people']
		self.all_slots = ['Stars', 'Post', 'Price', 'Phone', 'Addr', 'Parking', 'Area', 'Internet', 'Type', 'Ref']
	
	def delexiconize(self, usr, spans, entity_dic):
		words = nltk.word_tokenize(usr)
		conflict = defaultdict(set)
		
		for span in spans:
			slot = span[1].lower()
			start = span[3]
			end = span[4] + 1
			words[start:end] = ['v_%s' % slot] * (end - start)
			conflict[(start, end)].add('v_%s' % slot)
		
		new_words = []
		v = None
		for w in words:
			if 'v_' not in w:
				new_words.append(w)
			else:
				if v != w:
					v = w
					new_words.append(w)
					for pair in conflict.values():
						if len(pair) > 1:
							if w in pair:
								for p in pair:
									if p != w:
										new_words.append(p)
		new_sent = ' '.join(new_words)
		for k, v in entity_dic.items():
			if v and v in new_sent:
				new_sent = new_sent.replace(v, 'v_%s' % k)
		return new_sent
	
	def write(self, usr):
		usr = usr.replace('v_pricerange', 'v_price')
		self.file.write(usr)
	
	def contain(self, ele, lis):
		for a, b in lis:
			if a == ele: return True
		else:
			return False
	
	def get(self, ele, lis):
		for a, b in lis:
			if a == ele:
				return b
	
	def generate(self, data, is_delexicon=False):
		for dial in data:
			ctt = 1
			for i, turn in enumerate(dial):
				if i % 2 == 0:
					usr = turn['text'].lower()
					usr_sapn = turn['span_info']
					usr_da = turn['dialog_act']
					usr_acts = [k for k in usr_da]
				else:
					ds = turn['metadata'][self.domain]
					sys_da = turn['dialog_act']
					sys_acts = [k for k in sys_da]
					if is_delexicon:
						entity_dic = {k: v for k, v in ds['semi'].items() if k in ['type', 'name']}
						usr = self.delexiconize(usr, usr_sapn, entity_dic)
						
						if '%s-NoOffer' % self.Domain in sys_acts:
							sys = 'api_call'
							for s in self.semi_slots:
								if ds['semi'][s] != 'not mentioned':
									if is_delexicon:
										sys += ' v_%s' % s
									else:
										sys += ' %s' % ds['semi'][s]
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
							self.write('%d NoOffer || %s-NoOffer\n' % (ctt, self.Domain))
							ctt += 1
						
						elif 'Booking-NoBook' in sys_acts:
							sys = 'api_book'
							for s in self.book_slots:
								if s in ds['book']:
									if is_delexicon:
										sys += ' v_%s' % s
									else:
										sys += ' %s' % ds['book'][s]
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
							self.write('%d NoBook || Booking-NoBook\n' % ctt)
							ctt += 1
						
						elif '%s-Inform' % self.Domain in sys_acts and \
								self.contain('Name', sys_da['%s-Inform' % self.Domain]) and \
								ds['semi']['name'] == 'not mentioned':
							sys = 'api_call'
							for s in self.semi_slots:
								if ds['semi'][s] != 'not mentioned':
									if is_delexicon:
										sys += ' v_%s' % s
									else:
										sys += ' %s' % ds['semi'][s]
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif 'Booking-Book' in sys_acts:
							sys = 'api_book'
							for s in self.book_slots:
								if s in ds['book']:
									if is_delexicon:
										sys += ' v_%s' % s
									else:
										sys += ' %s' % ds['book'][s]
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif '%s-Request' % self.Domain in sys_acts:
							sys_requested_slots = set([s for s, v in sys_da['%s-Request' % self.Domain]])
							sys = 'Request'
							for s in self.all_slots:
								if s in sys_requested_slots:
									sys += ' %s' % s
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif 'Booking-Request' in sys_acts:
							sys_requested_slots = set([s for s, v in sys_da['Booking-Request']])
							sys = 'Booking_Request'
							for s in sys_requested_slots:
								sys += ' %s' % s
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif '%s-Request' % self.Domain in usr_acts:
							usr_requested_slots = set([s for s, v in usr_da['%s-Request' % self.Domain]])
							# sys_informed_slots = set([s for s,v in sys_da['Restaurant-Inform']])
							sys = 'Inform'
							for s in self.all_slots:  # & sys_informed_slots:
								if s in usr_requested_slots:
									sys += ' %s' % s
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif 'general-thank' in usr_acts or 'general-bye' in usr_acts or \
								'general-bye' in sys_acts:
							sys = 'general_bye'
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
							break
						
						elif '%s-Inform' % self.Domain in usr_acts and \
								self.contain('Name', usr_da['%s-Inform' % self.Domain]):
							if is_delexicon:
								sys = 'Inform v_name'
							else:
								sys = 'Inform %s' % ds['semi']['name']
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif '%s-Inform' % self.Domain in sys_da and \
								self.contain('Choice', sys_da['%s-Inform' % self.Domain]):
							sys = 'api_call'
							for s in self.semi_slots:
								if ds['semi'][s] != 'not mentioned':
									if is_delexicon:
										sys += ' v_%s' % s
									else:
										sys += ' %s' % ds['semi'][s]
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif '%s-Recommend' % self.Domain in sys_da and \
								(self.contain('Name', sys_da['%s-Recommend' % self.Domain]) or
								 self.contain('Choice', sys_da['%s-Recommend' % self.Domain])):
							sys = 'api_call'
							for s in self.semi_slots:
								if ds['semi'][s] != 'not mentioned':
									if is_delexicon:
										sys += ' v_%s' % s
									else:
										sys += ' %s' % ds['semi'][s]
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif sys_acts == ['%s-Inform' % self.Domain]:
							sys_informed_slots = set([s for s, v in sys_da['%s-Inform' % self.Domain]])
							# sys_informed_slots = set([s for s,v in sys_da['Restaurant-Inform']])
							sys = 'Inform'
							for s in self.all_slots:  # & sys_informed_slots:
								if s in sys_informed_slots:
									sys += ' %s' % s
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
			self.write('\n')


class Hospital:
	def __init__(self):
		self.domain = 'hospital'
		self.Domain = self.domain[0:1].upper()+self.domain[1:]
		if 'data_%s' % self.domain in os.listdir('.'):
			os.remove('data_%s' % self.domain)
		self.file = open('data_%s' % self.domain, 'w+')
		self.semi_slots = ['department']
		self.book_slots = []
		self.all_slots = ['Phone', 'Post', 'Addr', 'Department']
	
	def delexiconize(self, usr, spans, entity_dic):
		words = nltk.word_tokenize(usr)
		conflict = defaultdict(set)
		
		for span in spans:
			slot = span[1].lower()
			start = span[3]
			end = span[4] + 1
			words[start:end] = ['v_%s' % slot] * (end - start)
			conflict[(start, end)].add('v_%s' % slot)
		
		new_words = []
		v = None
		for w in words:
			if 'v_' not in w:
				new_words.append(w)
			else:
				if v != w:
					v = w
					new_words.append(w)
					for pair in conflict.values():
						if len(pair) > 1:
							if w in pair:
								for p in pair:
									if p != w:
										new_words.append(p)
		new_sent = ' '.join(new_words)
		for k, v in entity_dic.items():
			if v and v in new_sent:
				new_sent = new_sent.replace(v, 'v_%s' % k)
		return new_sent
	
	def write(self, usr):
		usr = usr.replace('eurology department', 'v_department department')
		self.file.write(usr)
	
	def contain(self, ele, lis):
		for a, b in lis:
			if a == ele: return True
		else:
			return False
	
	def get(self, ele, lis):
		for a, b in lis:
			if a == ele:
				return b
	
	def generate(self, data, is_delexicon=False):
		for dial in data:
			ctt = 1
			for i, turn in enumerate(dial):
				if i % 2 == 0:
					usr = turn['text'].lower()
					usr_sapn = turn['span_info']
					usr_da = turn['dialog_act']
					usr_acts = [k for k in usr_da]
				else:
					ds = turn['metadata'][self.domain]
					sys_da = turn['dialog_act']
					sys_acts = [k for k in sys_da]
					if is_delexicon:
						entity_dic = {k: v for k, v in ds['semi'].items() if k in ['type', 'name']}
						usr = self.delexiconize(usr, usr_sapn, entity_dic)
						
						if '%s-NoOffer' % self.Domain in sys_acts:
							sys = 'api_call'
							for s in self.semi_slots:
								if ds['semi'][s] != 'not mentioned':
									if is_delexicon:
										sys += ' v_%s' % s
									else:
										sys += ' %s' % ds['semi'][s]
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
							self.write('%d NoOffer || %s-NoOffer\n' % (ctt, self.Domain))
							ctt += 1
						
						elif 'Booking-NoBook' in sys_acts:
							sys = 'api_book'
							for s in self.book_slots:
								if s in ds['book']:
									if is_delexicon:
										sys += ' v_%s' % s
									else:
										sys += ' %s' % ds['book'][s]
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
							self.write('%d NoBook || Booking-NoBook\n' % ctt)
							ctt += 1
						
						elif ctt<2 and (len(usr_acts) == 0 or
										('%s-Inform' % self.Domain in usr_acts
										 and self.contain('none', usr_da['%s-Inform' % self.Domain]))):
							sys = 'Inform Department'
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif '%s-Inform' % self.Domain in sys_acts and \
								self.contain('Department', sys_da['%s-Inform' % self.Domain]) and \
								ds['semi']['department'] == 'not mentioned':
							sys = 'api_call'
							for s in self.semi_slots:
								if ds['semi'][s] != 'not mentioned':
									if is_delexicon:
										sys += ' v_%s' % s
									else:
										sys += ' %s' % ds['semi'][s]
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						# elif usr_acts == ['%s-Request' % self.Domain]:
						# 	usr_requested_slots = set([s for s, v in usr_da['%s-Request' % self.Domain]])
						# 	# sys_informed_slots = set([s for s,v in sys_da['Restaurant-Inform']])
						# 	sys = 'Inform'
						# 	for s in self.all_slots:  # & sys_informed_slots:
						# 		if s in usr_requested_slots:
						# 			sys += ' %s' % s
						# 	self.write('%d %s || %s\n' % (ctt, usr, sys))
						# 	ctt += 1
		
						elif '%s-Request' % self.Domain in usr_acts:
							usr_requested_slots = set([s for s, v in usr_da['%s-Request' % self.Domain]])
							# sys_informed_slots = set([s for s,v in sys_da['%s-Inform'%self.Domain]])
							sys = 'Inform'
							for s in self.all_slots:  # & sys_informed_slots:
								if s in usr_requested_slots:
									sys += ' %s' % s
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif '%s-Request' % self.Domain in sys_acts:
							sys_requested_slots = set([s for s, v in sys_da['%s-Request' % self.Domain]])
							sys = 'Request'
							for s in self.all_slots:
								if s in sys_requested_slots:
									sys += ' %s' % s
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						
						
						
						elif 'general-thank' in usr_acts or 'general-bye' in usr_acts or \
								'general-bye' in sys_acts:
							sys = 'general_bye'
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
							break
						
						elif '%s-Inform' % self.Domain in usr_acts and \
								self.contain('Department', usr_da['%s-Inform' % self.Domain]):
							if is_delexicon:
								sys = 'Inform v_department'
							else:
								sys = 'Inform %s' % ds['semi']['department']
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif '%s-Inform' % self.Domain in sys_da and \
								self.contain('Choice', sys_da['%s-Inform' % self.Domain]):
							sys = 'api_call'
							for s in self.semi_slots:
								if ds['semi'][s] != 'not mentioned':
									if is_delexicon:
										sys += ' v_%s' % s
									else:
										sys += ' %s' % ds['semi'][s]
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif '%s-Recommend' % self.Domain in sys_da and \
								(self.contain('Department', sys_da['%s-Recommend' % self.Domain]) or
								 self.contain('Choice', sys_da['%s-Recommend' % self.Domain])):
							sys = 'api_call'
							for s in self.semi_slots:
								if ds['semi'][s] != 'not mentioned':
									if is_delexicon:
										sys += ' v_%s' % s
									else:
										sys += ' %s' % ds['semi'][s]
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif sys_acts == ['%s-Inform' % self.Domain]:
							sys_informed_slots = set([s for s, v in sys_da['%s-Inform' % self.Domain]])
							# sys_informed_slots = set([s for s,v in sys_da['Restaurant-Inform']])
							sys = 'Inform'
							for s in self.all_slots:  # & sys_informed_slots:
								if s in sys_informed_slots:
									sys += ' %s' % s
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
			self.write('\n')


class Police:
	def __init__(self):
		self.domain = 'police'
		self.Domain = 'Police'
		if 'data_%s' % self.domain in os.listdir('.'):
			os.remove('data_%s' % self.domain)
		self.file = open('data_%s' % self.domain, 'w+')
		self.semi_slots = []
		self.book_slots = []
		self.all_slots = ['Name', 'Phone', 'Post', 'Addr']
	
	def delexiconize(self, usr, spans, entity_dic):
		words = nltk.word_tokenize(usr)
		conflict = defaultdict(set)
		
		for span in spans:
			slot = span[1].lower()
			start = span[3]
			end = span[4] + 1
			words[start:end] = ['v_%s' % slot] * (end - start)
			conflict[(start, end)].add('v_%s' % slot)
		
		new_words = []
		v = None
		for w in words:
			if 'v_' not in w:
				new_words.append(w)
			else:
				if v != w:
					v = w
					new_words.append(w)
					for pair in conflict.values():
						if len(pair) > 1:
							if w in pair:
								for p in pair:
									if p != w:
										new_words.append(p)
		new_sent = ' '.join(new_words)
		for k, v in entity_dic.items():
			if v and v in new_sent:
				new_sent = new_sent.replace(v, 'v_%s' % k)
		return new_sent
	
	def write(self, usr):
		self.file.write(usr)
	
	def contain(self, ele, lis):
		for a, b in lis:
			if a == ele: return True
		else:
			return False
	
	def get(self, ele, lis):
		for a, b in lis:
			if a == ele:
				return b
	
	def generate(self, data, is_delexicon=False):
		for dial in data:
			ctt = 1
			for i, turn in enumerate(dial):
				if i % 2 == 0:
					usr = turn['text'].lower()
					usr_sapn = turn['span_info']
					usr_da = turn['dialog_act']
					usr_acts = [k for k in usr_da]
				else:
					ds = turn['metadata'][self.domain]
					sys_da = turn['dialog_act']
					sys_acts = [k for k in sys_da]
					if is_delexicon:
						entity_dic = {k: v for k, v in ds['semi'].items() if k in ['type', 'name']}
						usr = self.delexiconize(usr, usr_sapn, entity_dic)
						
						if '%s-Request' % self.Domain in usr_acts:
							usr_requested_slots = set([s for s, v in usr_da['%s-Request' % self.Domain]])
							# sys_informed_slots = set([s for s,v in sys_da['Restaurant-Inform']])
							sys = 'Inform'
							for s in self.all_slots:  # & sys_informed_slots:
								if s in usr_requested_slots:
									sys += ' %s' % s
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						# elif '%s-Inform' % self.Domain in sys_acts and \
						# 		self.contain('Name', sys_da['%s-Inform' % self.Domain]):
						# 	sys = 'Inform Name'
						# 	self.write('%d %s || %s\n' % (ctt, usr, sys))
						# 	ctt += 1
						elif '%s-Inform' % self.Domain in usr_acts and \
								self.contain('Name', usr_da['%s-Inform' % self.Domain]):
							if is_delexicon:
								sys = 'Inform v_name'
							else:
								sys = 'Inform %s' % ds['semi']['name']
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
							
						# 首轮非常不一致
						elif '%s-Request' % self.Domain not in usr_acts and ctt<2:
							if is_delexicon:
								sys = 'Inform Name'
							else:
								sys = 'Inform %s' % ds['semi']['name']
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
		
						
						elif '%s-Request' % self.Domain in sys_acts:
							sys_requested_slots = set([s for s, v in sys_da['%s-Request' % self.Domain]])
							sys = 'Request'
							for s in self.all_slots:
								if s in sys_requested_slots:
									sys += ' %s' % s
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						
						
						
						elif 'general-thank' in usr_acts or 'general-bye' in usr_acts or \
								'general-bye' in sys_acts:
							sys = 'general_bye'
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
							break
						
						
						
			
						
						elif sys_acts == ['%s-Inform' % self.Domain]:
							sys_informed_slots = set([s for s, v in sys_da['%s-Inform' % self.Domain]])
							# sys_informed_slots = set([s for s,v in sys_da['Restaurant-Inform']])
							sys = 'Inform'
							for s in self.all_slots:  # & sys_informed_slots:
								if s in sys_informed_slots:
									sys += ' %s' % s
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
			self.write('\n')


class Taxi:
	def __init__(self):
		self.domain = 'taxi'
		self.Domain = 'Taxi'
		if 'data_%s' % self.domain in os.listdir('.'):
			os.remove('data_%s' % self.domain)
		self.file = open('data_%s' % self.domain, 'w+')
		self.semi_slots = ['leaveAt', 'destination', 'departure', 'arriveBy']
		self.book_slots = []
		self.all_slots = ['Car', 'Leave', 'Phone', 'Arrive', 'Depart', 'Dest']
	
	def delexiconize(self, usr, spans, entity_dic):
		words = nltk.word_tokenize(usr)
		conflict = defaultdict(set)
		
		for span in spans:
			slot = span[1].lower()
			start = span[3]
			end = span[4] + 1
			words[start:end] = ['v_%s' % slot] * (end - start)
			conflict[(start, end)].add('v_%s' % slot)
		new_words = []
		v = None
		for w in words:
			if 'v_' not in w:
				new_words.append(w)
			else:
				if v != w:
					v = w
					new_words.append(w)
					for pair in conflict.values():
						if len(pair) > 1:
							if w in pair:
								for p in pair:
									if p != w:
										new_words.append(p)
		new_sent = ' '.join(new_words)
		for k, v in entity_dic.items():
			if v and v in new_sent:
				new_sent = new_sent.replace(v, 'v_%s' % k)
			
		return new_sent
	
	def write(self, usr):
		usr = usr.replace('v_leaveAt', 'v_leave')
		usr = usr.replace('v_arriveBy', 'v_arrive')
		usr = usr.replace('v_departure', 'v_depart')
		usr = usr.replace('v_destination', 'v_dest')
		usr = usr.replace('leaving any time', 'leaving v_leave time')
		if 'v_departvv_depart_v_departdv' in usr:
			print(input())
		else:
			print(usr)
		self.file.write(usr)
	
	def contain(self, ele, lis):
		for a, b in lis:
			if a == ele: return True
		else:
			return False
	
	def get(self, ele, lis):
		for a, b in lis:
			if a == ele:
				return b
	
	def generate(self, data, is_delexicon=False):
		for dial in data:
			ctt = 1
			for i, turn in enumerate(dial):
				if i % 2 == 0:
					usr = turn['text'].lower()
					usr_sapn = turn['span_info']
					usr_da = turn['dialog_act']
					usr_acts = [k for k in usr_da]
				else:
					ds = turn['metadata'][self.domain]
					sys_da = turn['dialog_act']
					sys_acts = [k for k in sys_da]
					if is_delexicon:
						entity_dic = {k: v for k, v in ds['semi'].items() if k in ['destination', 'departure']}
						usr = self.delexiconize(usr, usr_sapn, entity_dic)
						if '%s-NoOffer' % self.Domain in sys_acts:
							sys = 'api_call'
							for s in self.semi_slots:
								if ds['semi'][s] != 'not mentioned':
									if is_delexicon:
										sys += ' v_%s' % s
									else:
										sys += ' %s' % ds['semi'][s]
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
							self.write('%d NoOffer || %s-NoOffer\n' % (ctt, self.Domain))
							ctt += 1
						
						elif 'Booking-NoBook' in sys_acts:
							sys = 'api_book'
							for s in self.book_slots:
								if s in ds['book']:
									if is_delexicon:
										sys += ' v_%s' % s
									else:
										sys += ' %s' % ds['book'][s]
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
							self.write('%d NoBook || Booking-NoBook\n' % ctt)
							ctt += 1
						
						elif usr_acts == ['%s-Request' % self.Domain]:
							usr_requested_slots = set([s for s, v in usr_da['%s-Request' % self.Domain]])
							# sys_informed_slots = set([s for s,v in sys_da['Restaurant-Inform']])
							sys = 'Inform'
							for s in self.all_slots:  # & sys_informed_slots:
								if s in usr_requested_slots:
									sys += ' %s' % s
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif '%s-Inform' % self.Domain in sys_acts and \
								self.contain('Car', sys_da['%s-Inform' % self.Domain]):
							sys = 'api_call'
							for s in self.semi_slots:
								if ds['semi'][s] != 'not mentioned':
									if is_delexicon:
										sys += ' v_%s' % s
									else:
										sys += ' %s' % ds['semi'][s]
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif 'Booking-Book' in sys_acts:
							sys = 'api_book'
							for s in self.book_slots:
								if s in ds['book']:
									if is_delexicon:
										sys += ' v_%s' % s
									else:
										sys += ' %s' % ds['book'][s]
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif '%s-Request' % self.Domain in sys_acts:
							sys_requested_slots = set([s for s, v in sys_da['%s-Request' % self.Domain]])
							sys = 'Request'
							for s in self.all_slots:
								if s in sys_requested_slots:
									sys += ' %s' % s
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif 'Booking-Request' in sys_acts:
							sys_requested_slots = set([s for s, v in sys_da['Booking-Request']])
							sys = 'Booking_Request'
							for s in sys_requested_slots:
								sys += ' %s' % s
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif '%s-Request' % self.Domain in usr_acts:
							usr_requested_slots = set([s for s, v in usr_da['%s-Request' % self.Domain]])
							# sys_informed_slots = set([s for s,v in sys_da['Restaurant-Inform']])
							sys = 'Inform'
							for s in self.all_slots:  # & sys_informed_slots:
								if s in usr_requested_slots:
									sys += ' %s' % s
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif 'general-thank' in usr_acts or 'general-bye' in usr_acts or \
								'general-bye' in sys_acts:
							sys = 'general_bye'
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
							break
						
						elif '%s-Inform' % self.Domain in usr_acts and \
								self.contain('Car', usr_da['%s-Inform' % self.Domain]):
							if is_delexicon:
								sys = 'Inform v_car'
							else:
								sys = 'Inform %s' % ds['semi']['car']
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif '%s-Inform' % self.Domain in sys_da and \
								self.contain('Choice', sys_da['%s-Inform' % self.Domain]):
							sys = 'api_call'
							for s in self.semi_slots:
								if ds['semi'][s] != 'not mentioned':
									if is_delexicon:
										sys += ' v_%s' % s
									else:
										sys += ' %s' % ds['semi'][s]
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif '%s-Recommend' % self.Domain in sys_da and \
								(self.contain('Car', sys_da['%s-Recommend' % self.Domain]) or
								 self.contain('Choice', sys_da['%s-Recommend' % self.Domain])):
							sys = 'api_call'
							for s in self.semi_slots:
								if ds['semi'][s] != 'not mentioned':
									if is_delexicon:
										sys += ' v_%s' % s
									else:
										sys += ' %s' % ds['semi'][s]
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif sys_acts == ['%s-Inform' % self.Domain]:
							sys_informed_slots = set([s for s, v in sys_da['%s-Inform' % self.Domain]])
							# sys_informed_slots = set([s for s,v in sys_da['Restaurant-Inform']])
							sys = 'Inform'
							for s in self.all_slots:  # & sys_informed_slots:
								if s in sys_informed_slots:
									sys += ' %s' % s
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
						elif sys_acts == ['general-reqmore']:
							sys = 'api_call'
							for s in self.semi_slots:
								if ds['semi'][s] != 'not mentioned':
									if is_delexicon:
										sys += ' v_%s' % s
									else:
										sys += ' %s' % ds['semi'][s]
							self.write('%d %s || %s\n' % (ctt, usr, sys))
							ctt += 1
						
			self.write('\n')


			
if __name__ == '__main__':
	ontos = {'taxi':Taxi, 'police':Police, 'hospital':Hospital, 'hotel':Hotel, 'attraction':Attraction, 'train':Train, 'restaurant':Restaurant}
	for domain, cls in ontos.items():
		api = cls()
		api.generate(extracted_data[domain], True)

