function Xtensor = tucker2multiarray(X)
% Converts a 3d Tucker form tensor to a multiarray.
%
% function Xtensor = tucker2multiarray(X)
%
% X has fields U1, U2, U3, and G.
%
% The matrices U1 (n1-by-r1), U2 (n2-by-r2) and U3 (n3-by-r3) are
% orthogonal matrices.
% G (r1-by-r2-by-r3) is a multidimensional array.
%
% See also: fixedrankfactory_tucker_preconditioned

% This file is part of Manopt: www.manopt.org.
% Original authors: Hiroyuki Kasai and Bamdev Mishra, June 05, 2015.
% Contributors:
% Change log:
    
    U1 = X.U1;
    U2 = X.U2;
    U3 = X.U3;
    G = X.G;
    
    % Tensor size
    n1 = size(U1, 1);
    n2 = size(U2, 1);
    n3 = size(U3, 1);
    
    % Core size
    [r1, r2, r3] = size(G);
    
    % Multplication by U1
    G1 = reshape(G, r1, r2*r3);
    GU1 = reshape(U1*G1, n1, r2, r3);
    
    % Further multplication by U2
    G2 = reshape(permute(GU1, [2 1 3]), r2, n1*r3);
    GU1U2 = permute(reshape(U2*G2, n2, n1, r3), [2 1 3]);
    
    % Further multplication by U3
    G3 = reshape(permute(GU1U2, [3 1 2]), r3, n1*n2);    
    GU1U2U3 = permute(reshape(U3*G3, n3, n1, n2), [2 3 1]);
    
    Xtensor = GU1U2U3;% Full tensor
    
end
