function candoit = canGetApproxHessian(problem)
% Checks whether an approximate Hessian can be computed for this problem.
%
% function candoit = canGetApproxHessian(problem)
%
% Returns true if an approximate Hessian of the cost function is provided
% in the given problem description, false otherwise.
% If a Hessian is defined but no approximate Hessian is defined explicitly,
% returns false.
%
% Even if this returns false, calls to getApproxHessian may succeed, as
% they will be redirected to getHessianFD. The latter simply requires
% availability of gradients in problem, and vector transports in problem.M.
%
% See also: canGetHessian getHessianFD

% This file is part of Manopt: www.manopt.org.
% Original author: Nicolas Boumal, April 8, 2015.
% Contributors: 
% Change log: 

    candoit = isfield(problem, 'approxhess');
    
end
