/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.ArrayHeap;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Heap;
import edu.stanford.nlp.util.ScoredComparator;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Beam<T>
extends AbstractSet<T> {
    protected int maxBeamSize;
    protected Heap<T> elements;

    public int capacity() {
        return this.maxBeamSize;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.asSortedList().iterator();
    }

    public List<T> asSortedList() {
        LinkedList<T> list = new LinkedList<T>();
        Iterator<T> i = this.elements.iterator();
        while (i.hasNext()) {
            list.addFirst(i.next());
        }
        return list;
    }

    @Override
    public boolean add(T o) {
        boolean added = true;
        this.elements.add(o);
        while (this.size() > this.capacity()) {
            T dumped = this.elements.extractMin();
            if (!dumped.equals(o)) continue;
            added = false;
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public Beam() {
        this(100);
    }

    public Beam(int maxBeamSize) {
        this(maxBeamSize, (Comparator)ErasureUtils.uncheckedCast(ScoredComparator.ASCENDING_COMPARATOR));
    }

    public Beam(int maxBeamSize, Comparator<? super T> cmp) {
        this.elements = new ArrayHeap<T>(cmp);
        this.maxBeamSize = maxBeamSize;
    }
}

