/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.process.WordShapeClassifier;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Timing;
import java.io.Serializable;
import java.util.Map;

public class DistSimClassifier
implements Serializable {
    private static final long serialVersionUID = 3L;
    private final Map<String, String> lexicon;
    private final boolean cased;
    private final boolean numberEquivalence;
    private final String unknownWordClass;

    public DistSimClassifier(String filename, boolean cased, boolean numberEquivalence) {
        this(filename, "alexClark", "utf-8", -1, cased, numberEquivalence, "NULL");
    }

    public DistSimClassifier(String filename, boolean cased, boolean numberEquivalence, String unknownWordClass) {
        this(filename, "alexClark", "utf-8", -1, cased, numberEquivalence, unknownWordClass);
    }

    public DistSimClassifier(String filename, String format, String encoding, int distSimMaxBits, boolean cased, boolean numberEquivalence, String unknownWordClass) {
        this.cased = cased;
        this.numberEquivalence = numberEquivalence;
        this.unknownWordClass = unknownWordClass;
        Timing.startDoing("Loading distsim lexicon from " + filename);
        this.lexicon = Generics.newHashMap(32768);
        boolean terryKoo = "terryKoo".equals(format);
        for (String line : ObjectBank.getLineIterator(filename, encoding)) {
            String wordClass;
            String word;
            String[] bits;
            if (terryKoo) {
                bits = line.split("\\t");
                word = bits[1];
                wordClass = bits[0];
                if (distSimMaxBits > 0 && wordClass.length() > distSimMaxBits) {
                    wordClass = wordClass.substring(0, distSimMaxBits);
                }
            } else {
                bits = line.split("\\s+");
                word = bits[0];
                wordClass = bits[1];
            }
            if (!cased) {
                word = word.toLowerCase();
            }
            if (numberEquivalence) {
                word = WordShapeClassifier.wordShape(word, 13);
            }
            this.lexicon.put(word, wordClass);
        }
        Timing.endDoing();
    }

    public String distSimClass(String word) {
        String distSim;
        if (!this.cased) {
            word = word.toLowerCase();
        }
        if (this.numberEquivalence) {
            word = WordShapeClassifier.wordShape(word, 13);
        }
        if ((distSim = this.lexicon.get(word)) == null) {
            distSim = this.unknownWordClass;
        }
        return distSim;
    }
}

