/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.server;

import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.trees.Tree;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;

public class LexicalizedParserServer {
    final int port;
    final String model;
    final ServerSocket serverSocket;
    final LexicalizedParser parser;
    boolean stillRunning = true;
    static final int DEFAULT_PORT = 4466;

    public LexicalizedParserServer(int port, String model) throws IOException {
        this(port, model, LexicalizedParser.loadModel(model, new String[0]));
    }

    public LexicalizedParserServer(int port, String model, LexicalizedParser parser) throws IOException {
        this.port = port;
        this.serverSocket = new ServerSocket(port);
        this.model = model;
        this.parser = parser;
    }

    public void listen() throws IOException {
        while (this.stillRunning) {
            Socket clientSocket = null;
            try {
                clientSocket = this.serverSocket.accept();
                System.err.println("Got a connection");
                this.processRequest(clientSocket);
                System.err.println("Goodbye!");
                System.err.println();
            }
            catch (IOException e) {
                clientSocket.close();
                System.err.println(e);
            }
        }
        this.serverSocket.close();
    }

    public void processRequest(Socket clientSocket) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(clientSocket.getInputStream(), "utf-8"));
        String line = reader.readLine();
        System.err.println(line);
        if (line == null) {
            return;
        }
        line = line.trim();
        String[] pieces = line.split(" ", 2);
        String command = pieces[0];
        String arg = null;
        if (pieces.length > 1) {
            arg = pieces[1];
        }
        System.err.println("Got the command " + command);
        if (arg != null) {
            System.err.println(" ... with argument " + arg);
        }
        if (command.equals("quit")) {
            this.handleQuit();
        } else if (command.equals("parse")) {
            this.handleParse(arg, clientSocket.getOutputStream());
        } else if (command.equals("tree")) {
            this.handleTree(arg, clientSocket.getOutputStream());
        }
        System.err.println("Handled request");
        clientSocket.close();
    }

    public void handleQuit() {
        this.stillRunning = false;
    }

    public void handleTree(String arg, OutputStream outStream) throws IOException {
        if (arg == null) {
            return;
        }
        Tree tree = this.parser.parse(arg);
        System.err.println(tree);
        if (tree != null) {
            ObjectOutputStream oos = new ObjectOutputStream(outStream);
            oos.writeObject(tree);
            oos.flush();
        }
    }

    public void handleParse(String arg, OutputStream outStream) throws IOException {
        if (arg == null) {
            return;
        }
        Tree tree = this.parser.parse(arg);
        System.err.println(tree);
        if (tree != null) {
            OutputStreamWriter osw = new OutputStreamWriter(outStream, "utf-8");
            osw.write(tree.toString());
            osw.write("\n");
            osw.flush();
        }
    }

    public static void main(String[] args) throws IOException {
        System.setOut(new PrintStream((OutputStream)System.out, true, "utf-8"));
        System.setErr(new PrintStream((OutputStream)System.err, true, "utf-8"));
        int port = 4466;
        String model = LexicalizedParser.DEFAULT_PARSER_LOC;
        for (int i = 0; i < args.length; i += 2) {
            String arg;
            if (i + 1 >= args.length) {
                System.err.println("Unspecified argument " + args[i]);
                System.exit(2);
            }
            if ((arg = args[i]).startsWith("--")) {
                arg = arg.substring(2);
            } else if (arg.startsWith("-")) {
                arg = arg.substring(1);
            }
            if (arg.equalsIgnoreCase("model")) {
                model = args[i + 1];
                continue;
            }
            if (!arg.equalsIgnoreCase("port")) continue;
            port = Integer.valueOf(args[i + 1]);
        }
        LexicalizedParserServer server = new LexicalizedParserServer(port, model);
        System.err.println("Server ready!");
        server.listen();
    }
}

