#ifndef _graphcjj2gc_prune_MACROS_H
#define _graphcjj2gc_prune_MACROS_H

#include "common/parser/macros_base.h"
#include "include/learning/perceptron/packed_score.h"
#include "common/parser/agenda.h"

namespace graphcjj2gc_prune {
#define OUTPUT_STEP 1000
#define BEAMSIZE 4
#define GOLD_POS_SCORE 1000
#define GOLD_NEG_SCORE -50

#define ENCODE_L2R(X)			((X) << 1)
#define ENCODE_R2L(X)			(((X) << 1) + 1)

	typedef PackedScoreMap<WordInt> WordIntMap;
	typedef PackedScoreMap<POSTagInt> POSTagIntMap;
	typedef PackedScoreMap<PathInt> PathIntMap;
	typedef PackedScoreMap<LabelInt> LabelIntMap;

	typedef PackedScoreMap<TwoWordsInt> TwoWordsIntMap;
	typedef PackedScoreMap<POSTagSet2Int> POSTagSet2IntMap;
	typedef PackedScoreMap<WordPOSTagInt> WordPOSTagIntMap;

	typedef PackedScoreMap<POSTagSet3Int> POSTagSet3IntMap;
	typedef PackedScoreMap<WordWordPOSTagInt> WordWordPOSTagIntMap;
	typedef PackedScoreMap<WordPOSTagPOSTagInt> WordPOSTagPOSTagIntMap;
	typedef PackedScoreMap<LabelWordPOSTagInt> LabelWordPOSTagIntMap;

	typedef PackedScoreMap<POSTagSet4Int> POSTagSet4IntMap;
	typedef PackedScoreMap<WordWordPOSTagPOSTagInt> WordWordPOSTagPOSTagIntMap;

	typedef AgendaBeam<LabelScore, BEAMSIZE> LabelScoreAgenda;
	typedef AgendaBeam<ScoreWithBiSplit, BEAMSIZE> ScoreWithBiSplitAgenda;
	typedef AgendaBeam<ScoreWithSplit, BEAMSIZE> ScoreWithSplitAgenda;
	typedef BiGram<int> Arc;
	typedef TriGram<int> PCLArc;
	typedef QuinGram<int> PC1L1C2L2Arc;
	//bool operator<(const Arc & arc1, const Arc & arc2);
}

#endif
