/*
 * Decompiled with CFR 0.152.
 */
package jigsaw.metrics;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jigsaw.metrics.SetEvaluator;
import jigsaw.syntax.Constituent;
import jigsaw.syntax.Tree;

public class Evalb
implements SetEvaluator {
    private static final boolean DEBUG = false;
    protected final String str;
    protected final boolean runningAverages;
    protected double precision = 0.0;
    protected double recall = 0.0;
    protected double f1 = 0.0;
    protected double num = 0.0;
    protected double exact = 0.0;
    protected double precision2 = 0.0;
    protected double recall2 = 0.0;
    protected double pnum2 = 0.0;
    protected double rnum2 = 0.0;
    protected double curF1 = 0.0;

    public Evalb(String str, boolean runningAverages) {
        this.str = str;
        this.runningAverages = runningAverages;
    }

    public double getSentAveF1() {
        return this.f1 / this.num;
    }

    public double getEvalbF1() {
        return 2.0 / (this.rnum2 / this.recall2 + this.pnum2 / this.precision2);
    }

    public double getLastF1() {
        return this.curF1 * 100.0;
    }

    public double getEvalbF1Percent() {
        return this.getEvalbF1() * 100.0;
    }

    public double getExact() {
        return this.exact / this.num;
    }

    public double getExactPercent() {
        return this.getExact() * 100.0;
    }

    public int getNum() {
        return (int)this.num;
    }

    protected static double precision(Set<?> s1, Set<?> s2) {
        double n = 0.0;
        double p = 0.0;
        for (Object o1 : s1) {
            if (s2.contains(o1)) {
                p += 1.0;
            }
            n += 1.0;
        }
        return n > 0.0 ? p / n : 0.0;
    }

    protected Set<Constituent<String>> makeObjects(Tree<String> tree) {
        if (tree == null) {
            return null;
        }
        HashSet<Constituent<String>> set = new HashSet<Constituent<String>>();
        Map<Tree<String>, Constituent<String>> tcmap = tree.getConstituents();
        for (Tree<String> node : tcmap.keySet()) {
            if (node == tree || node.isLeaf() || node.isPreTerminal()) continue;
            set.add(tcmap.get(node));
        }
        return set;
    }

    public void evaluate(Tree<String> guess, Tree<String> gold) {
        this.evaluate(guess, gold, new PrintWriter(System.out, true));
    }

    public void evaluate(Tree<String> guess, Tree<String> gold, PrintWriter pw) {
        this.evaluate(guess, gold, pw, 1.0);
    }

    @Override
    public void evaluate(Tree<String> guess, Tree<String> gold, PrintWriter pw, double weight) {
        if (gold == null || guess == null) {
            System.err.printf("%s: Cannot compare against a null gold or guess tree!\n", this.getClass().getName());
            return;
        }
        Set<Constituent<String>> dep1 = this.makeObjects(guess);
        Set<Constituent<String>> dep2 = this.makeObjects(gold);
        double curPrecision = Evalb.precision(dep1, dep2);
        double curRecall = Evalb.precision(dep2, dep1);
        this.curF1 = curPrecision > 0.0 && curRecall > 0.0 ? 2.0 / (1.0 / curPrecision + 1.0 / curRecall) : 0.0;
        this.precision += curPrecision * weight;
        this.recall += curRecall * weight;
        this.f1 += this.curF1 * weight;
        this.num += weight;
        this.precision2 += (double)dep1.size() * curPrecision * weight;
        this.pnum2 += (double)dep1.size() * weight;
        this.recall2 += (double)dep2.size() * curRecall * weight;
        this.rnum2 += (double)dep2.size() * weight;
        if (this.curF1 > 0.9999) {
            this.exact += 1.0;
        }
        if (pw != null) {
            double cF1 = 2.0 / (this.rnum2 / this.recall2 + this.pnum2 / this.precision2);
            pw.format("%s [current] P: %.2f R: %.2f F1: %.2f", this.str, curPrecision * 100.0, curRecall * 100.0, this.curF1 * 100.0);
            if (this.runningAverages) {
                pw.format(" - [average] P: %.2f R: %.2f F1: %.2f Ex: %.2f N: %d", this.precision2 * 100.0 / this.pnum2, this.recall2 * 100.0 / this.rnum2, cF1 * 100.0, 100.0 * this.exact / this.num, this.getNum());
            }
            pw.println();
        }
    }

    public void display(boolean verbose) {
        this.display(verbose, new PrintWriter(System.out, true));
    }

    @Override
    public void display(boolean verbose, PrintWriter pw) {
        double prec = this.precision2 / this.pnum2;
        double rec = this.recall2 / this.rnum2;
        double f = 2.0 / (1.0 / prec + 1.0 / rec);
        pw.format("%s [summary]: LP: %.2f LR: %.2f F1: %.2f Ex: %.2f N: %d%n", this.str, 100.0 * prec, 100.0 * rec, 100.0 * f, 100.0 * this.exact / this.num, this.getNum());
    }

    public static class CBEval
    extends Evalb {
        private double cb = 0.0;
        private double num = 0.0;
        private double zeroCB = 0.0;

        protected void checkCrossing(Set<Constituent<String>> s1, Set<Constituent<String>> s2) {
            double c = 0.0;
            for (Constituent<String> constit : s1) {
                if (!constit.crosses(s2)) continue;
                c += 1.0;
            }
            if (c == 0.0) {
                this.zeroCB += 1.0;
            }
            this.cb += c;
            this.num += 1.0;
        }

        @Override
        public void evaluate(Tree<String> t1, Tree<String> t2, PrintWriter pw) {
            Set<Constituent<String>> b1 = this.makeObjects(t1);
            Set<Constituent<String>> b2 = this.makeObjects(t2);
            this.checkCrossing(b1, b2);
            if (pw != null && this.runningAverages) {
                pw.println("AvgCB: " + (double)((int)(10000.0 * this.cb / this.num)) / 100.0 + " ZeroCB: " + (double)((int)(10000.0 * this.zeroCB / this.num)) / 100.0 + " N: " + this.getNum());
            }
        }

        @Override
        public void display(boolean verbose, PrintWriter pw) {
            pw.println(String.valueOf(this.str) + " AvgCB: " + (double)((int)(10000.0 * this.cb / this.num)) / 100.0 + " ZeroCB: " + (double)((int)(10000.0 * this.zeroCB / this.num)) / 100.0);
        }

        public CBEval(String str, boolean runningAverages) {
            super(str, runningAverages);
        }
    }
}

