# create a pdf file that we want to store the plot in
pdf('prec-recall-agreement.pdf')

# put the precision and recall values that we want to plot
# into variables
lm_precisions <- c(1.0000, 0.8125, 0.9860)
perc_precisions <- c(0.6000, 0.7805, 0.8515)
lm_recalls <- c(0.2115, 0.3377, 0.4209)
perc_recalls <- c(0.4038, 0.4156, 0.5821)

# create a new plot and put the LM precision values up
plot(lm_precisions, type="o", pch=22, xaxt="n", ylim=c(0,1), cex=1.2, cex.lab=1.5, cex.axis=1.5, ylab="Precision/Recall", xlab="") + axis(1, at=1:3, labels=FALSE, cex.axis=1.4)

# create the axis labels for each agreement bin
text(c(1.15, 2.15, 3.15), par("usr")[3]-.1, labels=c("50-75%\n[n=93]","75-90%\n[n=114]","90-100%\n[n=716]"), xpd=TRUE, pos=2, cex=1.4)
text(2.25, par("usr")[3]-0.175, labels=c("Agreement Bin"), xpd=TRUE, pos=2, cex=1.4)

# plot the other 3 sets of values
points(lm_recalls, type="o", pch=23, cex=1.2)
points(perc_precisions, type="o", pch=22, lty=2, cex=1.2)
points(perc_recalls, type="o", pch=23, lty=2, cex=1.2)

# create a legend
legend(2.1, 0.30, c("LM Precision", "PERC Precision", "LM Recall", "PERC Recall"), cex=1.4, lty=c(1,2,1,2), pch=c(22,22,23,23))

# close the pdf file
dev.off()
