/*
 * Decompiled with CFR 0.152.
 */
package babel.util.persistence;

import babel.util.persistence.XMLPersistable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLObjectWriter {
    protected static final String ENCODING = "utf-8";
    protected static final String ROOT_TAG = "Root";
    protected OutputStream m_outStream;
    protected XMLStreamWriter m_xmlWriter;
    protected boolean m_addHeader;

    public XMLObjectWriter(OutputStream stream, boolean addHeader) throws XMLStreamException, FactoryConfigurationError {
        this.m_addHeader = addHeader;
        this.m_outStream = stream;
        this.m_xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(stream, ENCODING);
        if (this.m_addHeader) {
            this.m_xmlWriter.writeStartDocument(ENCODING, "1.0");
            this.m_xmlWriter.writeStartElement(ROOT_TAG);
        }
    }

    public XMLObjectWriter(String fileName, boolean addHeader) throws IOException, XMLStreamException {
        this(new FileOutputStream(fileName), addHeader);
    }

    public void write(XMLPersistable obj) throws XMLStreamException {
        obj.persist(this.m_xmlWriter);
    }

    public void close() throws XMLStreamException, IOException {
        if (this.m_addHeader) {
            this.m_xmlWriter.writeEndElement();
            this.m_xmlWriter.writeEndDocument();
        }
        this.m_outStream.close();
        this.m_xmlWriter.close();
    }

    public static void write(String fileName, XMLPersistable obj, boolean addHeader) throws IOException, XMLStreamException {
        XMLObjectWriter writer = new XMLObjectWriter(fileName, addHeader);
        writer.write(obj);
        writer.close();
    }

    public static void write(String fileName, List<XMLPersistable> objs, boolean addHeader) throws IOException, XMLStreamException {
        XMLObjectWriter writer = new XMLObjectWriter(fileName, addHeader);
        for (XMLPersistable obj : objs) {
            writer.write(obj);
        }
        writer.close();
    }
}

