/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.properties.context;

import babel.content.corpora.accessors.CorpusAccessor;
import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.properties.PropertyCollector;
import babel.content.eqclasses.properties.context.Context;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContextCollector
extends PropertyCollector {
    public static final Log LOG = LogFactory.getLog(ContextCollector.class);
    protected HashMap<String, EquivalenceClass> m_allContextEqsMap;
    protected int m_leftSize;
    protected int m_rightSize;

    public ContextCollector(boolean caseSensitive, int leftSize, int rightSize, Set<EquivalenceClass> contextEqs) throws Exception {
        super(caseSensitive);
        this.m_leftSize = leftSize;
        this.m_rightSize = rightSize;
        this.m_allContextEqsMap = new HashMap(contextEqs.size());
        for (EquivalenceClass eq : contextEqs) {
            for (String word : eq.getAllWords()) {
                assert (this.m_allContextEqsMap.get(word) == null);
                this.m_allContextEqsMap.put(word, eq);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void collectProperty(CorpusAccessor corpusAccess, Set<? extends EquivalenceClass> eqs) throws Exception {
        String curLine;
        BufferedReader reader = new BufferedReader(corpusAccess.getCorpusReader());
        HashMap<String, EquivalenceClass> eqsMap = new HashMap<String, EquivalenceClass>(eqs.size());
        for (EquivalenceClass equivalenceClass : eqs) {
            for (String word : equivalenceClass.getAllWords()) {
                assert (eqsMap.get(word) == null);
                eqsMap.put(word, equivalenceClass);
            }
        }
        while ((curLine = reader.readLine()) != null) {
            void var12_9;
            String[] curSents = this.sentSplit(curLine, corpusAccess.isOneSentencePerLine());
            boolean bl = false;
            while (var12_9 < curSents.length) {
                String[] curSentTokens = curSents[var12_9].split("[\\|\\$\\*\\s\"'\\-\\+=,;:\u00ac\u00b4\u00ac\u00aa{}()<>\\[\\]\\.\\?\u00ac\u00f8!\u00ac\u00b0\u201a\u00c4\u00ec\u201a\u00c4\u00fa\u201a\u00c4\u00f9\u201a\u00c4\u00f2\u201a\u00c4\u00f4\u00ac\u2020]+");
                int numToken = 0;
                while (numToken < curSentTokens.length) {
                    EquivalenceClass foundEq = (EquivalenceClass)eqsMap.get(EquivalenceClass.getWordOfAppropriateForm(curSentTokens[numToken], this.m_caseSensitive));
                    if (foundEq != null) {
                        Context fountEqContext = (Context)foundEq.getProperty(Context.class.getName());
                        if (fountEqContext == null) {
                            fountEqContext = new Context(foundEq);
                            foundEq.setProperty(fountEqContext);
                        }
                        int min = Math.max(0, numToken - this.m_leftSize);
                        int max = Math.min(numToken + this.m_rightSize + 1, curSentTokens.length);
                        int contextIdx = min;
                        while (contextIdx < max) {
                            if (contextIdx != numToken) {
                                fountEqContext.addContextWord(this.m_caseSensitive, this.m_allContextEqsMap, curSentTokens[contextIdx]);
                            }
                            ++contextIdx;
                        }
                    }
                    ++numToken;
                }
                ++var12_9;
            }
        }
        reader.close();
    }

    protected String[] sentSplit(String line, boolean oneSentPerLine) {
        String[] sents = oneSentPerLine ? new String[]{line} : line.split("[\\|\\.\\?\u00ac\u00f8!\u00ac\u00b0]+");
        return sents;
    }
}

