package org.maltparser.parser.algorithm.moreTransition;



	import org.maltparser.core.exception.MaltChainedException;
	import org.maltparser.core.syntaxgraph.DependencyStructure;
	import org.maltparser.core.syntaxgraph.node.DependencyNode;
	import org.maltparser.parser.DependencyParserConfig;
	import org.maltparser.parser.Oracle;
	import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.algorithm.nivre.ArcEager;
import org.maltparser.parser.algorithm.nivre.NivreConfig;
	import org.maltparser.parser.history.GuideUserHistory;
	import org.maltparser.parser.history.action.GuideUserAction;
	import org.maltparser.core.syntaxgraph.LabelSet;
	import org.maltparser.core.symbol.trie.TrieSymbolTable;
import org.maltparser.core.symbol.trie.Trie;

	public class MoreTransitionOracle extends Oracle {

		public MoreTransitionOracle(DependencyParserConfig manager, GuideUserHistory history) throws MaltChainedException {
			super(manager, history);
			setGuideName("MT");
		}
		
		public GuideUserAction predict(DependencyStructure gold, ParserConfiguration config) throws MaltChainedException {
            MoreTransitionConfig planarConfig = (MoreTransitionConfig)config;
			DependencyStructure dg = planarConfig.getDependencyGraph();
			DependencyNode stackPeek = planarConfig.getStack().peek();
			int stackPeekIndex = stackPeek.getIndex();
			int inputPeekIndex = planarConfig.getInput().peek().getIndex();
			
			DependencyNode inputPeek = planarConfig.getInput().peek();
			int inputPeek2Index=0;
			if(planarConfig.getInput().size()>=2){
			   DependencyNode inputPeek2 = planarConfig.getInput().get(planarConfig.getInput().size()-2);
			   inputPeek2Index = inputPeek2.getIndex();
			}
			
			if (planarConfig.requiresLBA() && planarConfig.getInput().size()>=2  && gold.getTokenNode(inputPeekIndex).getHead().getIndex() == inputPeek2Index)  {
			
				return updateActionContainers(MoreTransition.LEFTSHORTARC, gold.getTokenNode(inputPeekIndex).getHeadEdge().getLabelSet());	
			}
			else if (planarConfig.requiresRBA() && planarConfig.getInput().size()>=2  && gold.getTokenNode(inputPeek2Index).getHead().getIndex() == inputPeekIndex
			&& !gold.getTokenNode(inputPeek2Index).hasRightDependent()
			&& inputPeek2Index-inputPeekIndex==1) {
	
				return updateActionContainers(MoreTransition.RIGHTSHORTARC, gold.getTokenNode(inputPeek2Index).getHeadEdge().getLabelSet());
	        }			
			else if (planarConfig.requiresLNPA() && !stackPeek.isRoot() && planarConfig.getInput().size()>=2  
					&& gold.getTokenNode(stackPeekIndex).getHead().getIndex() == inputPeek2Index
					&& !gold.getTokenNode(stackPeekIndex).hasRightDependent())  {
				
					return updateActionContainers(MoreTransition.LEFTNONPROJARC, gold.getTokenNode(stackPeekIndex).getHeadEdge().getLabelSet());	
			}
			else if (planarConfig.requiresRNPA() && planarConfig.getInput().size()>=2  
					&& gold.getTokenNode(inputPeek2Index).getHead().getIndex() == stackPeekIndex)  {
				
					return updateActionContainers(MoreTransition.RIGHTNONPROJARC, gold.getTokenNode(inputPeek2Index).getHeadEdge().getLabelSet());	
			}
			else if (!stackPeek.isRoot() && gold.getTokenNode(stackPeekIndex).getHead().getIndex() == inputPeekIndex) {
				
				return updateActionContainers(MoreTransition.LEFTARC, gold.getTokenNode(stackPeekIndex).getHeadEdge().getLabelSet());
			} else if (gold.getTokenNode(inputPeekIndex).getHead().getIndex() == stackPeekIndex) {
				return updateActionContainers(MoreTransition.RIGHTARC, gold.getTokenNode(inputPeekIndex).getHeadEdge().getLabelSet());
			} else if (planarConfig.getRootHandling() == NivreConfig.STRICT && !stackPeek.hasHead()) {
				return updateActionContainers(MoreTransition.SHIFT, null);
			} else if (gold.getTokenNode(inputPeekIndex).hasLeftDependent() &&
					gold.getTokenNode(inputPeekIndex).getLeftmostDependent().getIndex() < stackPeekIndex) {
					return updateActionContainers(MoreTransition.REDUCE, null);
				
			} else if (gold.getTokenNode(inputPeekIndex).getHead().getIndex() < stackPeekIndex && 
					(!gold.getTokenNode(inputPeekIndex).getHead().isRoot() || planarConfig.getRootHandling() == NivreConfig.NORMAL)) {

				return updateActionContainers(MoreTransition.REDUCE, null);
			} else {
				return updateActionContainers(MoreTransition.SHIFT, null);
			}
				
		}
		
//		private boolean checkIfArcExists ( DependencyStructure dg , int index1 , int index2 ) throws MaltChainedException
//		{
//			return dg.getTokenNode(index2).hasHead() && dg.getTokenNode(index2).getHead().getIndex() == index1;
//		}
		
		public void finalizeSentence(DependencyStructure dependencyGraph) throws MaltChainedException {}
		
		public void terminate() throws MaltChainedException {}
	}

