/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.noplanar;

import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.core.syntaxgraph.edge.Edge;
import org.maltparser.core.syntaxgraph.node.DependencyNode;
import org.maltparser.core.syntaxgraph.node.TokenNode;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.Oracle;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.algorithm.noplanar.NoPlanarConfig;
import org.maltparser.parser.history.GuideUserHistory;
import org.maltparser.parser.history.action.GuideUserAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoPlanarArcEagerOracle
extends Oracle {
    public NoPlanarArcEagerOracle(DependencyParserConfig manager, GuideUserHistory history) throws MaltChainedException {
        super(manager, history);
        this.setGuideName("NoPlanar");
    }

    @Override
    public GuideUserAction predict(DependencyStructure gold, ParserConfiguration config) throws MaltChainedException {
        NoPlanarConfig planarConfig = (NoPlanarConfig)config;
        DependencyStructure dg = planarConfig.getDependencyGraph();
        DependencyNode stackPeek = planarConfig.getStack().peek();
        int stackPeekIndex = stackPeek.getIndex();
        int inputPeekIndex = planarConfig.getInput().peek().getIndex();
        if (!stackPeek.isRoot() && this.checkIfExistLA(gold, stackPeekIndex, inputPeekIndex) && this.isAllowedOneMoreEdge(gold, dg, inputPeekIndex, stackPeekIndex)) {
            Edge e = this.obtainRightEdge(gold, dg, inputPeekIndex, stackPeekIndex);
            return this.updateActionContainers(4, e.getLabelSet());
        }
        if (this.checkIfExistRA(gold, stackPeekIndex, inputPeekIndex) && this.isAllowedOneMoreEdge(gold, dg, stackPeekIndex, inputPeekIndex)) {
            Edge e = this.obtainRightEdge(gold, dg, stackPeekIndex, inputPeekIndex);
            return this.updateActionContainers(3, e.getLabelSet());
        }
        if (planarConfig.getRootHandling() == 1 && !stackPeek.hasHead()) {
            return this.updateActionContainers(1, null);
        }
        if (this.areInputBufferRelated(gold, planarConfig.getStack(), inputPeekIndex) && (!this.checkIfNodesAreRelated(gold, 0, inputPeekIndex) || planarConfig.getRootHandling() == 3)) {
            return this.updateActionContainers(2, null);
        }
        return this.updateActionContainers(1, null);
    }

    private Edge obtainRightEdge(DependencyStructure gold, DependencyStructure dg, int head, int dep) throws MaltChainedException {
        SortedSet<String> labelsGOLD = this.getPosiblesLabels(gold, head, dep);
        SortedSet<String> labelsDG = this.getPosiblesLabels(dg, head, dep);
        for (String edg : labelsGOLD) {
            if (labelsDG.contains(edg)) continue;
            return this.getConcreteEdgeGraph(gold, head, dep, edg);
        }
        return null;
    }

    private Edge getConcreteEdgeGraph(DependencyStructure dg, int index1, int index2, String label) throws MaltChainedException {
        SortedSet<Edge> arcos = dg.getEdges();
        for (Edge arco : arcos) {
            if (arco.getSource().getIndex() != index1 || arco.getTarget().getIndex() != index2 || arco.getLabelSymbol(dg.getSymbolTables().getSymbolTable("DEPREL")).compareTo(label) != 0) continue;
            return arco;
        }
        return null;
    }

    private SortedSet<String> getPosiblesLabels(DependencyStructure gold, int index1, int index2) throws MaltChainedException {
        TreeSet<String> labels = new TreeSet<String>();
        SortedSet<Edge> arcos = gold.getEdges();
        for (Edge arco : arcos) {
            if (arco.getSource().getIndex() != index1 || arco.getTarget().getIndex() != index2) continue;
            labels.add(arco.getLabelSymbol(gold.getSymbolTables().getSymbolTable("DEPREL")));
        }
        return labels;
    }

    private boolean isAllowedOneMoreEdge(DependencyStructure gold, DependencyStructure dg, int head, int dep) throws MaltChainedException {
        SortedSet<Edge> aa = gold.getEdges();
        Iterator ita = aa.iterator();
        int countGold = 0;
        while (ita.hasNext()) {
            Edge edg = (Edge)ita.next();
            if (edg.getSource().getIndex() != head || edg.getTarget().getIndex() != dep) continue;
            ++countGold;
        }
        SortedSet<Edge> ab = dg.getEdges();
        Iterator itb = ab.iterator();
        int countDG = 0;
        while (itb.hasNext()) {
            Edge edg = (Edge)itb.next();
            if (edg.getSource().getIndex() != head || edg.getTarget().getIndex() != dep) continue;
            ++countDG;
        }
        return countDG < countGold;
    }

    private boolean checkIfExistRA(DependencyStructure dg, int stack, int input) throws MaltChainedException {
        TokenNode tk = dg.getTokenNode(input);
        Set<DependencyNode> heads = null;
        if (tk != null) {
            heads = tk.getHeads();
            for (DependencyNode head : heads) {
                if (head.getIndex() != stack) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkIfExistLA(DependencyStructure dg, int stack, int input) throws MaltChainedException {
        TokenNode tk = dg.getTokenNode(stack);
        Set<DependencyNode> heads = null;
        if (tk != null) {
            heads = tk.getHeads();
            for (DependencyNode head : heads) {
                if (head.getIndex() != input) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkIfNodesAreRelated(DependencyStructure dg, int index1, int index2) throws MaltChainedException {
        TokenNode tk = dg.getTokenNode(index1);
        Set<DependencyNode> heads = null;
        if (tk != null) {
            heads = tk.getHeads();
            for (DependencyNode head : heads) {
                if (head.getIndex() != index2) continue;
                return true;
            }
        }
        if ((tk = dg.getTokenNode(index2)) != null) {
            heads = tk.getHeads();
            for (DependencyNode head : heads) {
                if (head.getIndex() != index1) continue;
                return true;
            }
        }
        return false;
    }

    private boolean areInputBufferRelated(DependencyStructure dg, Stack<DependencyNode> stack, int indexBuffer) throws MaltChainedException {
        for (DependencyNode nodo : stack) {
            if (!this.checkIfNodesAreRelated(dg, nodo.getIndex(), indexBuffer) || stack.peek().getIndex() == nodo.getIndex()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void finalizeSentence(DependencyStructure dependencyGraph) throws MaltChainedException {
    }

    @Override
    public void terminate() throws MaltChainedException {
    }
}

