/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.lm;

import com.aliasi.lm.AbstractNode;
import com.aliasi.lm.NBestCounter;
import com.aliasi.lm.Node;
import com.aliasi.lm.NodeFactory;
import com.aliasi.util.ObjectToCounterMap;
import com.aliasi.util.Strings;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractDtrNode
extends AbstractNode {
    AbstractDtrNode() {
    }

    abstract char[] chars();

    abstract Node[] dtrs();

    abstract int numDtrs();

    Node getDtr(char c) {
        char[] cs = this.chars();
        int i = Arrays.binarySearch(cs, c);
        if (i < 0) {
            return null;
        }
        return this.dtrs()[i];
    }

    @Override
    public int numOutcomes(char[] cs, int start, int end) {
        if (start == end) {
            return this.numDtrs();
        }
        Node dtr = this.getDtr(cs[start]);
        if (dtr == null) {
            return 0;
        }
        return dtr.numOutcomes(cs, start + 1, end);
    }

    @Override
    public long count(char[] cs, int start, int end) {
        if (start == end) {
            return this.count();
        }
        Node dtr = this.getDtr(cs[start]);
        if (dtr == null) {
            return 0L;
        }
        return dtr.count(cs, start + 1, end);
    }

    public long contextCount() {
        Node[] dtrs = this.dtrs();
        long dtrCount = 0L;
        for (int i = 0; i < dtrs.length; ++i) {
            dtrCount += dtrs[i].count();
        }
        return dtrCount;
    }

    @Override
    public long contextCount(char[] cs, int start, int end) {
        if (start == end) {
            return this.contextCount();
        }
        Node dtr = this.getDtr(cs[start]);
        if (dtr == null) {
            return 0L;
        }
        return dtr.contextCount(cs, start + 1, end);
    }

    @Override
    public Node decrement() {
        return this.decrement(1);
    }

    @Override
    public Node decrement(int decr) {
        return NodeFactory.createNode(this.chars(), this.dtrs(), this.count() - (long)decr);
    }

    @Override
    public Node decrement(char[] cs, int start, int end) {
        if (start == end) {
            return this.decrement();
        }
        char[] dtrCs = this.chars();
        int k = Arrays.binarySearch(dtrCs, cs[start]);
        if (k >= 0) {
            Node[] dtrs = this.dtrs();
            dtrs[k] = dtrs[k].decrement(cs, start + 1, end);
            return NodeFactory.createNodePrune(dtrCs, dtrs, this.count());
        }
        String msg = "Could not find string to decrement=" + new String(cs, start, end - start);
        throw new IllegalArgumentException(msg);
    }

    @Override
    public Node decrement(char[] cs, int start, int end, int decr) {
        if (start == end) {
            return this.decrement(decr);
        }
        char[] dtrCs = this.chars();
        int k = Arrays.binarySearch(dtrCs, cs[start]);
        if (k >= 0) {
            Node[] dtrs = this.dtrs();
            dtrs[k] = dtrs[k].decrement(cs, start + 1, end, decr);
            return NodeFactory.createNodePrune(dtrCs, dtrs, this.count());
        }
        String msg = "Could not find string to decrement=" + new String(cs, start, end - start);
        throw new IllegalArgumentException(msg);
    }

    @Override
    public Node increment(char[] cs, int start, int end) {
        return this.increment(cs, start, end, 1);
    }

    @Override
    public Node increment(char[] cs, int start, int end, int incr) {
        int i;
        if (start == end) {
            return NodeFactory.createNode(this.chars(), this.dtrs(), this.count() + (long)incr);
        }
        char[] dtrCs = this.chars();
        int k = Arrays.binarySearch(dtrCs, cs[start]);
        Node[] dtrs = this.dtrs();
        if (k >= 0) {
            dtrs[k] = dtrs[k].increment(cs, start + 1, end, incr);
            return NodeFactory.createNode(dtrCs, dtrs, this.count() + (long)incr);
        }
        char[] newCs = new char[dtrCs.length + 1];
        Node[] newDtrs = new Node[dtrs.length + 1];
        for (i = 0; i < dtrCs.length && dtrCs[i] < cs[start]; ++i) {
            newCs[i] = dtrCs[i];
            newDtrs[i] = dtrs[i];
        }
        newCs[i] = cs[start];
        newDtrs[i] = NodeFactory.createNode(cs, start + 1, end, (long)incr);
        while (i < dtrCs.length) {
            newCs[i + 1] = dtrCs[i];
            newDtrs[i + 1] = dtrs[i];
            ++i;
        }
        return NodeFactory.createNode(newCs, newDtrs, this.count() + (long)incr);
    }

    @Override
    public long size() {
        Node[] dtrs = this.dtrs();
        long size = 1L;
        for (int i = 0; i < dtrs.length; ++i) {
            size += dtrs[i].size();
        }
        return size;
    }

    @Override
    public void topNGramsDtrs(NBestCounter counter, char[] csAccum, int level, int dtrLevel) {
        Node[] dtrs = this.dtrs();
        char[] cs = this.chars();
        for (int i = 0; i < dtrs.length; ++i) {
            csAccum[level] = cs[i];
            dtrs[i].topNGrams(counter, csAccum, level + 1, dtrLevel - 1);
        }
    }

    @Override
    public void addDtrNGramCounts(long[][] uniqueTotalCounts, int depth) {
        Node[] dtrs = this.dtrs();
        for (int i = 0; i < dtrs.length; ++i) {
            dtrs[i].addNGramCounts(uniqueTotalCounts, depth);
        }
    }

    @Override
    public long dtrUniqueNGramCount(int dtrLevel) {
        Node[] dtrs = this.dtrs();
        long sum = 0L;
        for (int i = 0; i < dtrs.length; ++i) {
            sum += dtrs[i].uniqueNGramCount(dtrLevel);
        }
        return sum;
    }

    @Override
    public long dtrTotalNGramCount(int dtrLevel) {
        Node[] dtrs = this.dtrs();
        long sum = 0L;
        for (int i = 0; i < dtrs.length; ++i) {
            sum += dtrs[i].totalNGramCount(dtrLevel);
        }
        return sum;
    }

    @Override
    public void addDtrCounts(List<Long> accum, int nGramOrder) {
        Node[] dtrs = this.dtrs();
        for (int i = 0; i < dtrs.length; ++i) {
            dtrs[i].addCounts(accum, nGramOrder);
        }
    }

    @Override
    public void addDaughters(LinkedList<Node> queue) {
        Node[] dtrs = this.dtrs();
        for (int i = 0; i < dtrs.length; ++i) {
            queue.addLast(dtrs[i]);
        }
    }

    @Override
    public char[] outcomes(char[] cs, int start, int end) {
        if (start == end) {
            return this.chars();
        }
        Node dtr = this.getDtr(cs[start]);
        if (dtr == null) {
            return Strings.EMPTY_CHAR_ARRAY;
        }
        return dtr.outcomes(cs, start + 1, end);
    }

    @Override
    public void countNodeTypes(ObjectToCounterMap<String> counter) {
        counter.increment(this.getClass().toString());
        Node[] dtrs = this.dtrs();
        for (int i = 0; i < dtrs.length; ++i) {
            dtrs[i].countNodeTypes(counter);
        }
    }

    @Override
    public void toString(StringBuilder sb, int depth) {
        char[] cs = this.chars();
        Node[] dtrs = this.dtrs();
        sb.append(' ');
        sb.append(this.count());
        for (int i = 0; i < dtrs.length; ++i) {
            AbstractDtrNode.toString(sb, cs[i], dtrs[i], depth);
        }
    }

    @Override
    public Node prune(long minCount) {
        long count = this.count();
        if (count < minCount) {
            return null;
        }
        Node[] dtrs = this.dtrs();
        for (int i = 0; i < dtrs.length; ++i) {
            dtrs[i] = dtrs[i].prune(minCount);
        }
        return NodeFactory.createNodePrune(this.chars(), dtrs, count);
    }
}

