/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import com.aliasi.chunk.Chunk;

public class ChunkFactory {
    public static final String DEFAULT_CHUNK_TYPE = "CHUNK";
    public static final double DEFAULT_CHUNK_SCORE = Double.NEGATIVE_INFINITY;

    private ChunkFactory() {
    }

    public static Chunk createChunk(int start, int end) {
        ChunkFactory.validateSpan(start, end);
        return new StartEndChunk(start, end);
    }

    public static Chunk createChunk(int start, int end, String type) {
        ChunkFactory.validateSpan(start, end);
        return new StartEndTypeChunk(start, end, type);
    }

    public static Chunk createChunk(int start, int end, double score) {
        ChunkFactory.validateSpan(start, end);
        return new StartEndScoreChunk(start, end, score);
    }

    public static Chunk createChunk(int start, int end, String type, double score) {
        ChunkFactory.validateSpan(start, end);
        return new StartEndTypeScoreChunk(start, end, type, score);
    }

    private static void validateSpan(int start, int end) {
        if (start < 0) {
            String msg = "Start must be >= 0. Found start=" + start;
            throw new IllegalArgumentException(msg);
        }
        if (start > end) {
            String msg = "Start must be > end. Found start=" + start + " end=" + end;
            throw new IllegalArgumentException(msg);
        }
    }

    private static final class StartEndTypeScoreChunk
    extends AbstractChunk {
        private final String mType;
        private final double mScore;

        StartEndTypeScoreChunk(int start, int end, String type, double score) {
            super(start, end);
            this.mType = type;
            this.mScore = score;
        }

        public String type() {
            return this.mType;
        }

        public double score() {
            return this.mScore;
        }
    }

    private static final class StartEndScoreChunk
    extends AbstractChunk {
        private final double mScore;

        StartEndScoreChunk(int start, int end, double score) {
            super(start, end);
            this.mScore = score;
        }

        public double score() {
            return this.mScore;
        }
    }

    private static final class StartEndTypeChunk
    extends AbstractChunk {
        private final String mType;

        StartEndTypeChunk(int start, int end, String type) {
            super(start, end);
            this.mType = type;
        }

        public String type() {
            return this.mType;
        }
    }

    private static final class StartEndChunk
    extends AbstractChunk {
        StartEndChunk(int start, int end) {
            super(start, end);
        }
    }

    private static abstract class AbstractChunk
    implements Chunk {
        private final int mStart;
        private final int mEnd;

        AbstractChunk(int start, int end) {
            this.mStart = start;
            this.mEnd = end;
        }

        public final int start() {
            return this.mStart;
        }

        public final int end() {
            return this.mEnd;
        }

        public String type() {
            return ChunkFactory.DEFAULT_CHUNK_TYPE;
        }

        public double score() {
            return Double.NEGATIVE_INFINITY;
        }

        public boolean equals(Object that) {
            if (!(that instanceof Chunk)) {
                return false;
            }
            Chunk thatChunk = (Chunk)that;
            return this.start() == thatChunk.start() && this.end() == thatChunk.end() && this.score() == thatChunk.score() && this.type().equals(thatChunk.type());
        }

        public int hashCode() {
            int h1 = this.start();
            int h2 = this.end();
            int h3 = this.type().hashCode();
            return h1 + 31 * (h2 + 31 * h3);
        }

        public String toString() {
            return this.start() + "-" + this.end() + ":" + this.type() + "@" + this.score();
        }
    }
}

