/*
 * Decompiled with CFR 0.152.
 */
package wordModel;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeSet;
import symbols.SymbolFreq;
import symbols.SymbolString;
import tsg.corpora.Wsj;
import util.FileUtil;

public class AffixSuffix {
    Hashtable<String, FixValue> affixes = new Hashtable();
    Hashtable<String, FixValue> suffixes = new Hashtable();
    public static int printExtractLength = 5;
    public static int maxLength = 5;
    public static int treshold = 100;

    public AffixSuffix(File flatSentencesFile) {
        Scanner scan = FileUtil.getScanner(flatSentencesFile);
        while (scan.hasNextLine()) {
            String[] words;
            String line = scan.nextLine();
            String[] stringArray = words = line.split("\\s+");
            int n = words.length;
            int n2 = 0;
            while (n2 < n) {
                String w = stringArray[n2];
                this.loadAffixSuffix(w.toLowerCase());
                ++n2;
            }
        }
        scan.close();
    }

    private void loadAffixSuffix(String w) {
        int length = w.length();
        int max = Math.min(maxLength, length - 1);
        SymbolString wordSymbol = new SymbolString(w);
        int i = 1;
        while (i <= max) {
            String affix = w.substring(0, i);
            String suffix = w.substring(length - i);
            this.increaseStringIntArray(this.affixes, affix, wordSymbol);
            this.increaseStringIntArray(this.suffixes, suffix, wordSymbol);
            ++i;
        }
    }

    private void increaseStringIntArray(Hashtable<String, FixValue> table, String fix, SymbolString word) {
        FixValue v = table.get(fix);
        if (v == null) {
            v = new FixValue();
            table.put(fix, v);
        }
        v.addWord(word);
    }

    public void printListAffixSuffix() {
        System.out.println("Affixes\tLength\tTokens\tTypes\tExamples");
        AffixSuffix.printTable(this.affixes, treshold);
        System.out.println("\n\n\nSuffixes\tLength\tTokens\tTypes\tExamples");
        AffixSuffix.printTable(this.suffixes, treshold);
    }

    private static void printTable(Hashtable<String, FixValue> table, int treshold) {
        for (Map.Entry<String, FixValue> e : table.entrySet()) {
            FixValue v = e.getValue();
            int totalTokens = v.totalTokens();
            int totalTypes = v.totalTypes();
            if (totalTokens <= treshold) continue;
            String key = e.getKey();
            System.out.println(String.valueOf(key) + "\t" + key.length() + "\t" + totalTokens + "\t" + totalTypes + "\t" + v.printExtract());
        }
    }

    public void searchSuffix(String string) {
        this.searchFix(this.suffixes, string);
    }

    public void searchAffix(String string) {
        this.searchFix(this.affixes, string);
    }

    private void searchFix(Hashtable<String, FixValue> table, String string) {
        FixValue v = table.get(string);
        if (v == null) {
            System.out.println(String.valueOf(string) + ": no found");
            return;
        }
        int totalTokens = v.totalTokens();
        int totalTypes = v.totalTypes();
        System.out.println(String.valueOf(string) + "\t" + string.length() + "\t" + totalTokens + "\t" + totalTypes + "\t" + v.printExtract());
    }

    public static void main(String[] args) throws IOException {
        printExtractLength = Integer.MAX_VALUE;
        maxLength = 5;
        treshold = 100;
        File flatFileTraining = new File(String.valueOf(Wsj.WsjFlatNoTraces) + "wsj-02-21.mrg");
        AffixSuffix as = new AffixSuffix(flatFileTraining);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String str = "";
        while (str != null) {
            System.out.print("<prompt> ");
            str = in.readLine();
            as.searchAffix(str);
        }
    }

    class FixValue {
        int totalTokens;
        Hashtable<SymbolString, int[]> wordTypes = new Hashtable();

        public void addWord(SymbolString wordType) {
            ++this.totalTokens;
            this.increaseSymbolIntArray(wordType);
        }

        public void increaseSymbolIntArray(SymbolString key) {
            int[] freq = this.wordTypes.get(key);
            if (freq == null) {
                freq = new int[]{1};
                this.wordTypes.put(key, freq);
            } else {
                freq[0] = freq[0] + 1;
            }
        }

        public TreeSet<SymbolFreq> getSortedSet() {
            TreeSet<SymbolFreq> result = new TreeSet<SymbolFreq>();
            for (Map.Entry<SymbolString, int[]> e : this.wordTypes.entrySet()) {
                result.add(new SymbolFreq(e.getKey(), e.getValue()[0]));
            }
            return result;
        }

        public int totalTypes() {
            return this.wordTypes.size();
        }

        public int totalTokens() {
            return this.totalTokens;
        }

        public String printExtract() {
            String result = "";
            int i = 0;
            TreeSet<SymbolFreq> sortedSet = this.getSortedSet();
            Iterator<SymbolFreq> iter = sortedSet.descendingIterator();
            while (iter.hasNext() && i < printExtractLength) {
                result = String.valueOf(result) + iter.next().toString() + ", ";
                ++i;
            }
            result = String.valueOf(result) + "...";
            return result;
        }
    }
}

