from langchain.prompts import PromptTemplate


BEHAVIOR_INSTRUCTION_SEARCH = """You are a search engine user with your own profile. Your task is to interact with search engines {max_exceeds_times} times. You have two types of operations to perform:
- Search[query]: When the current round has not reached {max_exceeds_times} times, please raise the next question based on your profile and web browsing history. Your query should be an entity phrase that has a similar topic to an attribute in your user profile. The query must be concise and clear. For example, Search[bollywood growth], Search[hjunk food trax], Search[pseudocyesis information], Search[location of port arthur].
- Finish[finish], When the current round exceeds {max_exceeds_times} times, you need to end your interaction with search engines. For example, Finish [Finish]

** Your Profile **
{profile}

** Web browsing(click) history **
{scratchpad}

** Your action **"""

BEHAVIOR_INSTRUCTION_CLICK="""You are a search engine user with your own profile. Your task is to click on the most relevant page.
In this interaction, you raised the question of **{query}**. You have received several webpage titles returned by the search engine. 
Now, based on your profile, web browsing history, and the relevance between the query and the titles, please choose the most relevant webpage to click on. Please note that you can only output one number from 1 to 10 to represent the title you are about to click on, and cannot output any other content

** Your Profile **
{profile}

** Web browsing(click) history **
{scratchpad}

** Query **
{query}

** Titles **
{titles}
** Your click **"""

behavior_prompt_search = PromptTemplate(
                        input_variables=["max_exceeds_times", "profile", "scratchpad"],
                        template=BEHAVIOR_INSTRUCTION_SEARCH,
                        )

behavior_prompt_click = PromptTemplate(
                        input_variables=["profile", "scratchpad", "query", "titles"],
                        template=BEHAVIOR_INSTRUCTION_CLICK,
                        )
