import json
import os


def load_prompt(prompt):
    prompt_path = f'src/dt/prompts/{prompt}.txt'
    with open(prompt_path, 'r') as f:
        prompt = f.read()
    return prompt


def load_text(text_path):
    with open(text_path, 'r') as f:
        text = f.read()
    return text


def load_apis():
    apis = load_text(f"src/dt/prompts/apis.py")
    apis = '\n'.join(apis.split('\n\n'))
    return apis


def load_json(file_path, **kwargs):
    with open(file_path, "r") as f:
        return json.load(f, **kwargs)


def dump_json(data, file_path, **kwargs):
    with open(file_path, "w") as f:
        json.dump(data, f, **kwargs)
