import os
import json
import argparse
from datetime import datetime

import yaml
from yamlinclude import YamlIncludeConstructor
YamlIncludeConstructor.add_to_loader_class(loader_class=yaml.FullLoader)


def make_dir(path):
    os.makedirs(path, exist_ok=True)


def read_yaml(path):
    with open(path) as file:
        config = yaml.load(file, Loader=yaml.FullLoader)
    return config


def update_args(args, path, key=None):
    config = read_yaml(path)
    if config:
        args = vars(args)
        if key:
            args[key] = config
        else:
            args.update(config)

        args = restructure_as_namespace(args)
    return args


def restructure_as_namespace(args):
    if not isinstance(args, dict):
        return args

    for key in args:
        args[key] = restructure_as_namespace(args[key])

    args = argparse.Namespace(**args)

    return args
def read_texts(path):
    texts = list()
    with open(path, 'r') as file:
        texts = file.read()
    return texts


def save_texts(texts, path, mode='w'):
    with open(path, mode) as file:
        for line in texts:
            file.write(line)


def read_json(path):
    with open(path, 'r') as file:
        data = json.load(file)
    return data


def save_json(data, path, mode='w'):
    with open(path, mode) as file:
        json.dump(data, file, indent=4)


def get_timestamp():
    current_time = datetime.now()
    time_str = current_time.strftime("%Y-%m-%d %H:%M:%S")
    return time_str


def chunk_by_size(data_list, sizes):

    assert sum(sizes) == len(data_list)

    rnt = []
    i = 0
    for s in sizes:
        rnt.append(data_list[i:i+s])
        i += s

    return rnt
