/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.patterns.surface.ConstantsAndVariables;
import edu.stanford.nlp.patterns.surface.PatternToken;
import edu.stanford.nlp.patterns.surface.SurfacePattern;
import edu.stanford.nlp.util.Execution;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Triple;
import edu.stanford.nlp.util.TypesafeMap;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class CreatePatterns {
    @Execution.Option(name="usePOS4Pattern")
    public boolean usePOS4Pattern = true;
    @Execution.Option(name="addPatWithoutPOS")
    public boolean addPatWithoutPOS = true;
    @Execution.Option(name="minWindow4Pattern")
    public int minWindow4Pattern = 2;
    @Execution.Option(name="maxWindow4Pattern")
    public int maxWindow4Pattern = 4;
    @Execution.Option(name="usePreviousContext")
    public boolean usePreviousContext = true;
    @Execution.Option(name="useNextContext")
    public boolean useNextContext = false;
    @Execution.Option(name="numMinStopWordsToAdd")
    public int numMinStopWordsToAdd = 3;
    @Execution.Option(name="useFillerWordsInPat")
    public boolean useFillerWordsInPat = true;
    @Execution.Option(name="useStopWordsBeforeTerm")
    public boolean useStopWordsBeforeTerm = false;
    ConstantsAndVariables constVars;

    public CreatePatterns(Properties props, ConstantsAndVariables constVars) throws IOException {
        this.constVars = constVars;
        Execution.fillOptions(ConstantsAndVariables.class, props);
        constVars.setUp(props);
        this.setUp(props);
    }

    void setUp(Properties props) {
        Execution.fillOptions((Object)this, props);
        if (!this.addPatWithoutPOS && !this.usePOS4Pattern) {
            throw new RuntimeException("addPatWithoutPOS and usePOS4Pattern both cannot be false ");
        }
    }

    boolean doNotUse(String word, Set<String> stopWords) {
        return stopWords.contains(word.toLowerCase()) || this.constVars.ignoreWordRegex.matcher(word).matches();
    }

    Triple<Boolean, String, String> getContextTokenStr(CoreLabel tokenj) {
        String nerTag;
        String strgeneric = "";
        String strOriginal = "";
        boolean isLabeledO = true;
        for (Map.Entry<String, Class<? extends TypesafeMap.Key<String>>> entry : this.constVars.answerClass.entrySet()) {
            if (((String)tokenj.get(entry.getValue())).equals(this.constVars.backgroundSymbol)) continue;
            isLabeledO = false;
            if (strgeneric.isEmpty()) {
                strgeneric = "{" + entry.getKey() + ":" + entry.getKey() + "}";
                strOriginal = entry.getKey();
                continue;
            }
            strgeneric = strgeneric + " | {" + entry.getKey() + ":" + entry.getKey() + "}";
            strOriginal = strOriginal + "|" + entry.getKey();
        }
        for (Map.Entry<String, Class<? extends TypesafeMap.Key<String>>> entry : this.constVars.getGeneralizeClasses().entrySet()) {
            if (tokenj.get(entry.getValue()).equals(this.constVars.backgroundSymbol)) continue;
            isLabeledO = false;
            if (strgeneric.isEmpty()) {
                strgeneric = "{" + entry.getKey() + ":" + tokenj.get(entry.getValue()) + "}";
                strOriginal = entry.getKey();
                continue;
            }
            strgeneric = strgeneric + " | {" + entry.getKey() + ":" + tokenj.get(entry.getValue()) + "}";
            strOriginal = strOriginal + "|" + entry.getKey();
        }
        if (this.constVars.useContextNERRestriction && (nerTag = (String)tokenj.get(CoreAnnotations.NamedEntityTagAnnotation.class)) != null && !nerTag.equals("O")) {
            isLabeledO = false;
            if (strgeneric.isEmpty()) {
                strgeneric = "{ner:" + nerTag + "}";
                strOriginal = nerTag;
            } else {
                strgeneric = strgeneric + " | {ner:" + nerTag + "}";
                strOriginal = strOriginal + "|" + nerTag;
            }
        }
        return new Triple<Boolean, String, String>(isLabeledO, strgeneric, strOriginal);
    }

    public Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>> getContext(List<CoreLabel> sent, int i) {
        HashSet<SurfacePattern> prevpatterns = new HashSet<SurfacePattern>();
        HashSet<SurfacePattern> nextpatterns = new HashSet<SurfacePattern>();
        HashSet<SurfacePattern> prevnextpatterns = new HashSet<SurfacePattern>();
        CoreLabel token = sent.get(i);
        String tag = null;
        if (this.usePOS4Pattern) {
            String fulltag = token.tag();
            tag = fulltag.substring(0, Math.min(fulltag.length(), 2));
        }
        String nerTag = (String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class);
        for (int maxWin = 1; maxWin <= this.maxWindow4Pattern; ++maxWin) {
            SurfacePattern patPOS;
            SurfacePattern pat;
            String str;
            String strOriginal;
            String strgeneric;
            boolean isLabeledO;
            Triple<Boolean, String, String> tr;
            String tokenjStr;
            CoreLabel tokenj;
            ArrayList<String> previousTokens = new ArrayList<String>();
            ArrayList<String> originalPrev = new ArrayList<String>();
            ArrayList<String> originalNext = new ArrayList<String>();
            ArrayList<String> nextTokens = new ArrayList<String>();
            int numStopWordsprev = 0;
            int numStopWordsnext = 0;
            int numNonStopWordsNext = 0;
            int numNonStopWordsPrev = 0;
            boolean useprev = false;
            boolean usenext = false;
            PatternToken twithoutPOS = null;
            if (this.addPatWithoutPOS) {
                twithoutPOS = new PatternToken(tag, false, this.constVars.numWordsCompound > 1, this.constVars.numWordsCompound, nerTag, this.constVars.useTargetNERRestriction, this.constVars.useTargetParserParentRestriction, (String)token.get(CoreAnnotations.GrandparentAnnotation.class));
            }
            PatternToken twithPOS = null;
            if (this.usePOS4Pattern) {
                twithPOS = new PatternToken(tag, true, this.constVars.numWordsCompound > 1, this.constVars.numWordsCompound, nerTag, this.constVars.useTargetNERRestriction, this.constVars.useTargetParserParentRestriction, (String)token.get(CoreAnnotations.GrandparentAnnotation.class));
            }
            if (this.usePreviousContext) {
                int j = i - 1;
                int numTokens = 0;
                while (numTokens < maxWin && j >= 0) {
                    tokenj = sent.get(j);
                    tokenjStr = this.constVars.useLemmaContextTokens ? tokenj.lemma() : tokenj.word();
                    if (this.useFillerWordsInPat && this.constVars.fillerWords.contains(tokenj.word().toLowerCase())) {
                        --j;
                        continue;
                    }
                    tr = this.getContextTokenStr(tokenj);
                    isLabeledO = (Boolean)tr.first;
                    strgeneric = (String)tr.second;
                    strOriginal = (String)tr.third;
                    if (!isLabeledO) {
                        previousTokens.add(0, "[" + strgeneric + "]");
                        originalPrev.add(0, strOriginal);
                        ++numNonStopWordsPrev;
                    } else {
                        if (tokenj.word().startsWith("http")) {
                            useprev = false;
                            previousTokens.clear();
                            originalPrev.clear();
                            break;
                        }
                        str = SurfacePattern.getContextStr(tokenj, this.constVars.useLemmaContextTokens, this.constVars.matchLowerCaseContext);
                        previousTokens.add(0, str);
                        originalPrev.add(0, tokenjStr);
                        if (this.doNotUse(tokenjStr, this.constVars.getStopWords())) {
                            ++numStopWordsprev;
                        } else {
                            ++numNonStopWordsPrev;
                        }
                    }
                    ++numTokens;
                    --j;
                }
            }
            if (this.useNextContext) {
                int numTokens = 0;
                int j = i + 1;
                while (numTokens < maxWin && j < sent.size()) {
                    tokenj = sent.get(j);
                    tokenjStr = this.constVars.useLemmaContextTokens ? tokenj.lemma() : tokenj.word();
                    if (this.useFillerWordsInPat && this.constVars.fillerWords.contains(tokenj.word().toLowerCase())) {
                        ++j;
                        continue;
                    }
                    tr = this.getContextTokenStr(tokenj);
                    isLabeledO = (Boolean)tr.first;
                    strgeneric = (String)tr.second;
                    strOriginal = (String)tr.third;
                    if (!isLabeledO) {
                        ++numNonStopWordsNext;
                        nextTokens.add("[" + strgeneric + "]");
                        originalNext.add(strOriginal);
                    } else {
                        if (tokenj.word().startsWith("http")) {
                            usenext = false;
                            nextTokens.clear();
                            originalNext.clear();
                            break;
                        }
                        str = SurfacePattern.getContextStr(tokenj, this.constVars.useLemmaContextTokens, this.constVars.matchLowerCaseContext);
                        nextTokens.add(str);
                        originalNext.add(tokenjStr);
                        if (this.doNotUse(tokenjStr, this.constVars.getStopWords())) {
                            ++numStopWordsnext;
                        } else {
                            ++numNonStopWordsNext;
                        }
                    }
                    ++j;
                    ++numTokens;
                }
            }
            String fw = "";
            if (this.useFillerWordsInPat) {
                fw = " $FILLER{0,2} ";
            }
            String sw = "";
            if (this.useStopWordsBeforeTerm) {
                sw = " $STOPWORD{0,2} ";
            }
            String[] prevContext = null;
            String[] prevOriginalArr = null;
            if (previousTokens.size() >= this.minWindow4Pattern && (numNonStopWordsPrev > 0 || numStopWordsprev > this.numMinStopWordsToAdd)) {
                ArrayList<String> prevContextList = new ArrayList<String>();
                ArrayList<String> prevOriginal = new ArrayList<String>();
                for (String p : previousTokens) {
                    prevContextList.add(p);
                    if (fw.isEmpty()) continue;
                    prevContextList.add(fw.trim());
                }
                for (String p : originalPrev) {
                    prevOriginal.add(p);
                    if (fw.isEmpty()) continue;
                    prevOriginal.add(" FW ");
                }
                if (!sw.isEmpty()) {
                    prevContextList.add(sw.trim());
                    prevOriginal.add(" SW ");
                }
                if (CreatePatterns.isASCII(StringUtils.join(prevOriginal))) {
                    prevContext = prevContextList.toArray(new String[0]);
                    prevOriginalArr = prevOriginal.toArray(new String[0]);
                    if (previousTokens.size() >= this.minWindow4Pattern) {
                        if (twithoutPOS != null) {
                            pat = new SurfacePattern(prevContext, twithoutPOS, null, SurfacePattern.Genre.PREV);
                            prevpatterns.add(pat);
                        }
                        if (twithPOS != null) {
                            patPOS = new SurfacePattern(prevContext, twithPOS, null, SurfacePattern.Genre.PREV);
                            prevpatterns.add(patPOS);
                        }
                    }
                    useprev = true;
                }
            }
            String[] nextContext = null;
            String[] nextOriginalArr = null;
            if (nextTokens.size() > 0 && (numNonStopWordsNext > 0 || numStopWordsnext > this.numMinStopWordsToAdd)) {
                ArrayList<String> nextContextList = new ArrayList<String>();
                ArrayList<String> nextOriginal = new ArrayList<String>();
                if (!sw.isEmpty()) {
                    nextContextList.add(sw.trim());
                    nextOriginal.add(" SW ");
                }
                for (String n : nextTokens) {
                    if (!fw.isEmpty()) {
                        nextContextList.add(fw);
                    }
                    nextContextList.add(n);
                }
                for (String n : originalNext) {
                    if (!fw.isEmpty()) {
                        nextOriginal.add(" FW ");
                    }
                    nextOriginal.add(n);
                }
                if (nextTokens.size() >= this.minWindow4Pattern) {
                    nextContext = nextContextList.toArray(new String[0]);
                    nextOriginalArr = nextOriginal.toArray(new String[0]);
                    if (twithoutPOS != null) {
                        SurfacePattern pat2 = new SurfacePattern(null, twithoutPOS, nextContext, SurfacePattern.Genre.NEXT);
                        nextpatterns.add(pat2);
                    }
                    if (twithPOS != null) {
                        SurfacePattern patPOS2 = new SurfacePattern(null, twithPOS, nextContext, SurfacePattern.Genre.NEXT);
                        nextpatterns.add(patPOS2);
                    }
                }
                usenext = true;
            }
            if (!useprev || !usenext || previousTokens.size() + nextTokens.size() < this.minWindow4Pattern) continue;
            if (twithoutPOS != null) {
                pat = new SurfacePattern(prevContext, twithoutPOS, nextContext, SurfacePattern.Genre.PREVNEXT);
                prevnextpatterns.add(pat);
            }
            if (twithPOS == null) continue;
            patPOS = new SurfacePattern(prevContext, twithPOS, nextContext, SurfacePattern.Genre.PREVNEXT);
            prevnextpatterns.add(patPOS);
        }
        Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>> patterns = new Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>(prevpatterns, nextpatterns, prevnextpatterns);
        return patterns;
    }

    public static boolean isASCII(String text) {
        Charset charset = Charset.forName("US-ASCII");
        String checked = new String(text.getBytes(charset), charset);
        return checked.equals(text);
    }

    public Map<String, Map<Integer, Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>>> getAllPatterns(String label, Map<String, List<CoreLabel>> sents) throws InterruptedException, ExecutionException {
        HashMap<String, Map<Integer, Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>>> patternsForEachToken = new HashMap<String, Map<Integer, Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>>>();
        ArrayList<String> keyset = new ArrayList<String>(sents.keySet());
        int num = 0;
        num = this.constVars.numThreads == 1 ? keyset.size() : keyset.size() / this.constVars.numThreads;
        ExecutorService executor = Executors.newFixedThreadPool(this.constVars.numThreads);
        Redwood.log(ConstantsAndVariables.extremedebug, "Computing all patterns. keyset size is " + keyset.size() + ". Assigning " + num + " values to each thread");
        ArrayList<Future<Map<String, Map<Integer, Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>>>>> list = new ArrayList<Future<Map<String, Map<Integer, Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>>>>>();
        for (int i = 0; i < this.constVars.numThreads; ++i) {
            int n = i * num;
            int to = -1;
            to = i == this.constVars.numThreads - 1 ? keyset.size() : Math.min(keyset.size(), (i + 1) * num);
            CreatePatternsThread task = null;
            List<String> ids = keyset.subList(n, to);
            task = new CreatePatternsThread(sents, ids);
            Future<Map<String, Map<Integer, Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>>>> submit = executor.submit(task);
            list.add(submit);
        }
        for (Future future : list) {
            try {
                patternsForEachToken.putAll((Map)future.get());
            }
            catch (Exception e) {
                executor.shutdownNow();
                throw new RuntimeException(e);
            }
        }
        executor.shutdown();
        Redwood.log(ConstantsAndVariables.extremedebug, "Done computing all patterns");
        return patternsForEachToken;
    }

    public class CreatePatternsThread
    implements Callable<Map<String, Map<Integer, Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>>>> {
        Map<String, List<CoreLabel>> sents;
        List<String> sentIds;

        public CreatePatternsThread(Map<String, List<CoreLabel>> sents, List<String> sentIds) {
            this.sents = sents;
            this.sentIds = sentIds;
        }

        @Override
        public Map<String, Map<Integer, Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>>> call() throws Exception {
            HashMap<String, Map<Integer, Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>>> patternsForTokens = new HashMap<String, Map<Integer, Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>>>();
            for (String id : this.sentIds) {
                List<CoreLabel> sent = this.sents.get(id);
                HashMap<Integer, Triple<Set<Object>, Set<Object>, Set<Object>>> p = new HashMap<Integer, Triple<Set<Object>, Set<Object>, Set<Object>>>();
                for (int i = 0; i < sent.size(); ++i) {
                    p.put(i, new Triple(new HashSet(), new HashSet(), new HashSet()));
                    CoreLabel token = sent.get(i);
                    if (CreatePatterns.this.doNotUse(token.word(), CreatePatterns.this.constVars.getStopWords())) continue;
                    Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>> pat = CreatePatterns.this.getContext(sent, i);
                    p.put(i, pat);
                }
                patternsForTokens.put(id, p);
            }
            return patternsForTokens;
        }
    }
}

