/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.maxent.iis;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.PrintFile;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.maxent.Experiments;
import edu.stanford.nlp.maxent.Feature;
import edu.stanford.nlp.maxent.Problem;
import edu.stanford.nlp.util.MutableDouble;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.NumberFormat;

public class LambdaSolve {
    public double[] lambda;
    protected boolean[] lambda_converged;
    protected double eps;
    private boolean fixedFnumXY;
    protected Problem p;
    protected double[][] probConds;
    protected double[] zlambda;
    protected byte[][] fnumArr;
    protected double[] ftildeArr;
    private static final boolean smooth = false;
    private static final boolean VERBOSE = false;
    private boolean ASSUME_BINARY = false;
    private double[] aux;
    private double[][] sum;
    private double[][] sub;
    public boolean weightRanks = false;
    private boolean convertValues = false;

    public LambdaSolve(Problem p1, double eps1, double nerr1) {
        int i;
        this.p = p1;
        this.eps = eps1;
        this.probConds = new double[this.p.data.xSize][];
        System.err.println("xSize is " + this.p.data.xSize);
        for (i = 0; i < this.p.data.xSize; ++i) {
            this.probConds[i] = new double[this.p.data.numY(i)];
        }
        this.fnumArr = new byte[this.p.data.xSize][];
        for (i = 0; i < this.p.data.xSize; ++i) {
            this.fnumArr[i] = new byte[this.p.data.numY(i)];
        }
        this.zlambda = new double[this.p.data.xSize];
        this.ftildeArr = new double[this.p.fSize];
        this.initCondsZlambdaEtc();
        if (this.convertValues) {
            this.transformValues();
        }
    }

    public LambdaSolve(String filename) {
        this.readL(filename);
    }

    public LambdaSolve() {
    }

    public void setNonBinary() {
        this.ASSUME_BINARY = false;
    }

    public void setBinary() {
        this.ASSUME_BINARY = true;
    }

    public void transformValues() {
        for (int x = 0; x < this.p.data.values.length; ++x) {
            int y;
            double highest = this.p.data.values[x][0];
            double sumhighest = 0.0;
            double sumrest = 0.0;
            for (y = 0; y < this.p.data.values[x].length; ++y) {
                if (!(this.p.data.values[x][y] > highest)) continue;
                highest = this.p.data.values[x][y];
            }
            for (y = 0; y < this.p.data.values[x].length; ++y) {
                if (this.p.data.values[x][y] == highest) {
                    sumhighest += highest;
                    continue;
                }
                sumrest += this.p.data.values[x][y];
            }
            if (sumrest == 0.0) continue;
            for (y = 0; y < this.p.data.values[x].length; ++y) {
                this.p.data.values[x][y] = this.p.data.values[x][y] == highest ? 0.7 * highest / sumhighest : 0.3 * this.p.data.values[x][y] / sumrest;
            }
        }
    }

    void initCondsZlambdaEtc() {
        int x;
        for (x = 0; x < this.p.data.xSize; ++x) {
            for (int y = 0; y < this.probConds[x].length; ++y) {
                this.probConds[x][y] = 1.0 / (double)this.probConds[x].length;
            }
        }
        for (x = 0; x < this.p.data.xSize; ++x) {
            this.zlambda[x] = this.probConds[x].length;
        }
        for (int i = 0; i < this.p.fSize; ++i) {
            this.ftildeArr[i] = this.p.functions.get(i).ftilde();
            this.p.functions.get(i).setSum();
            Feature f = this.p.functions.get(i);
            for (int j = 0; j < f.len(); ++j) {
                int x2 = f.getX(j);
                int y = f.getY(j);
                byte[] byArray = this.fnumArr[x2];
                int n = y;
                byArray[n] = (byte)((double)byArray[n] + f.getVal(j));
            }
        }
        byte constAll = this.fnumArr[0][0];
        this.fixedFnumXY = true;
        block5: for (int x3 = 0; x3 < this.p.data.xSize; ++x3) {
            for (int y = 0; y < this.fnumArr[x3].length; ++y) {
                if (this.fnumArr[x3][y] == constAll) continue;
                this.fixedFnumXY = false;
                continue block5;
            }
        }
    }

    public void improvedIterative() {
        boolean flag;
        int iterations = 0;
        this.lambda_converged = new boolean[this.p.fSize];
        int numNConverged = this.p.fSize;
        do {
            flag = false;
            ++iterations;
            for (int i = 0; i < this.lambda.length; ++i) {
                if (this.lambda_converged[i]) continue;
                MutableDouble deltaI = new MutableDouble();
                boolean fl = this.iterate(i, this.eps, deltaI);
                if (fl) {
                    flag = true;
                    this.updateConds(i, deltaI.doubleValue());
                    continue;
                }
                --numNConverged;
            }
        } while (flag && iterations < 1000);
    }

    public void improvedIterative(int iters) {
        int iterations = 0;
        this.lambda_converged = new boolean[this.p.fSize];
        int numNConverged = this.p.fSize;
        do {
            ++iterations;
            for (int i = 0; i < this.lambda.length; ++i) {
                if (this.lambda_converged[i]) continue;
                MutableDouble deltaI = new MutableDouble();
                boolean fl = this.iterate(i, this.eps, deltaI);
                if (fl) {
                    this.updateConds(i, deltaI.doubleValue());
                    continue;
                }
                --numNConverged;
            }
            if (iterations % 100 == 0) {
                this.save_lambdas(iterations + ".lam");
            }
            System.err.println(iterations);
        } while (iterations < iters);
    }

    boolean iterate(int index, double err2, MutableDouble ret) {
        double deltaL = 0.0;
        if (Math.abs((deltaL = this.newton(deltaL, index, err2)) + this.lambda[index]) > 200.0) {
            deltaL = deltaL + this.lambda[index] > 200.0 ? 200.0 - this.lambda[index] : -this.lambda[index] - 200.0;
            System.err.println("set delta to smth " + deltaL);
        }
        this.lambda[index] = this.lambda[index] + deltaL;
        if (Double.isNaN(deltaL)) {
            System.err.println(" NaN " + index + ' ' + deltaL);
        }
        ret.set(deltaL);
        return Math.abs(deltaL) >= this.eps;
    }

    double newton(double lambda0, int index, double err2) {
        double gVal;
        double lambdaN = lambda0;
        int i = 0;
        if (this.fixedFnumXY) {
            double plambda = this.fExpected(this.p.functions.get(index));
            return 1.0 / (double)this.fnumArr[0][0] * (Math.log(this.ftildeArr[index]) - Math.log(plambda));
        }
        do {
            ++i;
            double lambdaP = lambdaN;
            double gPrimeVal = this.gprime(lambdaP, index);
            if (Double.isNaN(gPrimeVal)) {
                System.err.println("gPrime of " + lambdaP + " " + index + " is NaN " + gPrimeVal);
            }
            gVal = this.g(lambdaP, index);
            if (gPrimeVal == 0.0) {
                return 0.0;
            }
            lambdaN = lambdaP - gVal / gPrimeVal;
            if (Double.isNaN(lambdaN)) {
                System.err.println("the division of " + gVal + " " + gPrimeVal + " " + index + " is NaN " + lambdaN);
                return 0.0;
            }
            if (!(Math.abs(lambdaN - lambdaP) < err2)) continue;
            return lambdaN;
        } while (i <= 100);
        if (Math.abs(gVal) > 0.01) {
            return 0.0;
        }
        return lambdaN;
    }

    void updateConds(int index, double deltaL) {
        for (int i = 0; i < this.p.functions.get(index).len(); ++i) {
            double s = 0.0;
            int x = this.p.functions.get(index).getX(i);
            int y = this.p.functions.get(index).getY(i);
            double val = this.p.functions.get(index).getVal(i);
            double zlambdaX = this.zlambda[x] + this.pcond(y, x) * this.zlambda[x] * (Math.exp(deltaL * val) - 1.0);
            for (int y1 = 0; y1 < this.probConds[x].length; ++y1) {
                this.probConds[x][y1] = this.probConds[x][y1] * this.zlambda[x] / zlambdaX;
                s += this.probConds[x][y1];
            }
            s -= this.probConds[x][y];
            this.probConds[x][y] = this.probConds[x][y] * Math.exp(deltaL * val);
            s += this.probConds[x][y];
            this.zlambda[x] = zlambdaX;
            if (!(Math.abs(s - 1.0) > 0.001)) continue;
        }
    }

    public double pcond(int y, int x) {
        return this.probConds[x][y];
    }

    protected double fnum(int x, int y) {
        return this.fnumArr[x][y];
    }

    double g(double lambdaP, int index) {
        double s = 0.0;
        for (int i = 0; i < this.p.functions.get(index).len(); ++i) {
            int y = this.p.functions.get(index).getY(i);
            int x = this.p.functions.get(index).getX(i);
            double exponent = Math.exp(lambdaP * this.fnum(x, y));
            s += this.p.data.ptildeX(x) * this.pcond(y, x) * this.p.functions.get(index).getVal(i) * exponent;
        }
        return s -= this.ftildeArr[index];
    }

    double gprime(double lambdaP, int index) {
        double s = 0.0;
        for (int i = 0; i < this.p.functions.get(index).len(); ++i) {
            int y = this.p.functions.get(index).getY(i);
            int x = this.p.functions.get(index).getX(i);
            s += this.p.data.ptildeX(x) * this.pcond(y, x) * this.p.functions.get(index).getVal(i) * Math.exp(lambdaP * this.fnum(x, y)) * this.fnum(x, y);
        }
        return s;
    }

    double fExpected(Feature f) {
        double s = 0.0;
        for (int i = 0; i < f.len(); ++i) {
            int x = f.getX(i);
            int y = f.getY(i);
            s += this.p.data.ptildeX(x) * this.pcond(y, x) * f.getVal(i);
        }
        return s;
    }

    public boolean checkCorrectness() {
        boolean flag = true;
        for (int f = 0; f < this.lambda.length; ++f) {
            if (!(Math.abs(this.lambda[f]) > 100.0)) continue;
            System.err.println("lambda " + f + " too big " + this.lambda[f]);
            System.err.println("empirical " + this.ftildeArr[f] + " expected " + this.fExpected(this.p.functions.get(f)));
        }
        System.err.println(" x size" + this.p.data.xSize + " " + " ysize " + this.p.data.ySize);
        double summAllExp = 0.0;
        for (int i = 0; i < this.ftildeArr.length; ++i) {
            double exp = Math.abs(this.ftildeArr[i] - this.fExpected(this.p.functions.get(i)));
            summAllExp += this.ftildeArr[i];
            if (!(exp > 0.001)) continue;
            flag = false;
            System.err.println("Constraint not satisfied  " + i + " " + this.fExpected(this.p.functions.get(i)) + " " + this.ftildeArr[i] + " lambda " + this.lambda[i]);
        }
        System.err.println(" The sum of all empirical expectations is " + summAllExp);
        for (int x = 0; x < this.p.data.xSize; ++x) {
            int y;
            double s = 0.0;
            for (y = 0; y < this.probConds[x].length; ++y) {
                s += this.probConds[x][y];
            }
            if (!(Math.abs(s - 1.0) > 1.0E-4)) continue;
            for (y = 0; y < this.probConds[x].length; ++y) {
                System.err.println("probabilities do not sum to one " + x + " " + (float)s);
            }
        }
        return flag;
    }

    double ZAlfa(double alfa, Feature f, int x) {
        double s = 0.0;
        for (int y = 0; y < this.probConds[x].length; ++y) {
            s += this.pcond(y, x) * Math.exp(alfa * f.getVal(x, y));
        }
        return s;
    }

    double GSF(double alfa, Feature f, int index) {
        double s = 0.0;
        for (int x = 0; x < this.p.data.xSize; ++x) {
            s -= this.p.data.ptildeX(x) * Math.log(this.ZAlfa(alfa, f, x));
        }
        return s + alfa * this.ftildeArr[index];
    }

    double GSF(double alfa, Feature f) {
        double s = 0.0;
        for (int x = 0; x < this.p.data.xSize; ++x) {
            s -= this.p.data.ptildeX(x) * Math.log(this.ZAlfa(alfa, f, x));
        }
        return s + alfa * f.ftilde();
    }

    double pcondFAlfa(double alfa, int x, int y, Feature f) {
        double s = 1.0 / this.ZAlfa(alfa, f, x) * this.pcond(y, x) * Math.exp(alfa * f.getVal(x, y));
        return s;
    }

    double GSFPrime(double alfa, Feature f, int index) {
        double s = 0.0;
        s += this.ftildeArr[index];
        for (int x1 = 0; x1 < f.indexedValues.length; ++x1) {
            double s1 = 0.0;
            int x = f.getX(x1);
            int y = f.getY(x1);
            s -= this.p.data.ptildeX(x) * (s1 += this.pcondFAlfa(alfa, x, y, f) * f.getVal(x1));
        }
        return s;
    }

    double GSFPrime(double alfa, Feature f) {
        double s = 0.0;
        s += f.ftilde();
        for (int x1 = 0; x1 < f.indexedValues.length; ++x1) {
            double s1 = 0.0;
            int x = f.getX(x1);
            int y = f.getY(x1);
            s -= this.p.data.ptildeX(x) * (s1 += this.pcondFAlfa(alfa, x, y, f) * f.getVal(x1));
        }
        return s;
    }

    double GSFSecond(double alfa, Feature f) {
        double s = 0.0;
        for (int x = 0; x < this.p.data.xSize; ++x) {
            double s1 = 0.0;
            double psff = 0.0;
            for (int y1 = 0; y1 < this.p.data.ySize; ++y1) {
                psff += this.pcondFAlfa(alfa, x, y1, f) * f.getVal(x, y1);
            }
            for (int y = 0; y < this.probConds[x].length; ++y) {
                s1 += this.pcondFAlfa(alfa, x, y, f) * (f.getVal(x, y) - psff) * (f.getVal(x, y) - psff);
            }
            s -= s1 * this.p.data.ptildeX(x);
        }
        return s;
    }

    public double GainCompute(Feature f, double errorGain) {
        double r = f.ftilde() > this.fExpected(f) ? 1.0 : -1.0;
        f.initHashVals();
        double alfa = 0.0;
        this.GSF(alfa, f);
        double gsfValNew = 0.0;
        for (int iterations = 0; iterations < 30; ++iterations) {
            double alfanext = alfa + r * Math.log(1.0 - r * this.GSFPrime(alfa, f) / this.GSFSecond(alfa, f));
            gsfValNew = this.GSF(alfanext, f);
            if (Math.abs(alfanext - alfa) < errorGain) {
                return gsfValNew;
            }
            alfa = alfanext;
        }
        return gsfValNew;
    }

    public void print() {
        for (int i = 0; i < this.p.data.xSize; ++i) {
            for (int j = 0; j < this.probConds[i].length; ++j) {
                System.out.println("P(" + j + " | " + i + ") = " + this.pcond(j, i));
            }
        }
    }

    public void save_lambdas(String filename) {
        try {
            DataOutputStream rf = IOUtils.getDataOutputStream(filename);
            LambdaSolve.save_lambdas(rf, this.lambda);
            rf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save_lambdas(DataOutputStream rf, double[] lambdas) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(rf);
            oos.writeObject(lambdas);
            oos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readL(String filename) {
        try {
            DataInputStream rf = IOUtils.getDataInputStream(filename);
            this.lambda = LambdaSolve.read_lambdas(rf);
            rf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static double[] read_lambdas(String modelFilename) {
        try {
            DataInputStream rf = IOUtils.getDataInputStream(modelFilename);
            double[] lamb = LambdaSolve.read_lambdas(rf);
            rf.close();
            return lamb;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static double[] read_lambdas(DataInputStream rf) {
        try {
            ObjectInputStream ois = new ObjectInputStream(rf);
            Object o = ois.readObject();
            if (o instanceof double[]) {
                return (double[])o;
            }
            throw new RuntimeIOException("Failed to read lambdas from given input stream");
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeIOException(e);
        }
    }

    void save_problem(String filename) {
        try {
            int i;
            PrintFile pf = new PrintFile(filename);
            int N = this.p.data.xSize;
            int M = this.p.data.ySize;
            int F = this.p.fSize;
            pf.println(N);
            pf.println(M);
            pf.println(F);
            for (i = 0; i < N * M; ++i) {
                pf.print(i + 1);
                pf.print(". ");
                pf.println(this.p.data.ptildeX(i / M));
            }
            for (i = 0; i < this.p.fSize; ++i) {
                int[] values;
                for (int value : values = this.p.functions.get((int)i).indexedValues) {
                    pf.print(i + 1);
                    pf.print(". ");
                    pf.print(value);
                    pf.print(" ");
                    pf.println(1);
                }
            }
            for (i = 0; i < this.p.fSize; ++i) {
                pf.print(i + 1);
                pf.print(". ");
                pf.println(this.ftildeArr[i]);
            }
            pf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double logLikelihood() {
        double sum = 0.0;
        int sz = this.p.data.size();
        for (int index = 0; index < sz; ++index) {
            int[] example = this.p.data.get(index);
            sum += Math.log(this.pcond(example[1], example[0]));
        }
        return sum / (double)sz;
    }

    public static double divide(double first, double second) {
        return Math.exp(first - second);
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMaximumFractionDigits(6);
            nf.setMinimumFractionDigits(6);
            LambdaSolve[] lambdas = new LambdaSolve[args.length];
            System.out.print("           ");
            for (int i = 0; i < args.length; ++i) {
                lambdas[i] = new LambdaSolve();
                lambdas[i].readL(args[i]);
                System.out.print("  " + args[i]);
            }
            System.out.println();
            int numLambda = lambdas[0].lambda.length;
            for (int j = 0; j < numLambda; ++j) {
                System.out.print("lambda[" + j + "] = ");
                for (int i = 0; i < args.length; ++i) {
                    System.out.print(nf.format(lambdas[i].lambda[j]) + "  ");
                }
                System.out.println();
            }
        } else {
            LambdaSolve prob = new LambdaSolve("trainhuge.txt.holder.prob");
            prob.save_lambdas("trainhuge.txt.holder.prob");
            prob.readL("trainhuge.txt.holder.prob");
        }
    }

    public double logLikelihoodNeg() {
        double s = 0.0;
        for (int i = 0; i < this.probConds.length; ++i) {
            for (int j = 0; j < this.probConds[i].length; ++j) {
                this.probConds[i][j] = 0.0;
            }
            this.zlambda[i] = 0.0;
        }
        int fSize = this.p.fSize;
        for (int fNo = 0; fNo < fSize; ++fNo) {
            Feature f = this.p.functions.get(fNo);
            double fLambda = -Math.exp(this.lambda[fNo]);
            double sum = this.ftildeArr[fNo];
            s -= (sum *= (double)this.p.data.getNumber()) * fLambda;
            if (Math.abs(fLambda) > 200.0) {
                System.err.println("lambda " + fNo + " too big: " + fLambda);
            }
            int length = f.len();
            for (int i = 0; i < length; ++i) {
                int x = f.getX(i);
                int y = f.getY(i);
                if (this.ASSUME_BINARY) {
                    double[] dArray = this.probConds[x];
                    int n = y;
                    dArray[n] = dArray[n] + fLambda;
                    continue;
                }
                double val = f.getVal(i);
                double[] dArray = this.probConds[x];
                int n = y;
                dArray[n] = dArray[n] + val * fLambda;
            }
        }
        for (int x = 0; x < this.probConds.length; ++x) {
            this.zlambda[x] = ArrayMath.logSum(this.probConds[x]);
            s += this.zlambda[x] * this.p.data.ptildeX(x) * (double)this.p.data.getNumber();
            for (int y = 0; y < this.probConds[x].length; ++y) {
                this.probConds[x][y] = LambdaSolve.divide(this.probConds[x][y], this.zlambda[x]);
            }
        }
        if (s < 0.0) {
            throw new IllegalStateException("neg log lik smaller than 0: " + s);
        }
        return s;
    }

    public double logLikelihoodScratch() {
        double s = 0.0;
        for (int i = 0; i < this.probConds.length; ++i) {
            for (int j = 0; j < this.probConds[i].length; ++j) {
                this.probConds[i][j] = 0.0;
            }
            this.zlambda[i] = 0.0;
        }
        Experiments exp = this.p.data;
        int fSize = this.p.fSize;
        for (int fNo = 0; fNo < fSize; ++fNo) {
            Feature f = this.p.functions.get(fNo);
            double fLambda = this.lambda[fNo];
            double sum = this.ftildeArr[fNo];
            s -= (sum *= (double)exp.getNumber()) * fLambda;
            if (Math.abs(fLambda) > 200.0) {
                System.err.println("lambda " + fNo + " too big: " + fLambda);
            }
            int length = f.len();
            for (int i = 0; i < length; ++i) {
                int x = f.getX(i);
                int y = f.getY(i);
                if (this.ASSUME_BINARY) {
                    double[] dArray = this.probConds[x];
                    int n = y;
                    dArray[n] = dArray[n] + fLambda;
                    continue;
                }
                double val = f.getVal(i);
                double[] dArray = this.probConds[x];
                int n = y;
                dArray[n] = dArray[n] + val * fLambda;
            }
        }
        for (int x = 0; x < this.probConds.length; ++x) {
            this.zlambda[x] = ArrayMath.logSum(this.probConds[x]);
            s += this.zlambda[x] * exp.ptildeX(x) * (double)exp.getNumber();
            for (int y = 0; y < this.probConds[x].length; ++y) {
                this.probConds[x][y] = LambdaSolve.divide(this.probConds[x][y], this.zlambda[x]);
            }
        }
        if (s < 0.0) {
            throw new IllegalStateException("neg log lik smaller than 0: " + s);
        }
        return s;
    }

    public double[] getDerivatives() {
        double[] drvs = new double[this.lambda.length];
        Experiments exp = this.p.data;
        for (int fNo = 0; fNo < drvs.length; ++fNo) {
            Feature f = this.p.functions.get(fNo);
            double sum = this.ftildeArr[fNo] * (double)exp.getNumber();
            drvs[fNo] = -sum;
            int length = f.len();
            for (int index = 0; index < length; ++index) {
                int x = f.getX(index);
                int y = f.getY(index);
                if (this.ASSUME_BINARY) {
                    int n = fNo;
                    drvs[n] = drvs[n] + this.probConds[x][y] * exp.ptildeX(x) * (double)exp.getNumber();
                    continue;
                }
                double val = f.getVal(index);
                int n = fNo;
                drvs[n] = drvs[n] + this.probConds[x][y] * val * exp.ptildeX(x) * (double)exp.getNumber();
            }
        }
        return drvs;
    }

    public double[] getDerivativesNeg() {
        double[] drvs = new double[this.lambda.length];
        Experiments exp = this.p.data;
        for (int fNo = 0; fNo < drvs.length; ++fNo) {
            Feature f = this.p.functions.get(fNo);
            double sum = this.ftildeArr[fNo] * (double)exp.getNumber();
            double lam = -Math.exp(this.lambda[fNo]);
            drvs[fNo] = -sum * lam;
            int length = f.len();
            for (int index = 0; index < length; ++index) {
                int x = f.getX(index);
                int y = f.getY(index);
                if (this.ASSUME_BINARY) {
                    int n = fNo;
                    drvs[n] = drvs[n] + this.probConds[x][y] * exp.ptildeX(x) * (double)exp.getNumber() * lam;
                    continue;
                }
                double val = f.getVal(index);
                int n = fNo;
                drvs[n] = drvs[n] + this.probConds[x][y] * val * exp.ptildeX(x) * (double)exp.getNumber() * lam;
            }
        }
        return drvs;
    }

    public double expectedValue() {
        double s = 0.0;
        this.aux = new double[this.probConds.length];
        for (int i = 0; i < this.probConds.length; ++i) {
            for (int j = 0; j < this.probConds[i].length; ++j) {
                this.probConds[i][j] = 0.0;
            }
            this.zlambda[i] = 0.0;
        }
        int fSize = this.p.fSize;
        for (int fNo = 0; fNo < fSize; ++fNo) {
            Feature f = this.p.functions.get(fNo);
            double fLambda = this.lambda[fNo];
            if (Math.abs(fLambda) > 200.0) {
                System.err.println("lambda " + fNo + " too big: " + fLambda);
            }
            int length = f.len();
            for (int i = 0; i < length; ++i) {
                int x = f.getX(i);
                int y = f.getY(i);
                if (this.ASSUME_BINARY) {
                    double[] dArray = this.probConds[x];
                    int n = y;
                    dArray[n] = dArray[n] + fLambda;
                    continue;
                }
                double val = f.getVal(i);
                double[] dArray = this.probConds[x];
                int n = y;
                dArray[n] = dArray[n] + val * fLambda;
            }
        }
        Experiments exp = this.p.data;
        for (int x = 0; x < this.probConds.length; ++x) {
            this.zlambda[x] = ArrayMath.logSum(this.probConds[x]);
            for (int y = 0; y < this.probConds[x].length; ++y) {
                this.probConds[x][y] = LambdaSolve.divide(this.probConds[x][y], this.zlambda[x]);
                s -= exp.values[x][y] * this.probConds[x][y] * exp.ptildeX(x) * (double)exp.getNumber();
                int n = x;
                this.aux[n] = this.aux[n] + exp.values[x][y] * this.probConds[x][y];
            }
        }
        return s;
    }

    public double[] getDerivativesExpectedValue() {
        double[] drvs = new double[this.lambda.length];
        Experiments exp = this.p.data;
        for (int fNo = 0; fNo < drvs.length; ++fNo) {
            Feature f = this.p.functions.get(fNo);
            int length = f.len();
            for (int index = 0; index < length; ++index) {
                int x = f.getX(index);
                int y = f.getY(index);
                double val = f.getVal(index);
                double mult = val * this.probConds[x][y] * exp.ptildeX(x) * (double)exp.getNumber();
                int n = fNo;
                drvs[n] = drvs[n] - mult * exp.values[x][y];
                int n2 = fNo;
                drvs[n2] = drvs[n2] + mult * this.aux[x];
            }
        }
        return drvs;
    }

    public double lossDomination() {
        double s = 0.0;
        for (int i = 0; i < this.probConds.length; ++i) {
            for (int j = 0; j < this.probConds[i].length; ++j) {
                this.probConds[i][j] = 0.0;
            }
            this.zlambda[i] = 0.0;
        }
        int fSize = this.p.fSize;
        for (int fNo = 0; fNo < fSize; ++fNo) {
            Feature f = this.p.functions.get(fNo);
            double fLambda = this.lambda[fNo];
            if (Math.abs(fLambda) > 200.0) {
                System.err.println("lambda " + fNo + " too big: " + fLambda);
            }
            int length = f.len();
            for (int i = 0; i < length; ++i) {
                int x = f.getX(i);
                int y = f.getY(i);
                if (this.ASSUME_BINARY) {
                    double[] dArray = this.probConds[x];
                    int n = y;
                    dArray[n] = dArray[n] + fLambda;
                    continue;
                }
                double val = f.getVal(i);
                double[] dArray = this.probConds[x];
                int n = y;
                dArray[n] = dArray[n] + val * fLambda;
            }
        }
        this.sum = new double[this.probConds.length][];
        this.sub = new double[this.probConds.length][];
        for (int x = 0; x < this.probConds.length; ++x) {
            int u;
            this.sum[x] = new double[this.probConds[x].length];
            this.sub[x] = new double[this.probConds[x].length];
            double localloss = 0.0;
            for (u = 0; u < this.sum[x].length; ++u) {
                boolean hasgraph = false;
                for (int v = 0; v < this.sum[x].length; ++v) {
                    if (!(this.p.data.values[x][u] > this.p.data.values[x][v])) continue;
                    hasgraph = true;
                    double[] dArray = this.sum[x];
                    int n = u;
                    dArray[n] = dArray[n] + Math.exp(this.probConds[x][v] - this.probConds[x][u]);
                }
                double[] dArray = this.sum[x];
                int n = u;
                dArray[n] = dArray[n] + 1.0;
                double weight = 1.0;
                if (this.weightRanks) {
                    weight = this.p.data.values[x][u];
                }
                if (hasgraph) {
                    int n2 = x;
                    this.zlambda[n2] = this.zlambda[n2] + weight;
                }
                localloss += weight * Math.log(this.sum[x][u]);
            }
            for (u = 0; u < this.sum[x].length; ++u) {
                for (int v = 0; v < this.sum[x].length; ++v) {
                    if (!(this.p.data.values[x][u] > this.p.data.values[x][v])) continue;
                    double weight = 1.0;
                    if (this.weightRanks) {
                        weight = this.p.data.values[x][u];
                    }
                    double[] dArray = this.sub[x];
                    int n = v;
                    dArray[n] = dArray[n] + weight * Math.exp(this.probConds[x][v] - this.probConds[x][u]) / this.sum[x][u];
                }
            }
            System.err.println(" for x " + x + " number graphs " + this.zlambda[x]);
            if (!(this.zlambda[x] > 0.0)) continue;
            s += this.p.data.ptildeX(x) * (double)this.p.data.getNumber() * (localloss /= this.zlambda[x]);
        }
        return s;
    }

    public double[] getDerivativesLossDomination() {
        double[] drvs = new double[this.lambda.length];
        for (int fNo = 0; fNo < drvs.length; ++fNo) {
            Feature f = this.p.functions.get(fNo);
            int length = f.len();
            for (int index = 0; index < length; ++index) {
                int x = f.getX(index);
                int y = f.getY(index);
                double val = f.getVal(index);
                if (this.zlambda[x] == 0.0) continue;
                double mult = val * this.p.data.ptildeX(x) * (double)this.p.data.getNumber() * (1.0 / this.zlambda[x]);
                double weight = 1.0;
                if (this.weightRanks) {
                    weight = this.p.data.values[x][y];
                }
                int n = fNo;
                drvs[n] = drvs[n] + mult * this.sub[x][y];
                int n2 = fNo;
                drvs[n2] = drvs[n2] - mult * weight * (this.sum[x][y] - 1.0) / this.sum[x][y];
            }
        }
        return drvs;
    }
}

