/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.fsm;

import edu.stanford.nlp.fsm.TransducerGraph;
import edu.stanford.nlp.stats.ClassicCounter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;

public class QuasiDeterminizer
implements TransducerGraph.GraphProcessor {
    @Override
    public TransducerGraph processGraph(TransducerGraph graph) {
        ClassicCounter lambda = QuasiDeterminizer.computeLambda(graph);
        TransducerGraph result = this.pushLambdas(graph, lambda);
        return result;
    }

    public static ClassicCounter computeLambda(TransducerGraph graph) {
        Object node2;
        LinkedList<Object> queue = new LinkedList<Object>();
        ClassicCounter<Object> lambda = new ClassicCounter<Object>();
        ClassicCounter<Object> length = new ClassicCounter<Object>();
        HashMap first = new HashMap();
        Set nodes = graph.getNodes();
        for (Object node2 : nodes) {
            lambda.setCount(node2, 0.0);
            length.setCount(node2, Double.POSITIVE_INFINITY);
        }
        Set endNodes = graph.getEndNodes();
        for (Object o : endNodes) {
            lambda.setCount(o, 0.0);
            length.setCount(o, 0.0);
            queue.addLast(o);
        }
        node2 = null;
        try {
            node2 = queue.removeFirst();
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        while (node2 != null) {
            double oldLen = length.getCount(node2);
            Set<TransducerGraph.Arc> arcs = graph.getArcsByTarget(node2);
            if (arcs != null) {
                Iterator<TransducerGraph.Arc> i$ = arcs.iterator();
                while (i$.hasNext()) {
                    TransducerGraph.Arc arc1;
                    TransducerGraph.Arc arc = arc1 = i$.next();
                    Object newNode = arc.getSourceNode();
                    Comparable a = (Comparable)arc.getInput();
                    double k = (Double)arc.getOutput();
                    double newLen = length.getCount(newNode);
                    if (newLen == Double.POSITIVE_INFINITY) {
                        queue.addLast(newNode);
                    }
                    Comparable f = (Comparable)first.get(newNode);
                    if (newLen != Double.POSITIVE_INFINITY && (newLen != oldLen + 1.0 || a.compareTo(f) >= 0)) continue;
                    first.put(newNode, a);
                    length.setCount(newNode, oldLen + 1.0);
                    lambda.setCount(newNode, k + lambda.getCount(node2));
                }
            }
            node2 = null;
            try {
                node2 = queue.removeFirst();
            }
            catch (NoSuchElementException e) {}
        }
        return lambda;
    }

    public TransducerGraph pushLambdas(TransducerGraph graph, ClassicCounter lambda) {
        TransducerGraph result = null;
        try {
            result = graph.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
        Set<TransducerGraph.Arc> arcs = result.getArcs();
        for (TransducerGraph.Arc arc : arcs) {
            double sourceLambda = lambda.getCount(arc.getSourceNode());
            double targetLambda = lambda.getCount(arc.getTargetNode());
            double oldOutput = (Double)arc.getOutput();
            double newOutput = oldOutput + targetLambda - sourceLambda;
            arc.setOutput(new Double(newOutput));
        }
        double startLambda = lambda.getCount(result.getStartNode());
        if (startLambda != 0.0) {
            Set<TransducerGraph.Arc> startArcs = result.getArcsBySource(result.getStartNode());
            for (TransducerGraph.Arc arc : startArcs) {
                double oldOutput = (Double)arc.getOutput();
                double newOutput = oldOutput + startLambda;
                arc.setOutput(new Double(newOutput));
            }
        }
        for (Object o : result.getEndNodes()) {
            double endLambda = lambda.getCount(o);
            if (endLambda == 0.0) continue;
            Set<TransducerGraph.Arc> endArcs = result.getArcsByTarget(o);
            for (TransducerGraph.Arc arc : endArcs) {
                double oldOutput = (Double)arc.getOutput();
                double newOutput = oldOutput - endLambda;
                arc.setOutput(new Double(newOutput));
            }
        }
        return result;
    }

    public static void main(String[] args) {
        QuasiDeterminizer qd = new QuasiDeterminizer();
        ArrayList pathList = new ArrayList();
        TransducerGraph graph = TransducerGraph.createRandomGraph(1000, 10, 1.0, 10, pathList);
        StringBuilder b = new StringBuilder();
        graph.depthFirstSearch(true, b);
        System.out.println(b.toString());
        System.out.println("Done creating random graph");
        TransducerGraph newGraph = qd.processGraph(graph);
        System.out.println("Done quasi-determinizing");
        TransducerGraph.testGraphPaths(graph, newGraph, 1000);
    }
}

