import pandas as pd
import matplotlib.pyplot as plt


if __name__ == '__main__':
    scores = pd.read_csv('results/scores.csv', index_col='Name')
    metrics = ['BLEU-2', 'ChrF', 'RUBY', 'CBS', 'Pass']
    ylim = {'BLEU-2': [0, 40], 'ChrF': [30, 60], 'RUBY': [30, 60], 'CBS': [60, 80], 'Pass': [20, 80]}
    mistral_sef_scores, gpt_sef_scores = {}, {}
    for m in metrics:
        mistral_sef_scores[m] = [100 * scores[m][f'mistral_t_0_1D']]
        gpt_sef_scores[m] = [100 * scores[m][f'gpt3.5_t_0_1D']]
        for i in range(9):
            mistral_sef_scores[m].append(100 * scores[m][f'mistral_t_0_{i+2}'])
            gpt_sef_scores[m].append(100 * scores[m][f'gpt3.5_t_0_{i+2}'])

    #colors = ['red', 'green', 'blue', 'purple', 'brown']
    #markers = ['+', 'x', '*', '.', 'D']
    plt.rcParams['font.family'] = 'Times New Roman'
    plt.rcParams['font.size'] = 40
    for m in metrics:
        fig, ax = plt.subplots(figsize=(20, 10))
        ax.plot(range(10), gpt_sef_scores[m], color='blue', marker='.', label='GTP-3.5-Turbo', markersize=20)
        ax.plot(range(10), mistral_sef_scores[m], color='red', marker='x', label='Mistral', markersize=20)
        ax.set_xticks(range(10))
        ax.set_ylim(ylim[m])
        ax.set_xlabel('Iteration')
        ax.set_ylabel(f'{m} Score (%)')
        ax.spines[['right', 'top']].set_visible(False)
        ax.grid(axis='y', linestyle='--', dashes=[10, 10])
        ax.legend(markerscale=1.0, loc='right')
        plt.tight_layout(pad=0.0)
        plt.savefig(f'{m}.pdf')
        plt.close()
