import random
from collections import deque
from typing import Deque, List

from const import CONTENT_SKIP
from Villager import Villager
from Util import Util

from aiwolf import (Agent, ComingoutContentBuilder, Content,
                    DivinedResultContentBuilder, EstimateContentBuilder,
                    GameInfo, GameSetting, GuardContentBuilder,
                    GuardedAgentContentBuilder, IdentContentBuilder, Judge,
                    RequestContentBuilder, Role, Species, VoteContentBuilder)
from aiwolf.constant import AGENT_ANY, AGENT_NONE
import openai
import time
import os
import copy
import json
from retry import retry
import re
# openai.api_keyにOpenAIのAPIキーを入れる
openai.api_key = os.environ['OPENAI_API_KEY']
gpt4="gpt-4-1106-preview"
gpt3="gpt-3.5-turbo-1106"
#langchain
from langchain.prompts import PromptTemplate
from langchain.chat_models import ChatOpenAI
from langchain.chains import LLMChain

# 狂人
class Possessed(Villager):
    """ddhb possessed agent."""

    fake_role: Role # 騙る役職
    """Fake role."""
    co_date: int # COする日にち
    """Scheduled comingout date."""
    has_co: bool # COしたか
    """Whether or not comingout has done."""
    my_judge_queue: Deque[Judge] # 自身の（占い or 霊媒）結果キュー
    """Queue of fake judgements."""
    not_judged_agents: List[Agent] # 占っていないエージェント
    """Agents that have not been judged."""
    num_wolves: int # 人狼数
    """The number of werewolves."""
    werewolves: List[Agent] # 人狼結果のエージェント
    """Fake werewolves."""
    PP_flag: bool # PPフラグ
    has_PP: bool # PP宣言したか
    # ----- 騙り共通 -----
    has_report: bool # 結果を報告したか
    black_count: int # 黒判定した数
    # ----- 占い騙り -----
    new_target: Agent # 偽の占い対象
    new_result: Species # 偽の占い結果
    agent_werewolf: Agent # 人狼っぽいエージェント
    my_turn:int=0


    def __init__(self) -> None:
        """Initialize a new instance of ddhbPossessed."""
        super().__init__()
        self.fake_role = Role.SEER
        self.co_date = 0
        self.has_co = False
        self.my_judge_queue = deque()
        self.not_judged_agents = []
        self.num_wolves = 0
        self.werewolves = []
        self.PP_flag = False
        self.has_PP = False
        self.has_report = False
        self.black_count = 0 # 霊媒師が黒判定した数
        self.new_target = AGENT_NONE
        self.new_result = Species.UNC
        self.agent_werewolf = AGENT_NONE
        self.strategies = []
        self.my_turn=0


    def initialize(self, game_info: GameInfo, game_setting: GameSetting) -> None:
        super().initialize(game_info, game_setting)
        # ---------- 5人村15人村共通 ----------
        self.co_date = 1
        self.has_co = False
        self.my_judge_queue.clear()
        self.not_judged_agents = self.get_others(self.game_info.agent_list)
        self.num_wolves = game_setting.role_num_map.get(Role.WEREWOLF, 0)
        self.werewolves.clear()
        self.PP_flag = False
        self.has_PP = False
        self.has_report = False
        self.black_count = 0
        self.new_target = AGENT_NONE
        self.new_result = Species.WEREWOLF
        self.agent_werewolf = AGENT_NONE
        self.my_turn=0
        
        # 自分のロールがPOSSESEDでない時、以下をスキップする
        if self.game_info.my_role != Role.POSSESSED:
            return
        
        # 戦略を検証するためのフラグ
        self.strategies = [False, True, True]
        self.strategyA = self.strategies[0] # 戦略A：一日で何回も占い結果を言う
        self.strategyB = self.strategies[1] # 戦略B：100%で占いCO
        self.strategyC = self.strategies[2] # 戦略C：15人村：COしてから占い結果
        
        # ---------- 5人村 ----------
        if self.N == 5:
            self.fake_role = Role.SEER
        # ---------- 15人村 ----------
        elif self.N == 15:
            # ----- 戦略B：100%で占いCO -----
            if self.strategyB:
                self.fake_role = Role.SEER
            else:
                # 65%の確率で占い師、35%の確率で霊媒師
                self.fake_role = Role.SEER if random.random() < 0.65 else Role.MEDIUM


    # スコアマトリックスから人狼を推測する
    def estimate_werewolf(self) -> None:
        th: float = 0.7
        game: int = Util.game_count
        # ---------- 5人村 ----------
        if self.N == 5:
            if game < 10:
                th = 0.9
            elif game < 50:
                th = 0.7
            else:
                th = 0.4
        # ---------- 15人村 ----------
        elif self.N == 15:
            th = 0.4
        self.agent_werewolf, W_prob = self.role_predictor.chooseMostLikely(Role.WEREWOLF, self.get_alive_others(self.game_info.agent_list), threshold=th, returns_prob=True)
        Util.debug_print("agent_werewolf, W_prob:\t", self.agent_werewolf, W_prob)


    def day_start(self) -> None:
        super().day_start()
        self.my_turn=0
        # 自分のロールがPOSSESEDでない時、以下をスキップする
        if self.game_info.my_role != Role.POSSESSED:
            return
        
        day: int = self.game_info.day
        if day >= 2:
            vote_list = self.game_info.vote_list
            Util.debug_print("----- day_start -----")
            Util.debug_print("vote_list:\t", self.vote_to_dict(vote_list))
            Util.debug_print("vote_cnt:\t", self.vote_cnt(vote_list))
        
        self.new_target = self.role_predictor.chooseMostLikely(Role.VILLAGER, self.get_alive_others(self.game_info.agent_list))
        self.new_result = Species.WEREWOLF
        # ----- 狩人騙り -----
        if self.fake_role == Role.BODYGUARD:
            # 護衛成功の場合
            if self.game_info.guarded_agent != None and len(self.game_info.last_dead_agent_list) == 0:
                self.has_report = False
        # ----- 他の騙り -----
        # 常に報告内容あり
        else:
            self.has_report = False
        # PP：3人以下
        alive_cnt: int = len(self.get_alive(self.game_info.agent_list))
        if alive_cnt <= 3:
            self.PP_flag = True
        self.not_judged_agents = self.get_alive_others(self.not_judged_agents)


    # CO、結果報告
    def talk(self) -> Content:
        day: int = self.game_info.day
        turn: int = self.talk_turn
        self.estimate_werewolf()
        alive_others: List[Agent] = self.get_alive_others(self.game_info.agent_list)
        # if self.is_alive(a)でaliveを保証している
        others_seer_co = [a for a in self.comingout_map if self.is_alive(a) and self.comingout_map[a] == Role.SEER]
        others_seer_co_num = len(others_seer_co)
        #self.vote_candidate = self.vote()
        talk_history = self.history(self.talk_list_all)
        for talk in talk_history:
            print("talk:",talk)
            if talk["agent"]==self.me:
                continue
        #print("talk_history:",talk_history)
        print("turn:",self.my_turn)
        if day==1 and turn==0:
            uttr="こんにちは"
            self.my_turn+=1
            return uttr
        elif turn<=6:
            #time.sleep(20)
            self.my_turn+=1
            #uttr=self.gpt_talk(talk_history,self.me,self.info,day)
            time.sleep(10)
            print(talk_history)
            uttr=self.langchain_talk(self.me,day,talk_history,self.info)
            return uttr
        else:
            self.my_turn+=1
            return "Skip"
        # ---------- PP ----------
        if self.PP_flag and not self.has_PP:
            Util.debug_print('PP: Possessed')
            self.has_PP = True
            # return Content(ComingoutContentBuilder(self.me, Role.POSSESSED))
            return Content(ComingoutContentBuilder(self.me, Role.WEREWOLF))
        # ---------- 5人村 ----------
        if self.N == 5:
            if day == 1:
                # ----- CO -----
                if turn == 1:
                    if not self.has_co:
                        self.has_co = True
                        return Content(ComingoutContentBuilder(self.me, Role.SEER))
                # ----- 結果報告 -----
                elif turn == 2:
                    if self.has_co and not self.has_report:
                        self.has_report = True
                        self.new_result = Species.WEREWOLF
                        # 候補の優先順位：対抗の占いっぽいエージェント→人狼っぽくないエージェント
                        if others_seer_co:
                            self.new_target = self.role_predictor.chooseMostLikely(Role.SEER, others_seer_co)
                        else:
                            self.new_target = self.role_predictor.chooseLeastLikely(Role.WEREWOLF, alive_others)
                        return Content(DivinedResultContentBuilder(self.new_target, self.new_result))
                # # ----- 結果報告 -----
                # if turn == 1:
                #     if not self.has_report:
                #         self.has_report = True
                #         self.new_result = Species.WEREWOLF
                #         # 候補の優先順位：対抗の占いっぽいエージェント→人狼っぽくないエージェント
                #         if others_seer_co:
                #             self.new_target = self.role_predictor.chooseMostLikely(Role.SEER, others_seer_co)
                #         else:
                #             self.new_target = self.role_predictor.chooseLeastLikely(Role.WEREWOLF, alive_others)
                #         return Content(DivinedResultContentBuilder(self.new_target, self.new_result))
                # ----- VOTE and REQUEST -----
                elif 2 <= turn <= 9:
                    if turn % 2 == 0:
                        return Content(RequestContentBuilder(AGENT_ANY, Content(VoteContentBuilder(self.new_target))))
                    else:
                        return Content(VoteContentBuilder(self.new_target))
                else:
                    return CONTENT_SKIP
            elif day >= 2:
                if turn == 1:
                    # ----- PP -----
                    # 上のPPでreturnされているから、特に必要ない
                    return Content(ComingoutContentBuilder(self.me, Role.WEREWOLF))
                # ----- VOTE and REQUEST -----
                elif 2 <= turn <= 9:
                    # 候補：人狼っぽくないエージェント
                    self.new_target = self.role_predictor.chooseLeastLikely(Role.WEREWOLF, alive_others)
                    if turn % 2 == 0:
                        return Content(RequestContentBuilder(AGENT_ANY, Content(VoteContentBuilder(self.new_target))))
                    else:
                        return Content(VoteContentBuilder(self.new_target))
                else:
                    return CONTENT_SKIP
            else:
                return CONTENT_SKIP
        # ---------- 15人村 ----------
        elif self.N == 15:
            if others_seer_co_num >= 3:
                self.fake_role = Role.MEDIUM
            # ---------- 占い騙り ----------
            if self.fake_role == Role.SEER:
                # ----- 戦略A：占い結果を複数回言う -----
                if self.strategyA:
                    self.has_report = False
                # ----- 戦略C：COしてから占い結果 -----
                if self.strategyC:
                    # ----- CO -----
                    if not self.has_co and day == self.co_date:
                        self.has_co = True
                        return Content(ComingoutContentBuilder(self.me, Role.SEER))
                    # ----- 結果報告 -----
                    if self.has_co and not self.has_report:
                        self.has_report = True
                        if day == 1:
                            # 人狼っぽくないエージェントに黒結果
                            # self.new_target = self.role_predictor.chooseLeastLikely(Role.WEREWOLF, alive_others)
                            self.new_target = self.role_predictor.chooseLeastLikely(Role.WEREWOLF, self.not_judged_agents)
                            self.new_result = Species.WEREWOLF
                        else:
                            r = random.random()
                            # 80%で人狼っぽいエージェントに白結果、20%で人狼っぽくないエージェントに黒結果
                            if r < 0.8:
                                # self.new_target = self.role_predictor.chooseMostLikely(Role.WEREWOLF, alive_others)
                                self.new_target = self.role_predictor.chooseMostLikely(Role.WEREWOLF, self.not_judged_agents)
                                self.new_result = Species.HUMAN
                            else:
                                # self.new_target = self.role_predictor.chooseLeastLikely(Role.WEREWOLF, alive_others)
                                self.new_target = self.role_predictor.chooseLeastLikely(Role.WEREWOLF, self.not_judged_agents)
                                self.new_result = Species.WEREWOLF
                        # 占い対象を占っていないエージェントから除く
                        if self.new_target in self.not_judged_agents:
                            self.not_judged_agents.remove(self.new_target)
                        return Content(DivinedResultContentBuilder(self.new_target, self.new_result))
                else:
                    # ----- 結果報告 -----
                    if turn == 1:
                        if not self.has_report:
                            self.has_report = True
                            r = random.random()
                            # 80%で人狼っぽいエージェントに白結果、20%で村人っぽいエージェントに黒結果
                            if r < 0.8:
                                self.new_target = self.role_predictor.chooseMostLikely(Role.WEREWOLF, alive_others)
                                self.new_result = Species.HUMAN
                            else:
                                self.new_target = self.role_predictor.chooseLeastLikely(Role.WEREWOLF, alive_others)
                                self.new_result = Species.WEREWOLF
                            return Content(DivinedResultContentBuilder(self.new_target, self.new_result))
            # ---------- 霊媒騙り ----------
            elif self.fake_role == Role.MEDIUM:
                # ----- CO -----
                if not self.has_co and day == self.co_date:
                    self.has_co = True
                    return Content(ComingoutContentBuilder(self.me, Role.MEDIUM))
                # ----- 結果報告 -----
                if self.has_co and not self.has_report:
                    self.has_report = True
                    target: Agent = self.game_info.executed_agent if self.game_info.executed_agent is not None else AGENT_NONE
                    result: Species = Species.HUMAN
                    if target == AGENT_NONE:
                        return CONTENT_SKIP
                    # targetが占いCO or 人狼っぽい→白結果
                    # 注意：死亡しているエージェントを含めた占いCO
                    others_seer_co = [a for a in self.comingout_map if self.comingout_map[a] == Role.SEER]
                    estimate_role: Role = self.role_predictor.getMostLikelyRole(target)
                    if target in others_seer_co or estimate_role == Role.WEREWOLF:
                        result = Species.HUMAN
                    # 2人までは黒結果
                    elif self.black_count < 2:
                        self.black_count += 1
                        result = Species.WEREWOLF
                    return Content(IdentContentBuilder(target, result))
            # ---------- 狩人騙り ----------
            elif self.fake_role == Role.BODYGUARD:
                # ----- CO -----
                # 処刑されそうになったらCO
                if not self.has_co and self.is_Low_HP():
                    self.has_co = True
                    return Content(ComingoutContentBuilder(self.me, self.fake_role))
                # ----- 結果報告 -----
                if self.has_co and not self.has_report:
                    self.has_report = True
                    # 人狼っぽいエージェントを護衛
                    guard_agent: Agent = self.role_predictor.chooseMostLikely(Role.WEREWOLF, alive_others)
                    return Content(GuardedAgentContentBuilder(guard_agent))
            # ----- ESTIMATE, VOTE, REQUEST -----
            if 2 <= turn <= 7:
                rnd = random.randint(0, 2)
                if rnd == 0:
                    return Content(EstimateContentBuilder(self.vote_candidate, Role.WEREWOLF))
                elif rnd == 1:
                    return Content(VoteContentBuilder(self.vote_candidate))
                else:
                    return Content(RequestContentBuilder(AGENT_ANY, Content(VoteContentBuilder(self.vote_candidate))))
            else:
                return CONTENT_SKIP
        return CONTENT_SKIP


    # 投票対象
    def vote(self) -> Agent:
        day: int = self.game_info.day
        game: int = Util.game_count
        talk_history = self.history(self.talk_list_all)
        self.estimate_werewolf()
        vote_candidates: List[Agent] = self.get_alive_others(self.game_info.agent_list)
        # 確定人狼がいたら除外
        if self.agent_werewolf:
            if self.agent_werewolf in vote_candidates:
                vote_candidates.remove(self.agent_werewolf)
        # ----------  同数投票の処理 ----------
        latest_vote_list = self.game_info.latest_vote_list
        if latest_vote_list:
            self.vote_candidate = self.changeVote(latest_vote_list, Role.WEREWOLF, mostlikely=False)
            # 最多投票者が自分Aともう1人Bの場合、Bが選ばれている
            # Bが人狼っぽいなら、投票を人狼っぽくないエージェントに変更する
            # これにより、自分の投票が原因で人狼が処刑されることを防ぐ
            if self.role_predictor.getMostLikelyRole(self.vote_candidate) == Role.WEREWOLF:
                self.vote_candidate = self.role_predictor.chooseLeastLikely(Role.WEREWOLF, vote_candidates)
            return self.vote_candidate if self.vote_candidate != AGENT_NONE else self.me
        # ---------- PP ----------
        if self.PP_flag:
            # 投票対象：人狼っぽくないエージェント
            self.vote_candidate = self.role_predictor.chooseLeastLikely(Role.WEREWOLF, vote_candidates)
            return self.vote_candidate if self.vote_candidate != AGENT_NONE else self.me
        # ---------- 5人村 ----------
        if self.N == 5:
            time.sleep(10)
            vote_candidate=self.langchain_vote_json(self.me,day,talk_history,self.info,self.agent_to_index(vote_candidates))
            print(vote_candidate)
            if type(vote_candidate["target"])==str:
                candidate = re.sub(r"\D","",vote_candidate["target"])
                num=[int(x) for x in list(str(candidate))]
                if len(num)==2:
                    candidate=int(num[1])
                else:
                    candidate=int(num[0])
                self.vote_candidate = candidate
            else:
                candidate = vote_candidate["target"]
                num=[int(x) for x in list(str(candidate))]
                if len(num)==2:
                    candidate=int(num[1])
                else:
                    candidate=int(num[0])
                self.vote_candidate = candidate
            print("vote_candidate:",self.vote_candidate)
            print(self.agent_to_index(vote_candidates))
            if self.vote_candidate in self.agent_to_index(vote_candidates):
                for i in vote_candidates:
                    if i.agent_idx==self.vote_candidate:
                        target=i
            else:
                if len(vote_candidates)!=0:
                    return random.choice(vote_candidates)
                else:
                    choice_agent:List[Agent]=self.get_alive(self.game_info.agent_list)
                    return random.choice(choice_agent)
            print("vote_target:",target)
            return target
            # 人狼を判別できている場合：人狼の投票先に合わせる
            """if self.agent_werewolf != AGENT_NONE:
                self.vote_candidate = self.will_vote_reports.get(self.agent_werewolf, AGENT_NONE)
                Util.debug_print('投票先\t', self.will_vote_reports_str)
                Util.debug_print(f'人狼っぽい:{self.agent_werewolf}\t投票を合わせる:{self.vote_candidate}')
                # 投票対象が自分 or 投票対象が死んでいる：処刑されそうなエージェントに投票
                if self.vote_candidate == self.me or self.vote_candidate == AGENT_NONE or not self.is_alive(self.vote_candidate):
                    self.vote_candidate = self.chooseMostlikelyExecuted2(include_list=vote_candidates)
                    Util.debug_print('処刑されそうなエージェント2:', self.vote_candidate)
            # 人狼を判別できていない or 投票対象が自分 or 投票対象が死んでいる：人狼っぽくないエージェントに投票
            elif self.agent_werewolf == AGENT_NONE or self.vote_candidate == AGENT_NONE:
                Util.debug_print("vote_candidates:\t", self.agent_to_index(vote_candidates))
                self.vote_candidate = self.role_predictor.chooseLeastLikely(Role.WEREWOLF, vote_candidates)"""
        # ---------- 15人村 ----------
        elif self.N == 15:
            # 初日：自分の黒先
            if day == 1:
                self.vote_candidate = self.new_target
            else:
                # 人狼を判別できている場合：人狼の投票先に合わせる
                if self.agent_werewolf != AGENT_NONE:
                    self.vote_candidate = self.will_vote_reports.get(self.agent_werewolf, AGENT_NONE)
                    # Util.debug_print('投票先\t', self.will_vote_reports_str)
                    Util.debug_print(f'人狼っぽい:{self.agent_werewolf}\t投票を合わせる:{self.vote_candidate}')
                # 人狼を判別できていない or 投票対象がいない or 投票対象が自分 or 投票対象が死んでいる：人狼っぽくないエージェントに投票
                if self.agent_werewolf == AGENT_NONE or self.vote_candidate == AGENT_NONE or self.vote_candidate == self.me or not self.is_alive(self.vote_candidate):
                    Util.debug_print("vote_candidates:\t", self.agent_to_index(vote_candidates))
                    self.vote_candidate = self.role_predictor.chooseLeastLikely(Role.WEREWOLF, vote_candidates)
        # ----- 投票ミスを防ぐ -----
        if self.vote_candidate == AGENT_NONE or self.vote_candidate == self.me:
            Util.debug_print("vote_candidates: AGENT_NONE or self.me")
            self.vote_candidate = self.role_predictor.chooseLeastLikely(Role.WEREWOLF, vote_candidates)
        return self.vote_candidate if self.vote_candidate != AGENT_NONE else self.me


    #エージェントの状態の作成
    def gpt_info(self):
        info_day=self.game_info.day
        info_alive=""
        for i in self.game_info.alive_agent_list:
            info_alive+=str(i)+","
        print(info_alive)
        info_executed=self.game_info.executed_agent
        info_attacked=None
        if len(self.game_info.last_dead_agent_list)!=0:
            info_attacked=self.game_info.last_dead_agent_list[0]
        text="start_day:"+str(info_day)+","+"alive_agent:"+info_alive+"yesterday_executed_agent:"+str(info_executed)+","+"yesterday_attacked_agent:"+str(info_attacked)+"\n"
        

        return text
    
    #トーク履歴作成
    def history(self,talk_list_all):
        #chatgptに渡す準備
        talk=[]
        dic={"day":-1,"turn":-1,"agent":-1,"text":""}
        talk_day=-1
        talk_turn=-1
        talk_agent=-1
        talk_text=""
        for i in talk_list_all:
            if talk_day==i.day and talk_turn==i.turn and talk_agent==i.agent._agent_idx and talk_text==i.text:
                continue
            else:
                dic['day']=i.day
                dic['turn']=i.turn
                dic['agent']=i.agent._agent_idx
                dic['text']=i.text
                talk.append(copy.deepcopy(dic))
                talk_day=i.day
                talk_turn=i.turn
                talk_agent=i.agent._agent_idx
                talk_text=i.text

        return talk
    
    def gpt_json(self,content):
        messages = [
            {"role":"system","content":"あなたは返答をすべてJSON形式で出力します。"},
            {"role":"user","content":content}
        ]
        response = openai.ChatCompletion.create(
            model="gpt-3.5-turbo",
            response_format={"type":"json_object"},
            messages=messages,
            functions=[
                {
                    "name":"utter",
                    "description":"抽出された情報をJSONとして処理します。",
                    "parameters":{
                        "type":"object",
                        "properties":{
                            "me":{
                                "type":"string",
                                "description":"自身のエージェント番号です。"
                            },
                            "target":{
                                "type":"string",
                                "description":"発言対象のエージェント番号です。対象がANYの場合はANY、いない場合はNONEとしてください。"
                            },
                            "topic":{
                                "type":"string",
                                "description":"発言内容の種類です。DUMMY:ダミートピック,ESTIMATE:推測,COMINGOUT:カミングアウト,DIVINATION:占う,DIVINED:占い結果の報告,IDENTIFIED:特定した役職の報告,GUARD:ガード,GUARDED:ガード結果の報告,VOTE:投票,VOTED:投票結果の報告,ATTACK:攻撃,ATTACKED:攻撃結果の報告,AGREE:賛成,DISAGREE:反対,Over:発言の終了,Skip:発言のスキップ,OPERATOR:オペレーターの中から選択してください。"
                            },
                            "text":{
                                "type":"string",
                                "description":"発言内容です。発話内容を日本語でそのまま入力してください。"
                            },
                        },
                    
                    },
                }
            ],
            temperature=0,
            function_call={"name":"utter"},
        )
        message = response["choices"][0]["message"]
        return json.loads(message["function_call"]["arguments"])
    
        
    @retry()
    def langchain_talk(self,my_id,day,history,info):
        # OpenAIのモデルのインスタンスを作成
        chat = ChatOpenAI(model_name=gpt4, temperature=1.0,request_timeout=30)

        prompt = PromptTemplate.from_template(
                "あなたはAgent[{my_id}]というプレイヤーで、人狼というゲームを5人でプレイしています。\n"
            + " ゲームルールは {rule} です。\n"
            + "あなたの役職は狂人です。嘘をついたりして村人陣営を混乱させ、人狼が有利になるように導いてください。\n"
            +"狂人の戦略は{plan}です。\n"
            +"今は{day}日目です。\n"
            +"現在までの各エージェントの会話は{history}です。"
            +"現在の各エージェントの状態は{info}です。"
            + " 与えられた情報をすべて理解したうえで、あなたの発言を１行で簡潔に考えてください。"
            +" 発言を考える際に、ほかのエージェントと同じ発言や、自身がした発言と同じような発言はしないでください。"
            +"あなたの発言で勝利に導いてください。"
            )

        kwargs = dict(
            my_id=my_id,
            rule="""5人のプレイヤーで村を構成する。村における役職とその人数は、「村人:2人,占い師:1人,人狼:1人,狂人:1人」である。
                村人側の役職
                村人:何も能力を持たない村人側のプレイヤー
                占い師:1日の終わりに1人のプレイヤーを占い、そのプレイヤーが人間であるか人狼であるかを知ることができる。
                
                人狼側の役職
                人狼:1日の終わりに各人狼は人間を1人選択して襲撃投票し、最も多く襲撃されたプレイヤーを襲撃する。
                狂人:村人と同じく能力は何もない人間だが、人狼の勝利を目指して行動する。占い師の能力では人間と判定される。""",
            day=day,
            history=history,
            info=info,
            plan="""1.占い師を騙る
                    2.役職ローラーを推す
                    3.人狼っぽく振舞ってみる"""
        )


        plan_prediction_chain = LLMChain(llm=chat, prompt=prompt)
        plan = plan_prediction_chain.run(**kwargs)
        plan = plan.strip()

        print(plan.strip())
        return plan.strip()
    

    @retry()
    def gpt_vote_json(self,my_id,day,history,info,vote_candidate):
        rule="""5人のプレイヤーで村を構成する。村における役職とその人数は、「村人:2人,占い師:1人,人狼:1人,裏切者:1人」である。
                村人側の役職
                村人:何も能力を持たない村人側のプレイヤー
                占い師:1日の終わりに1人のプレイヤーを占い、そのプレイヤーが人間であるか人狼であるかを知ることができる。
                
                人狼側の役職
                人狼:1日の終わりに各人狼は人間を1人選択して襲撃投票し、最も多く襲撃されたプレイヤーを襲撃する。
                裏切者:村人と同じく能力は何もない人間だが、人狼の勝利を目指して行動する。占い師の能力では人間と判定される。"""
        
        prompt="""あなたはAgent[{my_id}]というプレイヤーで、人狼というゲームを5人でプレイしています。\n
        あなたは返答をすべてJSON形式で出力します。\n
        与えられた発言に対して、自身のエージェント番号、投票対称のエージェント番号、テキストをJSON形式でパースしてください。\n
        JSONのキーはme,target,textとしてください。
        meは発言者のエージェント番号とします。わからない場合はUNKNOWNとしてください。\n
        targetは投票対称のエージェント番号とします。番号のみを出力してください。投票対象は{vote_candidate}から番号を必ず選んでください。\n
        textは投票対象を選んだ理由です。\n
        ゲームルールは {rule} です。\n
        あなたの役職は狂人です。\n
        今は{day}日目です。\n
        現在はだれに投票をするかを決めるターンです。投票が一番多かった人が処刑されます。\n
        現在までの各エージェントの会話は{history}です。\n
        現在の各エージェントの状態は{info}です。\n
        与えられた情報をすべて理解したうえで、論理的に推論をして、だれに投票をすればいいかを必ず決めて上記のjson形式で返答してください。""".format(my_id=my_id,day=day,history=history,info=info,vote_candidate=vote_candidate,rule=rule)
        messages = [
            {"role":"system","content":prompt}
        ]
        response = openai.ChatCompletion.create(
            model=gpt3,
            response_format={"type":"json_object"},
            temperature=0,
            request_timeout=30,
            messages=messages,
        )
        if response.choices[0].message.content is None:
            return {}
        else:
            return json.loads(response.choices[0].message.content)
        

    @retry()
    def langchain_vote_json(self,my_id,day,history,info,vote_candidate):

        chat = ChatOpenAI(model_name=gpt4, temperature=1.0,request_timeout=30).bind(response_format={"type": "json_object"})
        
        prompt=PromptTemplate.from_template(
        "あなたはAgent[{my_id}]というプレイヤーで、人狼というゲームを5人でプレイしています。\n"
        +"あなたは返答をすべてJSON形式で出力します。\n"
        +"与えられた発言に対して、自身のエージェント番号、追放投票対称のエージェント番号、テキストをJSON形式でパースしてください。\n"
        +"JSONのキーはme,target,textとしてください。"
        +"meは発言者のエージェント番号とします。わからない場合はUNKNOWNとしてください。\n"
        +"targetは追放投票対称のエージェント番号とします。番号のみを出力してください。追放投票対象は{vote_candidate}から番号を選んでください。\n"
        +"textは追放投票対象を選んだ理由です。\n"
        +"ゲームルールは {rule} です。\n"
        +"あなたの役職は狂人です。人狼が有利になるように追放投票対象を考えてください。\n"
        +"今は{day}日目です。\n"
        +"現在はだれに追放投票をするかを決めるターンです。追放投票が一番多かった人が処刑されます。\n"
        +"現在までの各エージェントの会話は{history}です。\n"
        +"現在の各エージェントの状態は{info}です。\n"
        +"与えられた情報をすべて理解したうえで、論理的に推論をして、だれに追放投票をすればいいか決めて上記のjson形式で返答してください。\n"
        +"情報が少ない場合でもだれに投票するかを必ず決めてください。"
        )

        kwargs = dict(
            my_id=my_id,
            rule="""5人のプレイヤーで村を構成する。村における役職とその人数は、「村人:2人,占い師:1人,人狼:1人,狂人:1人」である。
                村人側の役職
                村人:何も能力を持たない村人側のプレイヤー
                占い師:1日の終わりに1人のプレイヤーを占い、そのプレイヤーが人間であるか人狼であるかを知ることができる。
                
                人狼側の役職
                人狼:1日の終わりに各人狼は人間を1人選択して襲撃投票し、最も多く襲撃されたプレイヤーを襲撃する。
                狂人:村人と同じく能力は何もない人間だが、人狼の勝利を目指して行動する。占い師の能力では人間と判定される。
                追放のための投票は昼フェーズの最後に行われます。 有効な投票先（自分以外の生存プレイヤー）以外に投票することは可能ですが， その場合はランダムに投票先が選ばれます。

                追放投票と再投票
                投票によって決定した追放者の情報は， 夜フェーズの占い・護衛・襲撃投票に利用することが可能です。
                最多得票者が複数となった場合は1回に限り再投票となります。
                再投票の前に対話はできません。 再投票でも同点だった場合は再投票での最多得票者からランダムに追放者が決定されます。 
                再投票では，最多得票者も投票権を持ち，投票者は最多得票者以外にも投票可能です。""",
            day=day,
            history=history,
            info=info,
            vote_candidate=vote_candidate
        )
        plan_prediction_chain = LLMChain(llm=chat, prompt=prompt)
        plan = plan_prediction_chain.run(**kwargs)
        if plan is None:
            return {}
        else:
            return json.loads(plan)