import nlpaug.augmenter.char.random as nac
import csv
import re
import random

data = []
with open("data-augmentation-for-trec/data/labeled.tsv") as file:
    tsv_file = csv.reader(file, delimiter="\t")
    for line in tsv_file:
        data.append(line[0])
data = data[1:]

split_data = []
for i in range(len(data)):
  split_data.append(data[i].split(" ", 1))

print("Example of data:", split_data[0])

syn_data = []
RECOMMENDED_CHARACTER_METHODS = ["insert", "substitute", "swap", "delete"]

for _ in range(1): # 9 (low-resource) or 2 (half)
  for i in range(len(split_data)):
    method = RECOMMENDED_CHARACTER_METHODS[random.randint(0,3)]
    conv_aug = nac.RandomCharAug(action=method, aug_char_p=0.1, include_upper_case=False,
                                    include_numeric=False, spec_char =' ')
    txt = split_data[i][1]
    new_txt = conv_aug.augment(txt)[0]
    syn_data.append(split_data[i][0]+' '+new_txt)

syn_data = syn_data + data

print("size of train data:", len(split_data))
print("size of augmented data:", len(syn_data))

with open("data-augmentation-for-trec/aug_data/labeled.tsv", "w") as file:
  writer = csv.writer(file)
  writer.writerow(["fine_label utterance"])


with open("data-augmentation-for-trec/aug_data/labeled.tsv", "a") as file:
  writer = csv.writer(file, delimiter='\n', quotechar='', quoting=csv.QUOTE_NONE)
  writer.writerow(syn_data)


