from django.test import TestCase
import uuid
# Create your tests here.
from evalAdv.models import ExpectationItem, SessionItem, DistractorItem, AnswerItem, CombinedSessionItem
import datetime
from django.test import Client
import unittest

class DataTestCase(TestCase):
    def test_db_io(self):

        this_item = ExpectationItem(
            task_string="Wählen Sie das Intervall so, dass der Ausdruck logisch klingt.",
            item_id=1, 
            expression="Wie viel PS hat das Auto?",
            min_val=0, 
            max_val=100, 
            physical_unit="PS",
            stepsize=1,
            
            task_string_us="Please choose the interval of values such that the expression is acceptable.",
            expression_us="How much HP does your car have?",
            min_val_us=0, 
            max_val_us=100, 
            physical_unit_us="HP", 
            lower_def = 5, 
            upper_def=95,
            source_feature="PS",
            target_feature="PS"
        )

        # make up a session
        this_item.save()
        session_id=1
        participant_id = str(uuid.uuid4())
        session_unit="us"
        this_time = datetime.datetime.now()


        this_session=SessionItem(
            item_id = this_item,
            session_id=session_id,
            unit_type=session_unit,
            lower_limes=20,
            upper_limes=80,
            participant_id=participant_id,
            date_time_stamp=this_time,
        )
        this_session.save()

        a=SessionItem.objects.all()[0]
        self.assertEqual(a.item_id, this_item)
        self.assertEqual(session_id, a.session_id)
        self.assertEqual(session_unit, a.unit_type)
        self.assertEqual(a.participant_id, participant_id)
        self.assertEqual(a.upper_limes, 80)
        self.assertEqual(a.lower_limes, 20)

    def testDistractorItem(self):

        dist = DistractorItem(

            question_id=1,
            task_string="Bitte antworten Sie auf die unten stehende Frage",
            question_text="Welchen Autotyp bevorzugen Sie?",
            option_1 = "tiny",
            option_2 = "SUV",
            option_3 = "sportscar",

            task_string_us="Please answer the question below",
            question_text_us="Which car type do you prefer?",
            option_1_us = "tiny",
            option_2_us = "SUV",
            option_3_us = "sportscar"

        )        

        dist.save()


        participant_id = str(uuid.uuid4())
        session_unit="us"
        this_time = datetime.datetime.now()

        ans = AnswerItem(
            
            question_id=dist,
            unit_type=session_unit,
            answer_string=dist.option_1_us,
            participant_id=participant_id,

        )

        ans.save()

        self.assertEqual(ans.question_id, dist)
        self.assertEqual(ans.unit_type, session_unit)
        self.assertEqual(ans.participant_id, participant_id)
        self.assertEqual(ans.answer_string, dist.option_1_us)
    


class SessionTest(TestCase):
    def setUp(self):

        self.client = Client()

        this_item = ExpectationItem(
            task_string="Wählen Sie das Intervall so, dass der Ausdruck logisch klingt.",
            item_id=1, 
            expression="Wie viel PS hat das Auto?",
            min_val=0, 
            max_val=100, 
            physical_unit="PS",
            stepsize=1,
            
            task_string_us="Please choose the interval of values such that the expression is acceptable.",
            expression_us="How much HP does your car have?",
            min_val_us=0, 
            max_val_us=100, 
            physical_unit_us="HP", 
            lower_def = 5, 
            upper_def=95,
            source_feature="PS",
            target_feature="PS"
        )

        this_item.save()

        dist = DistractorItem(

            question_id=1,
            task_string="Bitte antworten Sie auf die unten stehende Frage",
            question_text="Welchen Autotyp bevorzugen Sie?",
            option_1 = "tiny",
            option_2 = "SUV",
            option_3 = "sportscar",

            task_string_us="Please answer the question below",
            question_text_us="Which car type do you prefer?",
            option_1_us = "tiny",
            option_2_us = "SUV",
            option_3_us = "sportscar"

        )        
        

        dist.save()

    def test_db_non_empty(self):
        self.assertEqual(len(ExpectationItem.objects.all()),1)
        self.assertEqual(len(DistractorItem.objects.all()),1)
                

    def test_index(self):

        response = self.client.get('/evalAdv/')
        self.assertEqual(response.status_code, 200)
        
        session = self.client.session
        self.assertEqual(session["allItemIds"], [1])
        self.assertEqual(session["session_id"], 1)



    def test_intro(self):
        
        response = self.client.post('/evalAdv/intro', {"unit":"us", "prolificid":"abcdef123456789abcdef123"})
        #response = self.client.get('/evalAdv/intro')
        
        self.assertEqual(response.status_code, 200)

        session = self.client.session
        self.assertEqual(session["unit"], "us")

    def test_prepare_for_sessions(self):
        self.client.get('/evalAdv/')
        response = self.client.post('/evalAdv/intro', {"unit":"us", "prolificid":"abcdef123456789abcdef123"})

        #response = self.client.get('/evalAdv/intro')
        
        self.assertEqual(response.status_code, 200)

        
        response = self.client.get('/evalAdv/prepare', follow=True)
        
        self.assertEqual(response.status_code, 200)
        session = self.client.session
        self.assertEqual(session["unit"], "us")
        self.assertIn("this_type", list(session.keys()))
        



    def test_empty_item_prepare(self):
        self.client.get('/evalAdv/')
        
        session = self.client.session
        session["allItemIds"] = list([])
        session["allDistIds"] = [1]
        session.save()
        
        response = self.client.post('/evalAdv/intro', {"unit":"us", "prolificid":"abcdef123456789abcdef123"})
        #response = self.client.get('/evalAdv/intro')
        self.assertEqual(response.status_code, 200)
       
        response = self.client.get('/evalAdv/prepare', follow=True)
        
        self.assertEqual(response.status_code, 200)
        session = self.client.session
        self.assertIn("this_type", list(session.keys()))
        self.assertEqual(session["this_type"], "dist")
        


    def test_empty_dist_prepare(self):
        self.client.get('/evalAdv/')
        session = self.client.session
        session["allDistIds"] = list([])
        session["allItemIds"] = [1]
        session.save()
        
        response = self.client.post('/evalAdv/intro', {"unit":"us", "prolificid":"abcdef123456789abcdef123"})
        #response = self.client.get('/evalAdv/intro')
        self.assertEqual(response.status_code, 200)
        
        response = self.client.get('/evalAdv/prepare', follow=True)
        
        self.assertEqual(response.status_code, 200)
        session = self.client.session
        self.assertIn("this_type", list(session.keys()))
        self.assertEqual(session["this_type"], "item")




    def test_item_session(self):


        self.client.get('/evalAdv/')
        self.client.post('/evalAdv/intro', {"unit":"us", "prolificid":"abcdef123456789abcdef123"})
        self.client.get('/evalAdv/prepare')

        sess = self.client.session 
        pid = sess["participant_id"]
        sid = sess["session_id"]

        sess["this_type"] = "item"
        sess.save()
        
        self.client.get('/evalAdv/sessions')
        
        session = self.client.session 
            
        response = self.client.post('/evalAdv/get_user_input', {"left_slider":44, "right_slider":66}, follow=True)
        self.assertEqual(response.status_code, 200)
        
    
        last_item = session["prev_s_item"]
        this_item = ExpectationItem.objects.get(pk=last_item)

        this_session_item = SessionItem.objects.filter(participant_id=pid).filter(session_id=sid)
        self.assertEqual(len(this_session_item), 1)
        this_session_item = this_session_item[0]
        self.assertEqual(this_session_item.item_id, this_item)
        self.assertEqual(this_session_item.lower_limes, 44)
        self.assertEqual(this_session_item.upper_limes, 66)

            

    def test_dist_session(self):


        self.client.get('/evalAdv/')
        self.client.post('/evalAdv/intro', {"unit":"us", "prolificid":"abcdef123456789abcdef123"})
        self.client.get('/evalAdv/prepare')

        sess = self.client.session 
        pid = sess["participant_id"]
        sid = sess["session_id"]

        sess["this_type"] = "dist"
        sess.save()
        
        self.client.get('/evalAdv/sessions')
        
        session = self.client.session 



        response = self.client.post('/evalAdv/get_user_input', {"dist":"tiny"}, follow=True)
        self.assertEqual(response.status_code, 200)            
        
        
        last_dist = session["prev_s_dist"]
        this_dist = DistractorItem.objects.get(pk=last_dist)

        this_answer_item = AnswerItem.objects.filter(participant_id=pid).filter(question_id=this_dist.question_id)
        self.assertEqual(len(this_answer_item), 1)
        this_answer_item = this_answer_item[0]
        self.assertEqual(this_answer_item.answer_string, "tiny")
            
            
        


    def test_item_id_increment(self):


        self.client.get('/evalAdv/')
        self.client.post('/evalAdv/intro', {"unit":"us", "prolificid":"abcdef123456789abcdef123"})
        self.client.get('/evalAdv/prepare')

        sess = self.client.session 
        sess["this_type"] = "item"
        sess.save()
        
        self.client.get('/evalAdv/sessions')

        session = self.client.session 
        pid = session["participant_id"]
        sid = session["session_id"]
        
            
        response = self.client.post('/evalAdv/get_user_input', {"left_slider":44, "right_slider":66}, follow=True)
        self.assertEqual(response.status_code, 200)
        session = self.client.session
        self.assertEqual(session["session_id"], sid+1)
    
        


    def test_dist_id_increment(self):


        self.client.get('/evalAdv/')
        self.client.post('/evalAdv/intro', {"unit":"us", "prolificid":"abcdef123456789abcdef123"})
        self.client.get('/evalAdv/prepare')
        
        sess = self.client.session 
        sess["this_type"] = "dist"
        sess.save()
        
        
        self.client.get('/evalAdv/sessions')

        session = self.client.session 
        pid = session["participant_id"]
        sid = session["session_id"]
        
        
        response = self.client.post('/evalAdv/get_user_input', {"dist":"tiny"}, follow=True)
    
        self.assertEqual(response.status_code, 200)
        self.assertEqual(session["session_id"], sid)




    def test_remove_prev_item(self):
        self.client.get('/evalAdv/')
        self.client.post('/evalAdv/intro', {"unit":"us", "prolificid":"abcdef123456789abcdef123"})
        self.client.get('/evalAdv/prepare')
        
        sess = self.client.session 
        sess["this_type"] = "item"
        sess.save()
        

        self.client.get('/evalAdv/sessions')

        session = self.client.session 
        pid = session["participant_id"]
        sid = session["session_id"]
        
        response = self.client.post('/evalAdv/get_user_input', {"left_slider":44, "right_slider":66}, follow=True)
        self.assertEqual(response.status_code, 200)
        session = self.client.session
        self.assertNotIn(session["prev_s_item"], session["allItemIds"])



    def test_remove_prev_dist(self):
        self.client.get('/evalAdv/')
        self.client.post('/evalAdv/intro', {"unit":"us", "prolificid":"abcdef123456789abcdef123"})

        self.client.get('/evalAdv/prepare')
        
        sess = self.client.session 
        sess["this_type"] = "dist"
        sess.save()
        

        self.client.get('/evalAdv/sessions')

        session = self.client.session 
        pid = session["participant_id"]
        sid = session["session_id"]
        
        response = self.client.post('/evalAdv/get_user_input', {"dist":"tiny"}, follow=True)
    
        self.assertEqual(response.status_code, 200)
        session = self.client.session
        self.assertNotIn(session["prev_s_dist"], session["allDistIds"])



    def test_item_language_us(self):

        self.client.get('/evalAdv/')
        self.client.post('/evalAdv/intro', {"unit":"us", "prolificid":"abcdef123456789abcdef123"})
        self.client.get('/evalAdv/prepare')

        sess = self.client.session 
        sess["this_type"] = "item"
        sess.save()
        
        
        response = self.client.get('/evalAdv/sessions')
        session = self.client.session

        
        this_item = ExpectationItem.objects.get(pk=session["prev_s_item"])

        self.assertEqual(response.context["expectation_string"], this_item.expression_us)            
        self.assertEqual(response.context["min_val"], this_item.min_val_us)            
        self.assertEqual(response.context["max_val"], this_item.max_val_us)            
        self.assertEqual(response.context["unit"], this_item.physical_unit_us)            
            
            




    def test_dist_language_us(self):

        self.client.get('/evalAdv/')
        self.client.post('/evalAdv/intro', {"unit":"us", "prolificid":"abcdef123456789abcdef123"})
        self.client.get('/evalAdv/prepare')

        sess = self.client.session 
        sess["this_type"] = "dist"
        sess.save()
        
        
        response = self.client.get('/evalAdv/sessions')
        session = self.client.session

        this_dist = DistractorItem.objects.get(pk=session["prev_s_dist"])
        self.assertEqual(response.context["question_text"], this_dist.question_text_us)
        self.assertEqual(response.context["option_1"], this_dist.option_1_us)
        self.assertEqual(response.context["option_2"], this_dist.option_2_us)
        self.assertEqual(response.context["option_3"], this_dist.option_3_us)
            




        
    def test_item_language_de(self):
        self.client.get('/evalAdv/')
        self.client.post('/evalAdv/intro', {"unit":"metric", "prolificid":"abcdef123456789abcdef123"})

        self.client.get('/evalAdv/prepare')

        sess = self.client.session 
        sess["this_type"] = "item"
        sess.save()
        

        response = self.client.get('/evalAdv/sessions')
        session = self.client.session


        this_item = ExpectationItem.objects.get(pk=session["prev_s_item"])

        self.assertEqual(response.context["expectation_string"], this_item.expression)            
        self.assertEqual(response.context["min_val"], this_item.min_val)            
        self.assertEqual(response.context["max_val"], this_item.max_val)            
        self.assertEqual(response.context["unit"], this_item.physical_unit)            
            
            


    def test_dist_language_de(self):
        self.client.get('/evalAdv/')
        self.client.post('/evalAdv/intro', {"unit":"metric", "prolificid":"abcdef123456789abcdef123"})

        self.client.get('/evalAdv/prepare')

        sess = self.client.session 
        sess["this_type"] = "dist"
        sess.save()
        

        response = self.client.get('/evalAdv/sessions')
        session = self.client.session

            
        this_dist = DistractorItem.objects.get(pk=session["prev_s_dist"])
        self.assertEqual(response.context["question_text"], this_dist.question_text)
        self.assertEqual(response.context["option_1"], this_dist.option_1)
        self.assertEqual(response.context["option_2"], this_dist.option_2)
        self.assertEqual(response.context["option_3"], this_dist.option_3)
            

    def test_worker_id_submission_item(self):
        
        self.client.get('/evalAdv/')
        self.client.post('/evalAdv/intro', {"unit":"us", "prolificid":"abcdef123456789abcdef123"})
        self.client.get('/evalAdv/prepare')

        sess = self.client.session 
        pid = sess["participant_id"]
        sid = sess["session_id"]

        sess["this_type"] = "item"
        sess.save()
        
        self.client.get('/evalAdv/sessions')
        
        session = self.client.session 
            
        response = self.client.post('/evalAdv/get_user_input', {"left_slider":44, "right_slider":66}, follow=True)
        self.assertEqual(response.status_code, 200)
        
    
        last_item = session["prev_s_item"]
        this_item = ExpectationItem.objects.get(pk=last_item)

        this_session_item = SessionItem.objects.filter(participant_id=pid).filter(session_id=sid)
        self.assertEqual(len(this_session_item), 1)
        this_session_item = this_session_item[0]
        self.assertEqual(this_session_item.item_id, this_item)
        self.assertEqual(this_session_item.lower_limes, 44)
        self.assertEqual(this_session_item.upper_limes, 66)
        self.assertEqual(this_session_item.prolific_id, "abcdef123456789abcdef123")



    def test_worker_id_submission_dist(self):


        self.client.get('/evalAdv/')
        self.client.post('/evalAdv/intro', {"unit":"us", "prolificid":"abcdef123456789abcdef123"})
        self.client.get('/evalAdv/prepare')

        sess = self.client.session 
        pid = sess["participant_id"]
        sid = sess["session_id"]

        sess["this_type"] = "dist"
        sess.save()
        
        self.client.get('/evalAdv/sessions')
        
        session = self.client.session 



        response = self.client.post('/evalAdv/get_user_input', {"dist":"tiny"}, follow=True)
        self.assertEqual(response.status_code, 200)            
        
        
        last_dist = session["prev_s_dist"]
        this_dist = DistractorItem.objects.get(pk=last_dist)

        this_answer_item = AnswerItem.objects.filter(participant_id=pid).filter(question_id=this_dist.question_id)
        self.assertEqual(len(this_answer_item), 1)
        this_answer_item = this_answer_item[0]
        self.assertEqual(this_answer_item.answer_string, "tiny")
        self.assertEqual(this_answer_item.prolific_id, "abcdef123456789abcdef123")




    def test_invalid_worker_id(self):


        self.client.get('/evalAdv/')
        response = self.client.post('/evalAdv/intro', {"unit":"us", "prolificid":"abcdef"})
        self.assertEqual(response.status_code, 302)
        


    def test_combined_item_us(self):


        self.client.get('/evalAdv/')
        self.client.post('/evalAdv/intro', {"unit":"us", "prolificid":"abcdef123456789abcdef123"})
        self.client.get('/evalAdv/prepare')

        sess = self.client.session 
        pid = sess["participant_id"]
        
        
        self.client.get('/evalAdv/combined_session')
        
        session = self.client.session 
            
        response = self.client.post('/evalAdv/get_combined_session_input', {"left_slider_1":80, 
                                                                "right_slider_1":100,
                                                                "left_slider_2":120, 
                                                                "right_slider_2":180,
                                                                "left_slider_3":140, 
                                                                "right_slider_3":250}, 
                                                                follow=True)
        self.assertEqual(response.status_code, 200)
        
    
        
        this_session_item = CombinedSessionItem.objects.filter(participant_id=pid)
        self.assertEqual(len(this_session_item), 1)
        this_session_item = this_session_item[0]
        self.assertEqual(this_session_item.lower_limes_1, 80)
        self.assertEqual(this_session_item.upper_limes_1, 100)
        self.assertEqual(this_session_item.lower_limes_2, 120)
        self.assertEqual(this_session_item.upper_limes_2, 180)
        self.assertEqual(this_session_item.lower_limes_3, 140)
        self.assertEqual(this_session_item.upper_limes_3, 250)



    def test_combined_item_de(self):


        self.client.get('/evalAdv/')
        self.client.post('/evalAdv/intro', {"unit":"metric", "prolificid":"abcdef123456789abcdef123"})
        self.client.get('/evalAdv/prepare')

        sess = self.client.session 
        pid = sess["participant_id"]
        
        
        self.client.get('/evalAdv/combined_session')
        
        session = self.client.session 
            
        response = self.client.post('/evalAdv/get_combined_session_input', {"left_slider_1":80, 
                                                                "right_slider_1":100,
                                                                "left_slider_2":120, 
                                                                "right_slider_2":180,
                                                                "left_slider_3":140, 
                                                                "right_slider_3":250}, 
                                                                follow=True)
        self.assertEqual(response.status_code, 200)
        
    

        this_session_item = CombinedSessionItem.objects.filter(participant_id=pid)
        self.assertEqual(len(this_session_item), 1)
        this_session_item = this_session_item[0]
        self.assertEqual(this_session_item.lower_limes_1, 80)
        self.assertEqual(this_session_item.upper_limes_1, 100)
        self.assertEqual(this_session_item.lower_limes_2, 120)
        self.assertEqual(this_session_item.upper_limes_2, 180)
        self.assertEqual(this_session_item.lower_limes_3, 140)
        self.assertEqual(this_session_item.upper_limes_3, 250)






    def test_follow_combined_us(self):


        self.client.get('/evalAdv/')
        self.client.post('/evalAdv/intro', {"unit":"us", "prolificid":"abcdef123456789abcdef123"})
        
        sess = self.client.session 
        pid = sess["participant_id"]
        sess["allItemIds"] = []
        sess["allDistIds"] = []
        sess.save()


        resp = self.client.get('/evalAdv/prepare', follow=True)
        redirect_url = resp.redirect_chain[0][0]
        self.assertIn("evalAdv/combined_session", redirect_url)


    def test_follow_combined_de(self):


        self.client.get('/evalAdv/')
        self.client.post('/evalAdv/intro', {"unit":"metric", "prolificid":"abcdef123456789abcdef123"})
        
        sess = self.client.session 
        pid = sess["participant_id"]
        sess["allItemIds"] = []
        sess["allDistIds"] = []
        sess.save()


        resp = self.client.get('/evalAdv/prepare', follow=True)
        redirect_url = resp.redirect_chain[0][0]
        self.assertIn("evalAdv/combined_session", redirect_url)

        
    