# Supervising and Augmenting Intermediate Steps (SAIS)


## Requirements

```
PyTorch = 1.9.0
HuggingFace Transformers = 4.8.1

```

## Run

Given an input dataset (e.g., _DocRED_):

1. The ```Data/{dataset}/Original``` folder contains the original files provided by the corresponding dataset that are necessary for our experiments.
1. The command ```bash prepare.sh``` transforms the original data structure into the structure acceptable to our model and stores the output files in the ```Data/{dataset}/Processed``` folder.
1. The command ```bash main.sh``` trains the model, writes the standard output in the ```Data/{dataset}/Stdout``` folder, and delivers the set of predicted relations and corresponding evidence for the develop and test sets in the ```Data/{dataset}/Processed``` folder.

The set of hyperparameters for Step 2 and 3 are specified in ```prepare.sh``` and ```main.sh```, respectively. 