log_file=log_test.txt
sh_mode=1 # 0 for train and 1 for test
if [ $1 != '' ]; then
    sh_mode=$1
fi
echo 'sh_mode:' ${sh_mode}
cuda=0
echo 'using cuda:' $cuda
if [ ${sh_mode} == 0 ]; then
echo 'train!'
CUDA_VISIBLE_DEVICES=$cuda python main_bert_rawtext.py --gpus=1 --model_choice=use_img_clip --max_image_id=307 \
    --fix_text=false --fix_img=true --train_data_path=./data/train_pair.json --train_batch_size=8 \
    --add_emotion_task=false --add_predict_context_task=false --add_predict_img_label_task=false --add_ocr_info=false \
    --img_lr=5e-7 --other_lr=9e-6 --sent_num=0 --gradient_accumulation_steps=1 2>&1 | tee $log_file
elif [ ${sh_mode} == 1 ]; then
echo 'test!'
for with_cand in true false ;
do 
    for test_path in test_easy test_hard ;
    do
    echo $with_cand $test_path 2>&1 | tee -a $log_file
    CUDA_VISIBLE_DEVICES=$cuda python main_bert_rawtext.py --gpus=1 --max_image_id=307 --add_ocr_info=true --test_with_cand=${with_cand} \
        --sent_num=0 --valtest_batch_size=1 --ckpt_epoch=2 --add_emotion_task=true --add_predict_context_task=true --add_predict_img_label_task=false \
        --mode=test --test_data_path=./data/${test_path}.json --ckpt_path=./logs/clip/lightning_logs/version_85/checkpoints --ocr_path=./data/ocr_max10.json 2>&1 | tee -a $log_file
    done
done 
else 
echo 'predict img label'
CUDA_VISIBLE_DEVICES=$cuda python main_bert_rawtext.py --gpus=1 --model_choice=use_img_clip --max_image_id=307 \
    --sent_num=1 --valtest_batch_size=1 --ckpt_epoch=8 --test_with_cand=false --add_predict_img_label_task=true \
    --mode=predict_img_label --test_data_path=./data/test_easy.json --ckpt_path=./logs/clip/lightning_logs/version_90/checkpoints
fi

