import sys
import os


def main(confidence_file, outfile):
    f = open(confidence_file, 'r')
    lines = [l.strip('\n') for l in f]

    conf_score = []
    current_score = 1.0
    for i in range(len(lines)):
        if 'WARNING' in lines[i]:
            continue
        if lines[i] != '-----':
            current_score *= float(lines[i])
        else:
            conf_score.append(current_score)
            current_score = 1.0

    # write
    fw = open(outfile, 'w')
    for score in conf_score:
        fw.write(str(score)+'\n')

def compare_confidence(adv_conf_file, org_conf_file):
    # see how many percent of data 
    # adv's confidence is larger than original
    adv_conf = [float(l.strip('\n')) for l in open(adv_conf_file)]
    org_conf = [float(l.strip('\n')) for l in open(org_conf_file)]

    assert len(adv_conf) == len(org_conf)
    greater = 0.0
    for i in range(len(adv_conf)):
        if adv_conf[i] > org_conf[i]:
            greater += 1

    print('Proportion that adv > org: %f'%(100*(greater/len(adv_conf))))

if __name__ == '__main__':
    
    # you need to first use run_test.sh to get model confidence
    # sys.argv[1] -> confidence_outputs/org/auto/mod_modality_model_scores_auto_org.txt
    # sys.argv[2] -> confidence_scores/org/auto/mod_modality_model_scores_auto_org.txt
    #main(sys.argv[1], sys.argv[2])

    compare_confidence(sys.argv[1], sys.argv[2])
