"""Checking function for NULL operators (NONE and OPPOSITE)."""

from preprocess.position_utils import LinkedPosition
from preprocess.operation.formula_utils import NullFormula



def relink_cells(cells_dict):
    """Alter from (irow,icol):cell to (pos,cell)."""
    linked_positions, cells = [], []
    for cm_coord, cell in cells_dict.items():
        pos = LinkedPosition.from_cm_coords(cm_coord)
        linked_positions.append(pos)
        cells.append(cell)
    return linked_positions, cells




def check_null(structure, subdict, operator='none'):
    """operator be 'none' or 'opp'."""
    formula = NullFormula(
        start_row=subdict['start_row'], 
        name=operator.upper()
    ) 
    answer_positions, answer_cells = relink_cells(subdict['answer_cells'])

    if operator == 'opp':
        answer_parts = []
        for ac in answer_cells:
            try: neg_ac = -float(ac)
            except: neg_ac = ac[1:]
            answer_parts.append(f'{neg_ac}')
        answer = ','.join(answer_parts)
    else:
        answer = ','.join([f'{ac}' for ac in answer_cells])
    formula.answer = answer

    formula.get_formula(linked_positions=answer_positions)
    return formula
