/*
 * Decompiled with CFR 0.152.
 */
import edu.cmu.meteor.util.Constants;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class Stemmer {
    public static void main(String[] stringArray) throws Throwable {
        String string;
        if (stringArray.length != 1) {
            System.err.println("Snowball stem some text in a supported language");
            System.err.println("Languages: en ar da de es fi fr hu it nl no pt ro ru se tr");
            System.err.println("Usage: Stemmer lang < in > out");
            System.exit(1);
        }
        String string2 = Constants.normLanguageName(stringArray[0]);
        edu.cmu.meteor.aligner.Stemmer stemmer = Constants.newStemmer(string2);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while ((string = bufferedReader.readLine()) != null) {
            StringBuilder stringBuilder = new StringBuilder();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!Stemmer.isNumber(string3)) {
                    string3 = stemmer.stem(string3);
                }
                stringBuilder.append(" " + string3);
            }
            System.out.println(stringBuilder.toString().trim());
        }
    }

    private static boolean isNumber(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i)) || string.charAt(i) == ',' || string.charAt(i) == '.' || string.charAt(i) == '-') continue;
            return false;
        }
        return true;
    }
}

